set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9966597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.784968,
      1,
      0,
      2.231982,
      NULL,
      3.348269,
      NULL,
      NULL,
      '210',
      '34423243',
      NULL,
      45.040120,
      '4241043',
      2.387875,
      NULL,
      NULL,
      NULL,
      '4104',
      2,
      1,
      NULL,
      NULL,
      ' 3-18-1989',
      57.869432,
      NULL,
      NULL,
      2.811688,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9-24-1998',
      ' 1- 7-1989',
      NULL,
      1.758820,
      2.295786,
      NULL,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.588459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      1,
      1,
      4,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      0,
      NULL,
      10,
      NULL,
      1,
      NULL,
      0,
      0.475968,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2.480339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      0,
      5,
      3,
      1,
      NULL,
      5,
      1,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      1,
      1.825856,
      NULL,
      0.386773,
      NULL,
      2,
      3,
      4,
      1,
      2,
      5,
      0,
      1,
      1,
      1,
      0,
      2,
      2,
      1,
      2,
      5,
      3,
      4,
      NULL,
      NULL,
      3,
      2,
      4,
      3,
      3,
      3.905511,
      ' 3- 6-1987',
      59,
      NULL,
      NULL,
      3,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      2,
      1.339133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.972195,
      0.830456,
      3.005158,
      1.887164,
      1,
      NULL,
      1.590344,
      NULL,
      NULL,
      NULL,
      0,
      0.888802,
      9,
      4,
      0.522195,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      7,
      0.097222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.735384,
      0,
      1,
      0.809998,
      0.720545,
      NULL,
      10,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170243,
      0.333406,
      3,
      0,
      1,
      3,
      3,
      NULL,
      3,
      1,
      NULL,
      2,
      3.401186,
      1,
      3.667571,
      3,
      0,
      1.418898,
      1.414169,
      1.877970,
      0.047141,
      0.928225,
      1,
      1,
      0.458144,
      1.352689,
      1,
      0,
      0,
      1.325920,
      1,
      NULL,
      9.666373,
      NULL,
      6,
      NULL,
      2.475889,
      2.056272,
      0.773212,
      3,
      NULL,
      3,
      0.758137,
      40,
      0,
      0.988883,
      62,
      NULL,
      51,
      60,
      5,
      2,
      NULL,
      NULL,
      '00111',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3,
      40,
      45.532364,
      17.278086,
      0.014419,
      NULL,
      NULL,
      NULL,
      NULL,
      3.912190,
      2,
      1,
      1.711497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.570591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.149083,
      0,
      0.976094,
      NULL,
      0,
      0.657803,
      1,
      NULL,
      NULL,
      1.486982,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.749113,
      1.637183,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938586,
      NULL,
      NULL,
      NULL,
      0.981702,
      NULL,
      NULL,
      0.696319,
      NULL,
      NULL,
      1.648829,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.870895,
      0,
      1.034799,
      0,
      NULL,
      NULL,
      1.607069,
      NULL,
      NULL,
      1.577997,
      NULL,
      NULL,
      7.657315,
      2,
      1.375617,
      0,
      0.376225,
      0.072841,
      2,
      3,
      1.300201,
      NULL,
      2,
      NULL,
      1.570007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757212,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.046393,
      0,
      1,
      3.936610,
      5,
      0,
      0.942696,
      2.923339,
      5,
      3.058545,
      2,
      1.808234,
      1,
      2,
      0,
      2.941347,
      NULL,
      1.088816,
      1.125414,
      0.889871,
      2.921025,
      1.486407,
      2,
      4.626178,
      3,
      2,
      2.198290,
      3,
      0,
      NULL,
      1.003697,
      NULL,
      0,
      0.543364,
      2,
      1,
      NULL,
      7.411368,
      1.535538,
      0.496575,
      NULL,
      NULL,
      1.534920,
      0,
      1,
      1,
      1,
      1,
      0.029522,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150358,
      NULL,
      NULL,
      2.746730,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.876833,
      NULL,
      NULL,
      6.196171,
      NULL,
      NULL,
      NULL,
      0,
      3.456841,
      1.596958,
      0.601746,
      1.459049,
      1,
      NULL,
      NULL,
      0.283371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.925197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.009494,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.104174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334054,
      NULL,
      NULL,
      NULL,
      0.468398,
      NULL,
      NULL,
      NULL,
      1.397894,
      NULL,
      NULL,
      NULL,
      0.256747,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.960998,
      1.089164,
      3,
      21.980531,
      NULL,
      0,
      NULL,
      NULL,
      1.860698,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.742413,
      NULL,
      1.697677,
      1,
      8,
      NULL,
      1,
      1,
      NULL,
      2,
      0.977117,
      2.601794,
      1.864637,
      1,
      0.279724,
      0.406030,
      1,
      1,
      0.290773,
      1.842581,
      NULL,
      1.549032,
      0.877994,
      1.526177,
      NULL,
      NULL,
      NULL,
      1.483315,
      NULL,
      NULL,
      NULL,
      2.936257,
      NULL,
      23.695968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.865504,
      1.519349,
      1.002549,
      NULL,
      0.395539,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.701033,
      NULL,
      NULL,
      NULL,
      1.637253,
      NULL,
      0.123874,
      NULL,
      0,
      NULL,
      1.207701,
      NULL,
      1.428205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.300590,
      NULL,
      1.861048,
      0,
      NULL,
      NULL,
      1.549331,
      NULL,
      NULL,
      1.668019,
      0.714074,
      NULL,
      0.529094,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      0.462766,
      NULL,
      1.616034,
      0.198958,
      NULL,
      0.036538,
      2.773813,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3.973153,
      NULL,
      1,
      3,
      NULL,
      0,
      1.486453,
      NULL,
      1,
      0.285428,
      NULL,
      0,
      1.577380,
      0.623877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.953267,
      NULL,
      4,
      3,
      NULL,
      0,
      NULL,
      NULL,
      25.162067,
      NULL,
      1,
      5,
      0,
      '00314',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


