set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6414280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '0121013',
      1,
      1,
      1,
      1,
      '1321',
      NULL,
      3,
      1.317518,
      1.289565,
      NULL,
      6.303826,
      NULL,
      2,
      3,
      NULL,
      '11-19-1977',
      NULL,
      1.203125,
      330.772866,
      46,
      3,
      NULL,
      NULL,
      ' 1-11-2003',
      1.893873,
      0,
      1.018439,
      1.997739,
      0,
      NULL,
      2,
      1.942359,
      NULL,
      NULL,
      NULL,
      3.028916,
      2.698805,
      17.469505,
      5.706404,
      5,
      16,
      2,
      NULL,
      1.171200,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0.461218,
      NULL,
      NULL,
      4.234638,
      0.661975,
      0,
      3,
      4,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1.548416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.262885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.687055,
      0.575106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.940995,
      2.567523,
      0.949556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      0.790275,
      0,
      1,
      7,
      0,
      0.691530,
      NULL,
      4,
      1,
      0,
      1,
      3,
      8,
      2.744897,
      1,
      3,
      3,
      3,
      ' 3-22-1976',
      NULL,
      ' 9-21-1983',
      7.030227,
      NULL,
      1,
      0.921044,
      0.885724,
      3.993435,
      0.693958,
      1.170276,
      0.983464,
      0,
      1.359166,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.821343,
      NULL,
      3,
      0,
      0,
      3,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      12.000012,
      2,
      167.584781,
      NULL,
      NULL,
      53,
      6,
      108,
      1,
      NULL,
      1,
      1,
      NULL,
      0.812316,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.476701,
      3,
      NULL,
      3.540015,
      1,
      NULL,
      1.724281,
      0,
      NULL,
      16,
      0,
      0.495725,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.571429,
      1.657927,
      '30013',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0.832232,
      NULL,
      '',
      '',
      1.573135,
      15,
      124,
      24.338984,
      1.199209,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.168610,
      NULL,
      NULL,
      1.494010,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.046397,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.088009,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.408218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512267,
      NULL,
      NULL,
      1.665328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.928850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.825851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920022,
      NULL,
      NULL,
      0.116064,
      NULL,
      NULL,
      0.135727,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780736,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997921,
      NULL,
      NULL,
      1.848852,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.482851,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.837393,
      NULL,
      NULL,
      1.012658,
      NULL,
      NULL,
      1.338418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.579747,
      NULL,
      NULL,
      0.467829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024074,
      NULL,
      NULL,
      0.290755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.549564,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053906,
      NULL,
      2,
      0.075311,
      0.290724,
      NULL,
      0.247570,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.333468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.010369,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.302270,
      NULL,
      NULL,
      NULL,
      0.260265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631726,
      NULL,
      NULL,
      NULL,
      0.575608,
      NULL,
      NULL,
      NULL,
      2.872753,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.392555,
      NULL,
      1.688520,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.006942,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.233308,
      NULL,
      NULL,
      1.136392,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      99,
      1.375659,
      1,
      NULL,
      NULL,
      1,
      1,
      1.836859,
      1,
      0.076689,
      1.181884,
      NULL,
      0.275286,
      0,
      0,
      1,
      0,
      1.280212,
      1.460095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779453,
      0.594306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.373868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.877616,
      NULL,
      0,
      NULL,
      0.341727,
      NULL,
      NULL,
      NULL,
      1.420042,
      NULL,
      0.537556,
      NULL,
      1.733647,
      1.269840,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      1.919770,
      NULL,
      NULL,
      1.967010,
      NULL,
      3.459263,
      0,
      1.764363,
      0.535790,
      0.840472,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.414466,
      1,
      0,
      1,
      NULL,
      1.268024,
      0.831840,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.854841,
      1.565222,
      0,
      0,
      0,
      1.344624,
      0.825051,
      NULL,
      3.322449,
      NULL,
      0.665823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.079413,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      68,
      139,
      2,
      1.824102,
      0.072211,
      NULL,
      '',
      '',
      0.822213,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


