set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857458';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2,
      2,
      3.103074,
      NULL,
      1,
      2.618824,
      1.963577,
      '410',
      '40244142',
      47,
      NULL,
      '4303332',
      3,
      0.220284,
      3,
      0,
      '4421',
      NULL,
      1.589292,
      NULL,
      NULL,
      '10-24-1996',
      1.068678,
      108.482875,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-16-2001',
      ' 8-17-2000',
      ' 9-13-1995',
      2.813389,
      1,
      NULL,
      1,
      NULL,
      3,
      2,
      0,
      1.115101,
      23.682057,
      1,
      14.658103,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.320874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      2,
      2,
      2,
      1,
      0,
      NULL,
      1,
      0,
      5,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.082190,
      1.373098,
      1.521787,
      1.092988,
      1,
      1,
      0,
      2,
      3,
      0,
      1.203547,
      0,
      1.463969,
      1.373610,
      2,
      1,
      0,
      0,
      0,
      4,
      8.465041,
      0,
      2,
      NULL,
      1.302203,
      NULL,
      NULL,
      0.797576,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1,
      2,
      NULL,
      5,
      1,
      1,
      2,
      2,
      2,
      4,
      2,
      5,
      NULL,
      4,
      0,
      3,
      0,
      1,
      2,
      4,
      0,
      4,
      5,
      4,
      0,
      4,
      0,
      1.379487,
      ' 6-17-1986',
      NULL,
      NULL,
      327,
      0.927007,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0.491902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.148981,
      1.147623,
      1.729170,
      2,
      1,
      0.688934,
      0.576321,
      NULL,
      NULL,
      3,
      NULL,
      1.473700,
      2.681567,
      1,
      1,
      1.460387,
      5,
      NULL,
      8,
      3,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0,
      9,
      0.537859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.798908,
      0.157647,
      1.704594,
      NULL,
      0.424126,
      1.602977,
      1.387464,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      3,
      2,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      3.539916,
      3,
      0.964699,
      1,
      1,
      0,
      1.268150,
      0,
      0,
      0,
      NULL,
      1.835293,
      1,
      0,
      1,
      0,
      1.712178,
      3.480550,
      0.058688,
      3.493133,
      NULL,
      0.703485,
      2,
      3,
      5,
      1,
      1,
      4.482108,
      1,
      1.020013,
      2,
      48.908301,
      3,
      2.343023,
      12,
      NULL,
      30,
      54.309017,
      3,
      5,
      NULL,
      '04013',
      '',
      NULL,
      1.588350,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.544200,
      11,
      121.423037,
      3.605586,
      2,
      37,
      0,
      0.117014,
      1,
      3.231308,
      NULL,
      1.334826,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.464242,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.934550,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832753,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.880867,
      1.321910,
      1,
      1,
      NULL,
      NULL,
      3.346695,
      3,
      NULL,
      NULL,
      0,
      0.899176,
      1.165350,
      1,
      0.990233,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.417359,
      NULL,
      NULL,
      10,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.684011,
      1.910509,
      0.401917,
      1.196303,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902913,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.006369,
      NULL,
      NULL,
      0,
      0.243490,
      NULL,
      1.516361,
      NULL,
      NULL,
      1.707288,
      NULL,
      NULL,
      0.823575,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6.470426,
      1.663456,
      1,
      3.217792,
      1,
      1.445196,
      3,
      2.086170,
      1.547989,
      6,
      5.351235,
      5,
      9.283758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      1,
      3,
      2,
      0,
      1.383018,
      1.611981,
      0.288837,
      5.330881,
      NULL,
      0,
      1.947613,
      2,
      1,
      2.592023,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      3,
      0.462013,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1.654741,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.064451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309751,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.984661,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.456470,
      NULL,
      NULL,
      0.472830,
      NULL,
      NULL,
      0,
      0.529092,
      0.483155,
      0,
      1.097050,
      NULL,
      1.825505,
      NULL,
      NULL,
      3.607656,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.603447,
      NULL,
      NULL,
      NULL,
      0.401027,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.873877,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.558668,
      NULL,
      NULL,
      NULL,
      2.842779,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.767795,
      NULL,
      NULL,
      NULL,
      2.618907,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.146205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      58,
      31.629966,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.762435,
      1.361677,
      0.571716,
      NULL,
      NULL,
      1.616716,
      NULL,
      NULL,
      1.754318,
      NULL,
      1,
      42,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.929599,
      0.556707,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322274,
      1.567611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722128,
      0,
      NULL,
      0,
      NULL,
      1.043388,
      NULL,
      NULL,
      NULL,
      1.635380,
      NULL,
      0.071515,
      NULL,
      1.060966,
      NULL,
      1,
      1.437348,
      1.559317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790201,
      0.366266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019114,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.698031,
      NULL,
      NULL,
      NULL,
      1,
      0.055937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.433169,
      2.115046,
      1.988720,
      3,
      NULL,
      3.279512,
      0.026154,
      0.440846,
      0,
      1.870374,
      NULL,
      0.491829,
      2,
      NULL,
      0,
      1,
      NULL,
      0.786157,
      NULL,
      NULL,
      1,
      1.229977,
      NULL,
      0.802037,
      2,
      NULL,
      0.928206,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.666192,
      0,
      NULL,
      1,
      0.634293,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.913674,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      2.036901,
      1,
      NULL,
      '',
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


