set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032078';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0143342',
      NULL,
      NULL,
      3,
      0,
      '4220',
      1,
      0.321444,
      NULL,
      NULL,
      ' 4-20-1993',
      NULL,
      NULL,
      3,
      1,
      0.967903,
      ' 9-10-1993',
      102.221616,
      2,
      77,
      90,
      5,
      NULL,
      NULL,
      ' 4- 5-1998',
      3.666066,
      1.877799,
      2.843529,
      2.501975,
      NULL,
      3.331312,
      NULL,
      NULL,
      0.906947,
      NULL,
      7,
      9.054015,
      7.573688,
      4,
      1,
      5,
      3,
      5,
      1,
      2,
      0.655495,
      NULL,
      3,
      1.127744,
      NULL,
      0.287260,
      1.778327,
      NULL,
      0,
      0.479457,
      1,
      1,
      3,
      1,
      2.456454,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.339756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      0,
      0,
      1,
      1,
      1,
      3,
      NULL,
      0,
      3.108935,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      5,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      3,
      2,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.724708,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.805463,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690306,
      2,
      2,
      NULL,
      0.159221,
      NULL,
      0.614248,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3.913655,
      1,
      NULL,
      1.899064,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.264772,
      0,
      0.849636,
      1,
      0.793936,
      NULL,
      0,
      NULL,
      9,
      3,
      2.627206,
      3.128527,
      1.807306,
      1,
      2.900064,
      3.167886,
      1,
      NULL,
      3,
      0.709068,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.498163,
      '03212',
      '12334',
      '',
      1,
      '',
      NULL,
      NULL,
      3.063298,
      '3024',
      '',
      '',
      1,
      6,
      938.306095,
      16,
      1.321447,
      5.817078,
      3,
      36,
      0,
      1.779566,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.622759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810459,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.438452,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.828780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.669961,
      0.824788,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.498667,
      0.373731,
      0,
      3.075910,
      NULL,
      1,
      1,
      1,
      1.281839,
      2,
      3,
      0,
      0.597421,
      1.714217,
      1.680573,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.019321,
      NULL,
      NULL,
      2.619354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296798,
      NULL,
      NULL,
      2,
      NULL,
      1.860190,
      0.070619,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.640848,
      0,
      1.641125,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.440113,
      3,
      NULL,
      0,
      0.818037,
      0.806876,
      2,
      2.436745,
      NULL,
      0.709770,
      NULL,
      NULL,
      2.997906,
      3,
      NULL,
      4,
      NULL,
      3.030109,
      0.569775,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808385,
      NULL,
      NULL,
      1.626278,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.118016,
      0.584361,
      NULL,
      NULL,
      1.688745,
      2,
      3,
      0,
      0.271255,
      0.126766,
      1.668092,
      NULL,
      NULL,
      120.177368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194656,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.717110,
      NULL,
      NULL,
      1.407990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.031036,
      NULL,
      NULL,
      2.441963,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      24.316758,
      NULL,
      NULL,
      NULL,
      1.741474,
      1,
      1,
      NULL,
      1.918717,
      NULL,
      NULL,
      NULL,
      NULL,
      2.079381,
      NULL,
      NULL,
      NULL,
      1.116314,
      NULL,
      NULL,
      NULL,
      1.047010,
      NULL,
      NULL,
      NULL,
      0.277785,
      NULL,
      NULL,
      NULL,
      1.665609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.690481,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.320914,
      NULL,
      NULL,
      NULL,
      5.566082,
      NULL,
      NULL,
      NULL,
      22.517926,
      NULL,
      0.831323,
      NULL,
      NULL,
      NULL,
      2.874824,
      5.451125,
      2.747524,
      1,
      NULL,
      NULL,
      1.066144,
      NULL,
      NULL,
      1.678934,
      NULL,
      NULL,
      1,
      246.644454,
      3.517212,
      1,
      175,
      1925,
      0,
      61,
      3.973314,
      NULL,
      1,
      1,
      0,
      1,
      1.350970,
      0,
      0,
      NULL,
      1,
      0.272877,
      1.350361,
      0.022435,
      1,
      0.415731,
      1.138749,
      NULL,
      0.475573,
      0.640649,
      0,
      NULL,
      0.666658,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      68,
      NULL,
      0.714669,
      4,
      NULL,
      0.204290,
      1,
      NULL,
      NULL,
      0.556730,
      NULL,
      1,
      NULL,
      1.940513,
      NULL,
      0.004198,
      NULL,
      1.816147,
      NULL,
      1.391606,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.899400,
      NULL,
      0,
      NULL,
      0.507787,
      NULL,
      1.401678,
      NULL,
      1.594128,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.816842,
      0.721509,
      NULL,
      NULL,
      0,
      0.826461,
      3.197647,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.175721,
      NULL,
      1,
      1.647186,
      1.464757,
      1.706196,
      0.741462,
      NULL,
      3.907859,
      2,
      3,
      NULL,
      1.551054,
      0.676695,
      1,
      1.057133,
      1,
      2.728037,
      2,
      1,
      1,
      NULL,
      0.524788,
      1,
      2.285892,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.751272,
      2,
      1.439245,
      2.130954,
      0,
      NULL,
      3.569114,
      NULL,
      NULL,
      1.755445,
      1,
      0,
      0.548850,
      NULL,
      2,
      NULL,
      1,
      1.684698,
      1.002932,
      1,
      1.596916,
      2,
      NULL,
      2.961580,
      NULL,
      0.534056,
      NULL,
      0,
      17,
      1.020621,
      NULL,
      2.268001,
      1.420045,
      0,
      0,
      1.621438,
      0.238919,
      1,
      1,
      NULL,
      3.779193,
      NULL,
      3,
      0.364868,
      NULL,
      1.022535,
      0,
      2.444566,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1.503521,
      3,
      50.722018,
      2,
      NULL,
      1,
      0.048252,
      0.612049,
      0.420827,
      2.180758,
      1.706762,
      4,
      NULL,
      7,
      1.869337,
      NULL,
      NULL,
      52,
      24,
      0,
      0.944195,
      4.443901,
      NULL,
      '43430',
      NULL,
      0.642749,
      '',
      '',
      '',
      3,
      '3402',
      '',
      NULL);
commit;
end;
/


