set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3423211',
      3,
      0.413326,
      1,
      3,
      '0443',
      2,
      1.740073,
      NULL,
      NULL,
      ' 2-17-1989',
      57,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      27.557338,
      2,
      NULL,
      35,
      0,
      ' 6- 5-1990',
      NULL,
      ' 3-16-1990',
      NULL,
      1,
      0.455741,
      0.259323,
      0.682461,
      0.394753,
      2,
      1.502232,
      NULL,
      NULL,
      NULL,
      2.597012,
      0.427020,
      118,
      3.564731,
      1,
      3,
      5,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.537975,
      0.721810,
      NULL,
      1,
      1,
      0.061665,
      1,
      1,
      2,
      0,
      3,
      3.517612,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      0,
      0,
      NULL,
      9.930794,
      0,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.645114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.008230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      5,
      1,
      3,
      1,
      NULL,
      0,
      NULL,
      4.619410,
      NULL,
      0,
      1,
      NULL,
      1.954149,
      NULL,
      0.065347,
      3,
      NULL,
      1,
      3,
      1,
      1,
      1,
      0,
      4,
      2,
      0,
      3,
      4,
      5,
      3,
      5,
      0,
      2,
      1,
      3,
      2,
      3,
      4,
      NULL,
      4,
      1,
      1.285835,
      ' 7-29-1990',
      44.698924,
      ' 9- 3-1980',
      36,
      0.914420,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.337259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      29,
      1,
      3,
      1,
      1,
      1,
      1.597086,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.919860,
      1.720092,
      6,
      NULL,
      NULL,
      3,
      0.154255,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023648,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.909718,
      0,
      1,
      1,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      2,
      2,
      1,
      1,
      2,
      NULL,
      3,
      1,
      0,
      16.617410,
      0,
      3.858762,
      NULL,
      1,
      2,
      0.035991,
      1,
      1,
      1.220691,
      1,
      1,
      0.825270,
      1.262593,
      NULL,
      0,
      3.080121,
      NULL,
      NULL,
      7,
      0.279534,
      NULL,
      NULL,
      7,
      NULL,
      3,
      NULL,
      NULL,
      3.683955,
      1.116037,
      39.488606,
      NULL,
      2,
      NULL,
      7,
      22,
      40,
      1,
      0,
      NULL,
      '10310',
      '',
      '',
      0,
      '',
      '',
      '',
      1.232917,
      '',
      '',
      '',
      3.668447,
      10.547580,
      1,
      87,
      0.593042,
      42.344420,
      1,
      0.858731,
      3,
      3.867637,
      1,
      0.292976,
      1.536186,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.369205,
      NULL,
      NULL,
      0.204574,
      NULL,
      NULL,
      0.743062,
      NULL,
      NULL,
      3,
      3,
      1.659216,
      NULL,
      NULL,
      NULL,
      1.323326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.857088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.790643,
      4.379965,
      7,
      0,
      0.389192,
      NULL,
      NULL,
      NULL,
      1.034129,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.318474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952757,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.698349,
      1,
      NULL,
      NULL,
      7,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.705273,
      NULL,
      NULL,
      0.643401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.924266,
      NULL,
      NULL,
      1,
      0,
      8.208027,
      2,
      6.218120,
      6,
      5,
      7,
      2,
      1.570724,
      2.836728,
      3.872485,
      0.818730,
      0,
      1.874650,
      0.652723,
      0.223801,
      3,
      NULL,
      0.226152,
      9.145408,
      NULL,
      9,
      2.375789,
      0.476157,
      0,
      NULL,
      15.686191,
      NULL,
      1.879907,
      2.401649,
      0.143467,
      3,
      1.078384,
      1.977615,
      9.441760,
      1.479870,
      5.151284,
      5.873247,
      3.569602,
      3,
      0.334530,
      NULL,
      3,
      1.173679,
      1.903488,
      0,
      NULL,
      NULL,
      2.150996,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879968,
      NULL,
      NULL,
      1.191685,
      NULL,
      NULL,
      1.702046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      0.259158,
      0,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      73.147304,
      NULL,
      NULL,
      NULL,
      0.064221,
      NULL,
      NULL,
      NULL,
      2.387479,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.163119,
      NULL,
      NULL,
      NULL,
      3.025886,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.412447,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.561899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.604588,
      NULL,
      NULL,
      NULL,
      1.117387,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.513287,
      0,
      1.912901,
      NULL,
      NULL,
      1.300809,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.954751,
      1.602517,
      1.041999,
      1.993098,
      NULL,
      NULL,
      0,
      NULL,
      0.926861,
      111,
      1.667564,
      0.094915,
      NULL,
      0.547231,
      1.489110,
      1,
      NULL,
      NULL,
      1,
      0,
      0.636438,
      1,
      1,
      0.829256,
      1.318701,
      NULL,
      0.818328,
      0.847604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.559002,
      1,
      2,
      0.974861,
      0,
      5.420168,
      3.167564,
      NULL,
      1,
      1,
      0.088393,
      NULL,
      2.508084,
      0.850790,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.637304,
      NULL,
      0.256648,
      NULL,
      NULL,
      1.910526,
      NULL,
      NULL,
      0.946654,
      0.565951,
      NULL,
      1,
      0,
      NULL,
      1.292492,
      0,
      NULL,
      1.944260,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.047248,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.338423,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.194822,
      NULL,
      3.248399,
      NULL,
      1.939396,
      3.307850,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      3,
      1,
      2,
      1.261584,
      0,
      9.050972,
      56.947244,
      1,
      1.492279,
      2.154648,
      '02041',
      '',
      NULL,
      0.378859,
      '',
      '',
      '',
      0.899851,
      '',
      '',
      '');
commit;
end;
/


