set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.003339,
      NULL,
      0,
      0,
      '3223',
      2,
      0,
      NULL,
      NULL,
      ' 5- 4-1984',
      30.343000,
      NULL,
      3,
      2,
      5,
      ' 8-12-1996',
      65.247552,
      1,
      146.308778,
      59,
      1,
      ' 1- 3-2002',
      '10-24-1976',
      ' 5- 1-2003',
      NULL,
      0.339842,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651118,
      69.773796,
      176,
      NULL,
      19.793543,
      5,
      3,
      5.099395,
      NULL,
      1,
      1,
      0,
      1.257298,
      NULL,
      0,
      1,
      0.959548,
      NULL,
      1.752645,
      2,
      3,
      0,
      NULL,
      4,
      1,
      0,
      1,
      0,
      0,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      0.003534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1.777141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      5,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      5,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.346188,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      3,
      1,
      5,
      0,
      0,
      2,
      1,
      NULL,
      0,
      2,
      0,
      5,
      1,
      0,
      1,
      5,
      3,
      NULL,
      0,
      NULL,
      2.294392,
      ' 6-11-1995',
      59,
      NULL,
      49.228397,
      2.193260,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      5,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.647854,
      3.278733,
      1,
      4,
      NULL,
      0.129222,
      1,
      NULL,
      11,
      3,
      0.475637,
      3,
      2,
      0,
      2.122868,
      NULL,
      NULL,
      0,
      6,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591719,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590794,
      1,
      0,
      3,
      0,
      0.920729,
      1,
      NULL,
      17.798268,
      1.881904,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.173438,
      3,
      NULL,
      1,
      1,
      0,
      2,
      3,
      0,
      3,
      0,
      NULL,
      0.091438,
      15.852517,
      11,
      NULL,
      1,
      5,
      0.441345,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.789317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      64,
      28.428460,
      1,
      1.180537,
      NULL,
      '03241',
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      2,
      56.870330,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697162,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752630,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.328497,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.335320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316555,
      NULL,
      NULL,
      1.679136,
      NULL,
      NULL,
      2,
      4.278854,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.924440,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.299014,
      NULL,
      NULL,
      0.218562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162560,
      NULL,
      NULL,
      NULL,
      3,
      1.013646,
      1,
      NULL,
      NULL,
      1.523661,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.141086,
      NULL,
      NULL,
      0.748868,
      NULL,
      NULL,
      0.348097,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.946808,
      NULL,
      NULL,
      1.489778,
      NULL,
      NULL,
      0.572616,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      2.594959,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.750842,
      0,
      1,
      0,
      0,
      NULL,
      4,
      4.235533,
      NULL,
      3,
      NULL,
      2.515106,
      1.542429,
      NULL,
      NULL,
      2,
      2,
      2.595424,
      NULL,
      1.247092,
      1.530866,
      8.485713,
      7,
      3.202970,
      0,
      NULL,
      NULL,
      3,
      2,
      4,
      0,
      0,
      1.454156,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191856,
      NULL,
      NULL,
      1.305235,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.535968,
      NULL,
      NULL,
      0.814578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.937668,
      1.364303,
      0,
      0.962446,
      1.053630,
      NULL,
      1.266274,
      NULL,
      NULL,
      1.300025,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.413476,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.070678,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.130197,
      NULL,
      NULL,
      NULL,
      0.922717,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.175311,
      NULL,
      NULL,
      NULL,
      0.891663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473917,
      NULL,
      NULL,
      NULL,
      3.113605,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.043887,
      NULL,
      NULL,
      0.452358,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.254790,
      1,
      1.066102,
      0.964633,
      0,
      0,
      1.405202,
      1,
      1.879475,
      0.204239,
      1.379442,
      1.410070,
      1,
      NULL,
      1.701969,
      NULL,
      0.856844,
      1.263016,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      7.326724,
      0.008297,
      4.906823,
      0.098867,
      1,
      1.367184,
      3.338395,
      2.160676,
      0.080532,
      1,
      0.537378,
      NULL,
      1,
      0.032635,
      NULL,
      1.964039,
      0.434722,
      NULL,
      1,
      1.994232,
      NULL,
      0.373332,
      0.547160,
      NULL,
      1,
      0,
      NULL,
      2.064479,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1.706894,
      1.381774,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.772880,
      1.264982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      65,
      8,
      1,
      1.951626,
      1,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.652348,
      '',
      '',
      '');
commit;
end;
/


