set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2003422',
      1.198720,
      1.545514,
      3,
      3,
      '0321',
      0,
      1.650167,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      1,
      1.494390,
      NULL,
      '10-11-2001',
      18,
      4,
      285.102827,
      5.353134,
      1,
      ' 2-19-2000',
      NULL,
      ' 1- 8-1976',
      3.728128,
      0.694024,
      3.356529,
      2.786823,
      1.941162,
      1.711056,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      7,
      176.327312,
      5.738021,
      1,
      14.982643,
      4,
      2,
      4.729031,
      1.591171,
      0,
      3,
      1.420041,
      1.541497,
      0.234445,
      0,
      0,
      0.648910,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.160860,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.215714,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378100,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.794156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      2,
      1,
      3,
      1,
      3,
      2,
      NULL,
      1,
      1,
      3.117378,
      NULL,
      NULL,
      1,
      1,
      0.496789,
      NULL,
      0.375247,
      4,
      0,
      0,
      2,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      5,
      5,
      NULL,
      4,
      5,
      0,
      1,
      4,
      4,
      0,
      NULL,
      3,
      5,
      1,
      4.937696,
      0.869480,
      ' 6-24-1981',
      NULL,
      ' 8-15-1987',
      142,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      3,
      1,
      2.723891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.641124,
      1.080347,
      3,
      NULL,
      NULL,
      0.782061,
      NULL,
      9,
      3,
      NULL,
      1.421342,
      3.374105,
      0.268452,
      NULL,
      1.942119,
      1,
      8,
      3.568698,
      2.826036,
      0.861739,
      1.169559,
      NULL,
      NULL,
      NULL,
      0.034089,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.940890,
      NULL,
      1.323357,
      1.948795,
      NULL,
      23,
      0,
      0.958741,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519645,
      1.936396,
      1,
      3,
      3,
      2,
      2,
      2,
      0,
      1,
      2,
      3,
      1,
      3,
      2.349843,
      5.307921,
      2.223653,
      0.741326,
      7.002739,
      0.891661,
      NULL,
      1.876862,
      NULL,
      1,
      2.020007,
      0.868134,
      NULL,
      1,
      0.203004,
      5.916685,
      1.419241,
      0,
      0.157480,
      2.937106,
      2.777678,
      7.285845,
      NULL,
      0,
      0,
      6,
      1.496014,
      0.195647,
      1,
      28,
      0,
      3,
      NULL,
      46,
      33,
      89,
      1,
      1,
      2,
      NULL,
      '',
      NULL,
      1.440693,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.373544,
      1,
      NULL,
      28.623768,
      1.156837,
      NULL,
      NULL,
      NULL,
      NULL,
      2.153689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1.992327,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.973852,
      NULL,
      NULL,
      0.564038,
      NULL,
      NULL,
      5,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.472772,
      NULL,
      NULL,
      0.413501,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.745183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.649483,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      5,
      1,
      0.620621,
      1,
      NULL,
      3.941043,
      0,
      NULL,
      NULL,
      1,
      3.904181,
      NULL,
      1.688343,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.873202,
      NULL,
      NULL,
      1.993030,
      NULL,
      NULL,
      1,
      NULL,
      2.754650,
      NULL,
      1.894938,
      3.168622,
      3.794135,
      NULL,
      4,
      8,
      2.081183,
      0.191033,
      5,
      0.548532,
      NULL,
      1.084751,
      1.061259,
      3.729006,
      1,
      2,
      1.124941,
      0,
      3,
      NULL,
      NULL,
      5.389098,
      2,
      NULL,
      3.450878,
      0,
      0,
      NULL,
      0.514326,
      2.361150,
      2,
      1.158662,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      3,
      2,
      NULL,
      1,
      0,
      1,
      1.904271,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.030710,
      NULL,
      NULL,
      0.632526,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      2.538829,
      0.572527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      113,
      NULL,
      NULL,
      NULL,
      0.627296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068148,
      NULL,
      NULL,
      NULL,
      0.311122,
      NULL,
      NULL,
      NULL,
      0.945379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.392106,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.859207,
      NULL,
      NULL,
      NULL,
      1.946137,
      NULL,
      NULL,
      NULL,
      1.241831,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.638649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.214623,
      NULL,
      NULL,
      NULL,
      0.140815,
      NULL,
      NULL,
      NULL,
      6.599784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.779231,
      1,
      0.524964,
      0,
      NULL,
      NULL,
      1.058608,
      NULL,
      NULL,
      1,
      0,
      0.397670,
      1,
      0,
      0.406554,
      0.276039,
      NULL,
      NULL,
      0,
      NULL,
      0,
      273.727325,
      1.913265,
      1.106614,
      0,
      0.008943,
      NULL,
      0,
      0,
      1.127894,
      0.024963,
      NULL,
      NULL,
      0.773007,
      NULL,
      0.501903,
      0.042534,
      NULL,
      NULL,
      1.370327,
      0.354726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      1.283343,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.804082,
      0,
      NULL,
      NULL,
      0.377497,
      NULL,
      0.641703,
      0.525005,
      NULL,
      0,
      1,
      NULL,
      0.619297,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.810397,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.078922,
      1,
      1.986016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.369986,
      NULL,
      0.058565,
      NULL,
      2,
      2,
      2,
      2,
      1.882926,
      NULL,
      36.435813,
      83,
      NULL,
      0.123390,
      2,
      '44021',
      '',
      NULL,
      0.573742,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


