set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '2303444',
      2.497939,
      0,
      3,
      2,
      '4231',
      2.082099,
      0,
      NULL,
      NULL,
      '11-18-1989',
      41.866481,
      NULL,
      1,
      2,
      NULL,
      '10-16-1985',
      12.869554,
      2.911310,
      164,
      42,
      3,
      ' 7-14-1980',
      ' 3-19-2002',
      NULL,
      0,
      1.090084,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.528264,
      0,
      11.064035,
      0,
      6,
      0,
      NULL,
      1,
      0.543946,
      1,
      1,
      1.318158,
      1,
      1.582242,
      0,
      1,
      NULL,
      4.629762,
      1,
      2,
      2,
      NULL,
      NULL,
      0,
      0,
      4,
      5,
      3,
      5,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      3.007756,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.552467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      2,
      NULL,
      0,
      4,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.136946,
      4,
      1,
      5,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      2,
      1,
      5,
      2,
      3,
      0,
      1,
      0,
      4,
      0,
      2,
      3,
      NULL,
      7.423228,
      ' 6-24-1977',
      15,
      1.945376,
      0,
      1,
      2,
      2,
      3,
      NULL,
      2,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.479058,
      8.650533,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.656858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0.744124,
      1,
      6,
      1.565072,
      0.624128,
      2.873806,
      3.109821,
      7,
      5,
      1.747011,
      NULL,
      NULL,
      1.348364,
      1.360589,
      1.644889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.917768,
      1.831235,
      1.601621,
      NULL,
      1.354181,
      NULL,
      3.622251,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.085921,
      1,
      2,
      2,
      NULL,
      NULL,
      2,
      2,
      1,
      3,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.934590,
      3.491655,
      0,
      1.662830,
      0,
      0.518887,
      0,
      1.023150,
      NULL,
      0.154566,
      1,
      0.794372,
      4.245891,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      3,
      73,
      5,
      NULL,
      0.001702,
      '41001',
      NULL,
      NULL,
      0.204344,
      '',
      '',
      '',
      1.281082,
      '',
      NULL,
      '',
      1,
      25.059322,
      54.456603,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.290264,
      1.006604,
      NULL,
      NULL,
      NULL,
      2.776998,
      3.512595,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263340,
      NULL,
      NULL,
      1.617796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.191050,
      NULL,
      NULL,
      0.067996,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.777266,
      NULL,
      NULL,
      0.124829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963451,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.183768,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.575243,
      NULL,
      NULL,
      0.811890,
      NULL,
      NULL,
      1.439275,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713769,
      1,
      1,
      0.226214,
      NULL,
      NULL,
      2.826748,
      5.852057,
      0,
      2.315362,
      0.516665,
      1,
      NULL,
      NULL,
      NULL,
      0.552206,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.350064,
      2,
      1,
      0.292134,
      NULL,
      NULL,
      3.672499,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.994387,
      NULL,
      NULL,
      2,
      0,
      1,
      1.605128,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.412034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499911,
      NULL,
      3.931805,
      0.787974,
      NULL,
      1.485712,
      1.621696,
      7.952909,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.363043,
      NULL,
      NULL,
      NULL,
      1.582262,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.279954,
      NULL,
      NULL,
      NULL,
      0.467446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      3.947743,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.381704,
      0.562520,
      NULL,
      NULL,
      NULL,
      NULL,
      2.783446,
      1.007605,
      NULL,
      2.509631,
      2.632256,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280841,
      NULL,
      0.144210,
      0,
      0,
      1.089692,
      1,
      NULL,
      0,
      1,
      NULL,
      0.097318,
      1,
      0,
      0,
      NULL,
      NULL,
      1.213190,
      0,
      0,
      NULL,
      0.272784,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.907462,
      2,
      3.989839,
      1,
      3,
      2.010596,
      NULL,
      2.748772,
      NULL,
      0,
      0.912206,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0.706925,
      1,
      1.769359,
      1,
      NULL,
      NULL,
      NULL,
      0.948908,
      NULL,
      1.199877,
      0.936460,
      0,
      2,
      0,
      1.388765,
      0,
      0,
      1,
      1,
      1.521625,
      NULL,
      0.044806,
      1,
      2.519426,
      0.790040,
      2.610394,
      3,
      1.014938,
      1,
      NULL,
      2,
      NULL,
      0.952932,
      NULL,
      0,
      NULL,
      0.583424,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.495950,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.985490,
      0.327346,
      NULL,
      2.042240,
      1,
      0.841793,
      1.083446,
      NULL,
      1,
      NULL,
      1,
      1,
      2.053457,
      0.313344,
      3.899917,
      NULL,
      NULL,
      1.303358,
      0,
      0.910181,
      1.178856,
      0,
      0.194884,
      2.434014,
      1.524627,
      2,
      13.183838,
      NULL,
      0,
      0,
      1.779753,
      1.964263,
      0,
      0.937510,
      1.245276,
      0,
      5,
      0,
      1.558978,
      NULL,
      NULL,
      104,
      132.567741,
      0,
      0.716797,
      2,
      NULL,
      '14312',
      NULL,
      0.806084,
      '',
      '',
      '',
      1.423407,
      '',
      '',
      '');
commit;
end;
/


