set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '0423000',
      2,
      1.786866,
      3,
      NULL,
      '0432',
      3,
      1,
      NULL,
      NULL,
      '10-25-1987',
      30,
      NULL,
      3,
      1,
      0.539924,
      ' 1- 0-1974',
      NULL,
      0,
      NULL,
      NULL,
      3,
      ' 5- 2-1999',
      ' 7-18-2000',
      ' 2- 6-1994',
      1,
      0.572963,
      0.320564,
      1,
      NULL,
      1.077295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      3.214349,
      16,
      20.700784,
      5,
      NULL,
      3,
      2,
      NULL,
      0,
      1,
      NULL,
      1.464856,
      1,
      0.799712,
      0,
      0,
      0,
      9.840089,
      0,
      2,
      1,
      0,
      NULL,
      2,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      5,
      3,
      2,
      0,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.099819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      4,
      0,
      1,
      NULL,
      3,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      4.768217,
      1,
      ' 0-10-1983',
      14.576872,
      ' 4- 0-2003',
      3,
      1.500591,
      NULL,
      NULL,
      1,
      5,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      4,
      2,
      0,
      2,
      NULL,
      0,
      3.033293,
      0,
      13.770963,
      3.766028,
      NULL,
      0.742130,
      ' 8-22-1986',
      11,
      0.760852,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.323554,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0.546667,
      0,
      3.492833,
      3,
      NULL,
      NULL,
      0,
      0,
      1.450289,
      NULL,
      2.055852,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278234,
      1,
      0,
      1,
      3.015873,
      1,
      0.956071,
      1,
      76,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      2,
      NULL,
      1,
      2,
      1,
      1,
      2,
      NULL,
      3,
      0.528822,
      NULL,
      0,
      0.056828,
      0.739960,
      0.902194,
      NULL,
      0,
      1.795258,
      NULL,
      NULL,
      NULL,
      1.774089,
      0,
      1,
      0,
      1,
      0,
      NULL,
      9.330635,
      NULL,
      6.940155,
      6,
      6.138060,
      5.446591,
      3.713681,
      2,
      0.388601,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      27,
      69.477375,
      1,
      1.489950,
      2.609216,
      '42242',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      3.565804,
      5,
      6.983776,
      NULL,
      0.748204,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321392,
      NULL,
      NULL,
      1.758565,
      NULL,
      NULL,
      0.309673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.686616,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.182553,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089340,
      NULL,
      NULL,
      0.849055,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184849,
      NULL,
      NULL,
      0.196583,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.385357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.257343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611137,
      NULL,
      NULL,
      1.399437,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.807948,
      NULL,
      NULL,
      0.795386,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.382938,
      5,
      1,
      1,
      2.771593,
      NULL,
      NULL,
      1.676368,
      NULL,
      NULL,
      3.812615,
      1.959255,
      0,
      2.511783,
      NULL,
      2.544272,
      5,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      2.506520,
      0,
      0,
      NULL,
      NULL,
      2.698404,
      0,
      NULL,
      2.549863,
      5.263048,
      0.202531,
      2,
      NULL,
      NULL,
      1.871633,
      NULL,
      NULL,
      0,
      NULL,
      1.245035,
      NULL,
      1.147099,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.639049,
      3.059769,
      1,
      1,
      1.475977,
      1.350087,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.893651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661525,
      NULL,
      NULL,
      NULL,
      0.161955,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.754980,
      NULL,
      NULL,
      NULL,
      0.846705,
      NULL,
      NULL,
      NULL,
      1.617610,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.561607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.067708,
      NULL,
      NULL,
      NULL,
      0.985189,
      NULL,
      NULL,
      NULL,
      11.104631,
      NULL,
      NULL,
      NULL,
      0.927073,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.864819,
      NULL,
      1.040567,
      987.759097,
      NULL,
      1.392477,
      NULL,
      NULL,
      2,
      0.739476,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477891,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.128696,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1.316449,
      1,
      0.672498,
      1.709218,
      1.795294,
      1,
      0,
      1,
      0.156618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      1.245713,
      3.488243,
      0.423610,
      2,
      9.547729,
      0.602106,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.874571,
      1.099963,
      1,
      0,
      1.539603,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1.399164,
      0,
      1,
      0.704202,
      1,
      0.070017,
      NULL,
      1,
      1.848940,
      1.503383,
      0,
      2.650806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.108780,
      1.939725,
      NULL,
      1.616160,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      61.800199,
      NULL,
      3,
      1.730001,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


