set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4140240',
      NULL,
      NULL,
      NULL,
      2,
      '3440',
      1.534688,
      0.700207,
      NULL,
      NULL,
      ' 7-24-1974',
      8,
      NULL,
      NULL,
      0,
      2,
      NULL,
      30,
      1,
      113.869398,
      130,
      0,
      NULL,
      '11-15-1995',
      ' 5- 3-2002',
      0,
      NULL,
      3,
      2.415967,
      NULL,
      1.835856,
      0,
      2.780666,
      NULL,
      NULL,
      NULL,
      0.558240,
      5.233053,
      39,
      24,
      3,
      12,
      5,
      0,
      1.161950,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.056940,
      1.281051,
      0,
      2.101555,
      NULL,
      2,
      3,
      4,
      1,
      3,
      0,
      0,
      2,
      NULL,
      5,
      4,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.972703,
      0.309998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1.179789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      2,
      1,
      5,
      1,
      1,
      3,
      NULL,
      1,
      1,
      4,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      3,
      1,
      4,
      3,
      3,
      4,
      NULL,
      1,
      0,
      2,
      0,
      4,
      5,
      5,
      2,
      4,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      3.689265,
      ' 2- 3-1989',
      14.752261,
      ' 2-17-2001',
      18.549908,
      0.894479,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      4,
      NULL,
      1,
      2,
      0,
      3,
      2,
      1.173456,
      2.928435,
      0.300655,
      ' 6-19-1974',
      1,
      '10- 5-1983',
      8.731611,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.935018,
      0,
      1,
      NULL,
      0,
      1.373549,
      NULL,
      3,
      0.017456,
      NULL,
      3,
      1,
      NULL,
      NULL,
      9,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      3,
      0.475150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940285,
      0.352348,
      0,
      0,
      3,
      0.782787,
      1,
      0,
      87.189330,
      1.486891,
      1.549096,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      3,
      2,
      3,
      0,
      NULL,
      0,
      3,
      NULL,
      2.859370,
      0,
      0.547305,
      1,
      2.417620,
      2.606526,
      0,
      NULL,
      NULL,
      0.894686,
      NULL,
      1.967562,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      9,
      8,
      7,
      4.893164,
      2.908027,
      7.400055,
      0.814433,
      0.767438,
      5,
      3.251628,
      1.698496,
      1.458794,
      NULL,
      3,
      0,
      NULL,
      6,
      9,
      75,
      NULL,
      1,
      1,
      '34104',
      '',
      NULL,
      1.137587,
      '',
      '',
      '',
      1.783850,
      NULL,
      '',
      '',
      0,
      NULL,
      9,
      1.381923,
      0.903619,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140842,
      NULL,
      NULL,
      1.855400,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.343147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537907,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796668,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493833,
      NULL,
      NULL,
      1.448787,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.560255,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.910291,
      NULL,
      NULL,
      1.379277,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.501867,
      0.890606,
      1.407849,
      NULL,
      NULL,
      NULL,
      2,
      3.954627,
      NULL,
      3.697933,
      3.184069,
      0.814609,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.320137,
      0,
      0,
      3,
      0.301713,
      NULL,
      3.537743,
      4.545841,
      1.130998,
      0.671019,
      3,
      0.436224,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      1.107593,
      NULL,
      7,
      4,
      2,
      NULL,
      NULL,
      NULL,
      0.767311,
      NULL,
      NULL,
      0.116299,
      1,
      1,
      1,
      0.932060,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178868,
      NULL,
      1,
      2,
      0.952363,
      1,
      0.256534,
      0,
      NULL,
      NULL,
      NULL,
      4.299398,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.230073,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.304882,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670172,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.960942,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.128522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.062242,
      NULL,
      NULL,
      NULL,
      2,
      1.036146,
      NULL,
      1.149911,
      3.945385,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.296539,
      1,
      2.399043,
      0,
      1,
      0.476571,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.768808,
      0,
      1,
      1.046229,
      0.209431,
      1.029189,
      1,
      1,
      NULL,
      1.905444,
      1.756648,
      1.881917,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      3,
      1,
      NULL,
      0,
      2,
      2,
      0.766944,
      NULL,
      2,
      NULL,
      1.205955,
      0,
      1,
      0.494622,
      1.661786,
      NULL,
      NULL,
      0,
      NULL,
      1.899399,
      1.154110,
      NULL,
      1.561275,
      NULL,
      0.756318,
      0.705358,
      1,
      0,
      0,
      NULL,
      1,
      0.143456,
      NULL,
      0,
      1,
      1.053930,
      0.642737,
      0.687843,
      1,
      0,
      0,
      1,
      0.722973,
      3,
      NULL,
      3.444138,
      1,
      1.800523,
      NULL,
      3.071412,
      NULL,
      0.387494,
      NULL,
      1,
      NULL,
      3.008060,
      NULL,
      1.127971,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597908,
      NULL,
      1.647931,
      NULL,
      8.326795,
      0.246138,
      NULL,
      0.827753,
      3.862452,
      0,
      NULL,
      NULL,
      0,
      1.388671,
      0.151727,
      NULL,
      1.191146,
      1.797264,
      0,
      NULL,
      2.641282,
      0.599949,
      NULL,
      1.727472,
      2.482518,
      0,
      NULL,
      1,
      1,
      1,
      0.270032,
      NULL,
      1.755586,
      1,
      NULL,
      0.204891,
      0.889879,
      1,
      0.673032,
      0.706923,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      111.444317,
      0.264520,
      NULL,
      0.982738,
      0.274364,
      '32341',
      '',
      '',
      0.864939,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


