set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      1.506316,
      0,
      6,
      0,
      '2013',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.614487,
      2,
      NULL,
      38,
      1,
      NULL,
      NULL,
      1,
      NULL,
      ' 0-25-2000',
      NULL,
      0.727866,
      2,
      3,
      2,
      NULL,
      3,
      NULL,
      2.454197,
      NULL,
      NULL,
      NULL,
      NULL,
      3.470988,
      1,
      NULL,
      NULL,
      9.592751,
      2,
      2,
      6,
      0.864395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3.469726,
      5,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      4,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      1.908604,
      0.096532,
      3.242751,
      2,
      2,
      0,
      0.141843,
      1,
      0.643885,
      3.514125,
      1,
      NULL,
      3.456830,
      1,
      0.308172,
      0,
      1,
      NULL,
      2.367194,
      1,
      1,
      0,
      1.483279,
      NULL,
      NULL,
      0.384896,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      5,
      3,
      NULL,
      0,
      3,
      3,
      NULL,
      1,
      7,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      0,
      5,
      2,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      4,
      NULL,
      2,
      0,
      3,
      5,
      NULL,
      0,
      4,
      1.469916,
      '10-18-1995',
      780,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      104,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.934299,
      1,
      0.544258,
      0.596947,
      NULL,
      0.043823,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374991,
      NULL,
      1,
      0.014410,
      1.665498,
      NULL,
      0.668695,
      1.695073,
      2,
      1.804050,
      0.021556,
      NULL,
      NULL,
      NULL,
      3,
      0.330087,
      3.742758,
      2,
      0,
      3,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      0,
      1,
      0.898941,
      NULL,
      0.284463,
      NULL,
      0.314142,
      3.766423,
      1,
      NULL,
      0.817724,
      0.096914,
      1,
      0,
      0,
      0.787575,
      0,
      0.988651,
      1.372305,
      0,
      NULL,
      11.162231,
      5.497732,
      1.602083,
      8,
      NULL,
      NULL,
      2,
      0.805668,
      1.977797,
      3.332850,
      0.386153,
      69,
      3,
      2,
      NULL,
      15,
      NULL,
      72,
      NULL,
      0,
      2,
      NULL,
      '',
      '',
      1.414162,
      '',
      '',
      '',
      0.453768,
      '',
      '',
      '',
      0.529759,
      19.096239,
      122.428653,
      11.509981,
      1.210098,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584318,
      1.072847,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.926992,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.494032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.055664,
      3.327896,
      5.578262,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.622230,
      0,
      1,
      NULL,
      NULL,
      3.642579,
      0,
      0.994203,
      NULL,
      1.894460,
      1.189461,
      2,
      0.915859,
      3,
      0.406631,
      3.939464,
      1,
      NULL,
      3.468577,
      NULL,
      1,
      0.078141,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.849986,
      NULL,
      NULL,
      3.244178,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340426,
      NULL,
      NULL,
      2.492787,
      0,
      1,
      0.112679,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680320,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.715885,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.517701,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.006787,
      NULL,
      NULL,
      1.219642,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.249801,
      2,
      0.737362,
      0.359895,
      0.104579,
      NULL,
      NULL,
      1.034777,
      NULL,
      NULL,
      3.586448,
      NULL,
      NULL,
      0,
      1.601119,
      1,
      2.485938,
      NULL,
      1.377744,
      4,
      1,
      0,
      1,
      1,
      1.415477,
      0,
      1,
      1,
      3,
      1,
      1,
      3.889157,
      0.796243,
      NULL,
      4.448283,
      0.850065,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1.675381,
      1.125835,
      0.002916,
      1,
      1.529062,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.562264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.680353,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.969551,
      0.529992,
      1.294835,
      1.065596,
      2.704461,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      99,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.813812,
      NULL,
      NULL,
      NULL,
      0.662981,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.739283,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.474561,
      NULL,
      NULL,
      NULL,
      7.130818,
      NULL,
      NULL,
      NULL,
      3.168719,
      2,
      NULL,
      5,
      0.817698,
      0.935408,
      3,
      0.826160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.199711,
      NULL,
      NULL,
      1.197015,
      NULL,
      NULL,
      1.676185,
      NULL,
      NULL,
      0,
      NULL,
      1.845948,
      198,
      0,
      0,
      1,
      0.586377,
      0.311605,
      0,
      0.903228,
      0.989052,
      NULL,
      1.051250,
      1.332309,
      0,
      0.931626,
      1,
      0,
      0,
      0.495370,
      0.850390,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0.334039,
      0,
      NULL,
      1,
      NULL,
      1.412567,
      2.329532,
      1,
      0,
      0.560607,
      NULL,
      1.067413,
      2.807033,
      NULL,
      3.241870,
      NULL,
      NULL,
      1.013260,
      0,
      NULL,
      1.522738,
      1.215697,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.584116,
      NULL,
      0.567764,
      0,
      NULL,
      1.246106,
      NULL,
      NULL,
      0.373186,
      1,
      NULL,
      0.007666,
      NULL,
      NULL,
      1,
      NULL,
      0.109672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457264,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      72,
      5,
      2,
      2,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.869240,
      '',
      '',
      '');
commit;
end;
/


