set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '0432030',
      0,
      1,
      2,
      3,
      '1334',
      1.316808,
      1,
      NULL,
      NULL,
      ' 0- 7-1979',
      3.881294,
      NULL,
      1,
      NULL,
      0.455394,
      NULL,
      NULL,
      1.974008,
      247,
      91.086962,
      NULL,
      NULL,
      NULL,
      ' 4-15-1995',
      3.165895,
      0.025792,
      3.656186,
      1.868156,
      NULL,
      2.783896,
      3,
      1.601800,
      1.111396,
      10.460901,
      6,
      0.472172,
      5,
      13.587627,
      NULL,
      5,
      0.249514,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      1.168256,
      1.639606,
      1.960239,
      0,
      NULL,
      0.388082,
      1,
      NULL,
      8,
      1,
      0,
      3,
      NULL,
      1,
      0,
      1,
      1,
      0,
      2,
      0,
      NULL,
      1,
      1,
      0,
      2,
      1,
      1,
      0,
      1,
      1.801858,
      NULL,
      NULL,
      1.904757,
      NULL,
      NULL,
      0,
      NULL,
      0.061154,
      1.059826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      2,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      4.578211,
      2,
      0,
      NULL,
      1,
      1,
      2,
      0,
      0,
      NULL,
      5,
      1,
      NULL,
      5,
      5,
      3,
      2,
      3,
      NULL,
      1,
      0,
      2,
      3,
      4,
      3,
      0,
      1.042991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1.495806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.189106,
      5,
      1.245792,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1.991264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626454,
      3,
      NULL,
      1,
      0,
      1.122557,
      0.646277,
      1,
      41,
      2.690829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469810,
      1.788137,
      3,
      3,
      0,
      2,
      NULL,
      1,
      2,
      1,
      1,
      1,
      2.441136,
      2.846536,
      13,
      59.353340,
      NULL,
      37.762132,
      192.682586,
      46.009128,
      NULL,
      0,
      1.267740,
      0,
      0.066923,
      NULL,
      1,
      1,
      2.364853,
      NULL,
      0,
      8,
      4,
      6,
      0.535116,
      NULL,
      4,
      NULL,
      1.753701,
      7,
      NULL,
      3.774308,
      NULL,
      55.530665,
      0,
      0,
      NULL,
      NULL,
      61,
      NULL,
      2,
      1.276543,
      1.404615,
      '40123',
      '',
      NULL,
      1,
      '23342',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      11.362830,
      28,
      37.626610,
      2,
      NULL,
      0.437414,
      2,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233587,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.270757,
      0,
      0.624627,
      0.735555,
      1,
      NULL,
      2.224921,
      2.440995,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.911921,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295739,
      NULL,
      NULL,
      0.547924,
      2,
      0.964138,
      3.259485,
      1,
      0.754669,
      1.709369,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      1.198419,
      1.329104,
      NULL,
      NULL,
      5.846247,
      2.015028,
      0,
      1.447252,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.467726,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5.397139,
      2.557540,
      2,
      3.128891,
      3.250560,
      4,
      0,
      NULL,
      NULL,
      1,
      0.843321,
      2,
      2.374861,
      1,
      3,
      NULL,
      0.664138,
      4,
      0.965856,
      7,
      1,
      NULL,
      1.403838,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.886488,
      0.579062,
      3,
      0.595592,
      NULL,
      7.521445,
      5,
      3,
      NULL,
      3,
      1.957074,
      NULL,
      NULL,
      0,
      0.486407,
      1,
      0,
      0.912250,
      2.886750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.362661,
      NULL,
      NULL,
      0.285239,
      NULL,
      NULL,
      1.992333,
      NULL,
      NULL,
      1.367672,
      NULL,
      NULL,
      1.269756,
      NULL,
      NULL,
      0.915871,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.274624,
      NULL,
      NULL,
      1.380260,
      NULL,
      NULL,
      1,
      0.480567,
      1.164598,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      4.106258,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.053136,
      0.854968,
      NULL,
      NULL,
      0.007644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399426,
      0.739848,
      NULL,
      NULL,
      0.782525,
      NULL,
      NULL,
      NULL,
      2.123421,
      NULL,
      NULL,
      NULL,
      1.298680,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.848948,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.496861,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.401907,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114737,
      1.181387,
      6.647114,
      3.837938,
      9,
      3,
      1,
      NULL,
      NULL,
      1.891162,
      NULL,
      NULL,
      0.831126,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.690980,
      NULL,
      NULL,
      140,
      7,
      0.156301,
      1,
      1.146102,
      0.391814,
      0,
      1,
      1,
      0.329468,
      1,
      1,
      0.675344,
      NULL,
      1.258427,
      0,
      0.542459,
      1.348721,
      NULL,
      0.244456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.014363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678035,
      1.033100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268343,
      0.947280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.085667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567990,
      NULL,
      NULL,
      0.245960,
      NULL,
      0.517890,
      NULL,
      NULL,
      NULL,
      0.067228,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      5.025393,
      NULL,
      5.216615,
      0,
      1,
      9,
      3.769237,
      NULL,
      3,
      0.217449,
      1,
      1.682515,
      3.181721,
      3.737156,
      NULL,
      3,
      3,
      NULL,
      1,
      0.444348,
      0.481829,
      NULL,
      1,
      NULL,
      1.264301,
      1.069919,
      NULL,
      0,
      1,
      0.164625,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      1.583886,
      1.069504,
      3.899857,
      3.758865,
      0.536592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355504,
      1,
      1.864977,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.721874,
      NULL,
      0.092233,
      NULL,
      0.598458,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.842483,
      NULL,
      1.553363,
      NULL,
      0.240881,
      0,
      0.694850,
      1.890959,
      0,
      1.688373,
      0.699603,
      0,
      NULL,
      6,
      2,
      2,
      0,
      NULL,
      NULL,
      25.454099,
      NULL,
      0.526467,
      1,
      '30422',
      '',
      '',
      NULL,
      '44110',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


