set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7703389';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3.185345,
      1,
      3,
      3,
      NULL,
      0.116259,
      3,
      '112',
      NULL,
      66,
      42,
      NULL,
      3,
      NULL,
      NULL,
      0,
      '4212',
      0,
      1,
      NULL,
      NULL,
      '11-29-1977',
      180.256636,
      216.179610,
      NULL,
      0.625333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1988',
      NULL,
      1,
      1,
      0,
      0,
      3,
      0,
      0.052483,
      0,
      53,
      5,
      2,
      3.388629,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1.128209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.299635,
      NULL,
      3,
      2.411381,
      0,
      1,
      NULL,
      2.935700,
      1.314735,
      0,
      0.409456,
      0,
      3.348277,
      1,
      NULL,
      0,
      1,
      0,
      5,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0.078308,
      NULL,
      1.708676,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      3.364009,
      '10- 7-1999',
      472,
      NULL,
      NULL,
      3.518643,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.096710,
      1,
      1,
      3.676728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379204,
      1,
      0,
      NULL,
      1,
      0.676049,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.532293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.072768,
      0.495416,
      1,
      0,
      0.556706,
      NULL,
      1.954528,
      0,
      NULL,
      0,
      0.035235,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      2,
      5,
      1,
      1.940519,
      NULL,
      1.327275,
      1.504772,
      5,
      NULL,
      0.692291,
      1,
      0.301959,
      1,
      0.002178,
      1,
      1.151556,
      0,
      NULL,
      NULL,
      1,
      6,
      4.091153,
      4.321180,
      NULL,
      1.520719,
      0.307451,
      1.742327,
      1.857071,
      6,
      0,
      NULL,
      0,
      28.753440,
      0,
      1,
      90,
      NULL,
      NULL,
      NULL,
      4,
      0.737102,
      1.670261,
      '32400',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      22,
      585,
      36.731535,
      1.828031,
      NULL,
      5,
      NULL,
      0,
      3.056875,
      2.657585,
      NULL,
      1.612970,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      3,
      0.766295,
      0,
      NULL,
      1.522191,
      NULL,
      0,
      1,
      0.148293,
      NULL,
      0,
      1,
      8,
      2,
      1,
      NULL,
      0.815759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.414883,
      NULL,
      0.702774,
      1,
      0,
      3.445033,
      0.285023,
      3,
      NULL,
      1.439890,
      0.490588,
      0,
      0,
      3,
      1,
      1,
      1,
      0.687866,
      0,
      0.276517,
      NULL,
      0.700533,
      NULL,
      2.002496,
      1.362254,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.869177,
      0.966858,
      1,
      4,
      1.032151,
      10,
      NULL,
      0.577016,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606551,
      NULL,
      NULL,
      1.713450,
      0.446837,
      0,
      2.153478,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.867670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.832817,
      NULL,
      NULL,
      2.554882,
      3,
      3.981831,
      1.477034,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      0,
      3.118915,
      0.648589,
      1,
      6.354031,
      2,
      4,
      NULL,
      1.139388,
      1,
      0.574534,
      1.433602,
      1,
      1.859106,
      NULL,
      NULL,
      3,
      2.377379,
      NULL,
      NULL,
      3.044245,
      NULL,
      0.274886,
      NULL,
      NULL,
      0.421965,
      2,
      2,
      1,
      NULL,
      1,
      0,
      0.776822,
      0.108383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      101.423631,
      NULL,
      NULL,
      0.106411,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.970429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.281688,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.504436,
      NULL,
      NULL,
      0,
      NULL,
      0.384461,
      0.598269,
      0,
      NULL,
      0.419383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.847198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691570,
      NULL,
      NULL,
      NULL,
      1.102660,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.205954,
      NULL,
      NULL,
      NULL,
      1.282898,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.385283,
      NULL,
      NULL,
      NULL,
      0.933233,
      0,
      1,
      NULL,
      2.761060,
      451.439440,
      143.904710,
      3.299527,
      NULL,
      10,
      0,
      NULL,
      NULL,
      1.337941,
      5,
      3.637135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254297,
      NULL,
      1.714944,
      585.817949,
      1.884379,
      0,
      0,
      NULL,
      1.052365,
      1,
      0.254310,
      1.712674,
      0,
      1.293848,
      NULL,
      0.486420,
      0,
      1,
      1,
      0,
      0.279985,
      1,
      0,
      NULL,
      1.207319,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.078416,
      NULL,
      1,
      NULL,
      103,
      NULL,
      0.024317,
      34.477487,
      57.461527,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443497,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.956079,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.617021,
      NULL,
      1,
      NULL,
      1.899783,
      NULL,
      1.057375,
      NULL,
      1.299229,
      NULL,
      0.930064,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010137,
      0.542838,
      0.245247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759431,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.654066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.018047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284070,
      0,
      NULL,
      0.393060,
      NULL,
      1.275894,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.826610,
      NULL,
      1.839820,
      NULL,
      0.169176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      1,
      1.863333,
      1.253581,
      0,
      1,
      3.020591,
      2,
      1,
      NULL,
      2.647093,
      NULL,
      NULL,
      0.669609,
      NULL,
      0,
      3,
      NULL,
      0.696612,
      1.476699,
      NULL,
      0,
      1,
      NULL,
      1.770445,
      0,
      NULL,
      1,
      3,
      NULL,
      0.722571,
      0.007143,
      NULL,
      1,
      1.470037,
      NULL,
      1.736458,
      2.278687,
      NULL,
      1,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.917646,
      NULL,
      1,
      5,
      3,
      1.233987,
      NULL,
      NULL,
      NULL,
      42,
      3,
      5.092423,
      2,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


