set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '4122242',
      1.907248,
      1.434497,
      1,
      3,
      NULL,
      3,
      0.899334,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      2,
      2.157028,
      '11- 6-1996',
      55.066497,
      0.674055,
      254.107492,
      139.270451,
      2,
      ' 2-20-1990',
      NULL,
      ' 0-11-1999',
      3.742305,
      2.586770,
      1,
      2.069569,
      0.519246,
      1,
      NULL,
      1.869233,
      0.121830,
      9,
      8,
      NULL,
      NULL,
      30.271966,
      33.748874,
      NULL,
      3.093829,
      0,
      NULL,
      2,
      0.393666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      2,
      2,
      0,
      3,
      8,
      2,
      2,
      1,
      2,
      1.507012,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      5,
      1.382636,
      0.980499,
      1.816899,
      3,
      2.692740,
      2,
      1.894209,
      1,
      0,
      1.738794,
      3,
      0,
      0,
      1.762443,
      0.062443,
      2,
      NULL,
      4,
      5,
      4,
      3,
      NULL,
      0,
      0.600501,
      NULL,
      NULL,
      1.810690,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      3,
      4,
      3,
      NULL,
      3,
      0,
      0,
      4,
      NULL,
      6.747610,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      5,
      5,
      0,
      NULL,
      1,
      3,
      2,
      2,
      3,
      5,
      3,
      1,
      NULL,
      1,
      NULL,
      4,
      NULL,
      5,
      4,
      0,
      NULL,
      1,
      4,
      NULL,
      1.972491,
      ' 7-22-1983',
      NULL,
      ' 9-12-2001',
      13,
      1.244444,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      5,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.536335,
      2.344268,
      0,
      0.394599,
      2.109688,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.908575,
      1.569196,
      2,
      0,
      0,
      2.184064,
      118.479562,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      2,
      0,
      3,
      2,
      1,
      NULL,
      2,
      0,
      2.221523,
      1.403605,
      NULL,
      NULL,
      0,
      1,
      0.543100,
      1,
      NULL,
      0.258429,
      NULL,
      0.315494,
      NULL,
      0.658943,
      1,
      1.153353,
      0,
      0.373413,
      0.465044,
      11.943971,
      4,
      NULL,
      3,
      0.131217,
      NULL,
      0.690927,
      1.597471,
      0.905392,
      2.248771,
      NULL,
      4,
      2,
      0.191463,
      NULL,
      NULL,
      12,
      53.358238,
      0,
      0.722311,
      0,
      '42313',
      '',
      '',
      1.285831,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      0.790762,
      39.026143,
      95.260250,
      0.916474,
      NULL,
      47.768169,
      0,
      0.472152,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      3,
      3.533611,
      NULL,
      NULL,
      0.656184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.811325,
      NULL,
      0,
      1.872366,
      2.039907,
      2,
      3,
      0.822184,
      3.067731,
      0,
      1.817215,
      1.015171,
      2,
      0.804481,
      1,
      NULL,
      NULL,
      3.237782,
      5,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0.622747,
      NULL,
      NULL,
      NULL,
      2,
      0.321577,
      1,
      0.012925,
      NULL,
      NULL,
      3,
      3,
      0.923226,
      1,
      1,
      1.780687,
      NULL,
      2,
      1,
      1.547302,
      1,
      0,
      0.777274,
      1,
      NULL,
      1,
      3.591604,
      3,
      3,
      0.365767,
      NULL,
      NULL,
      0.001011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      2,
      0.940165,
      0.842587,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.351823,
      0.128643,
      1.033145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.362184,
      NULL,
      3,
      1,
      0,
      2.733901,
      3,
      NULL,
      1.458512,
      3.469871,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.834168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.180301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.855206,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      4.073063,
      1,
      7,
      NULL,
      1,
      NULL,
      3.954280,
      NULL,
      NULL,
      1.463655,
      NULL,
      NULL,
      2.122523,
      1.766661,
      3,
      2.872610,
      2.888850,
      6.798972,
      5.150168,
      NULL,
      1,
      3.228807,
      3,
      4,
      0.084710,
      NULL,
      NULL,
      1.224599,
      3,
      1.400723,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.934726,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.838799,
      NULL,
      NULL,
      0.104339,
      3,
      NULL,
      2,
      3,
      NULL,
      2.517784,
      0,
      NULL,
      0.294067,
      1.154112,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      9,
      6,
      NULL,
      3.696822,
      1.611945,
      NULL,
      0.040892,
      0,
      1.320936,
      1.142913,
      0.827799,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.566656,
      NULL,
      NULL,
      NULL,
      1.796940,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.677107,
      NULL,
      NULL,
      NULL,
      2.187533,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.272021,
      NULL,
      NULL,
      NULL,
      0.145315,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.998054,
      NULL,
      51.928273,
      1.620572,
      NULL,
      NULL,
      1.531387,
      NULL,
      1,
      227,
      1.540195,
      0,
      0,
      NULL,
      0,
      0.381463,
      1.597150,
      1.248095,
      1,
      1.755413,
      1.408860,
      NULL,
      0,
      0.378358,
      1.670922,
      0,
      0.402244,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      2.890906,
      3.738718,
      3.032884,
      NULL,
      10.822215,
      0.118235,
      NULL,
      3.417175,
      NULL,
      0.646099,
      0,
      1,
      2.346020,
      NULL,
      1.832442,
      0.618957,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.807197,
      NULL,
      2,
      1.665087,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      3.379013,
      1,
      1.036636,
      0.227841,
      NULL,
      3.833218,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.813530,
      1,
      0.102430,
      NULL,
      0.277258,
      3,
      4,
      7,
      1.303129,
      NULL,
      NULL,
      32,
      75.478277,
      1,
      NULL,
      2,
      '33320',
      '',
      NULL,
      0.194198,
      '',
      '',
      '',
      1.187327,
      '',
      '',
      '');
commit;
end;
/


