set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9690575';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      NULL,
      20.135848,
      6.009145,
      '1300403',
      1,
      1.772742,
      NULL,
      NULL,
      '3401',
      2.961695,
      0.443652,
      NULL,
      NULL,
      ' 3- 6-1977',
      42.330884,
      NULL,
      NULL,
      0,
      1.586787,
      ' 2- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-23-1997',
      ' 0- 1-1977',
      ' 1- 4-1995',
      0.933476,
      NULL,
      2.245496,
      NULL,
      1,
      2,
      2,
      1,
      1,
      481,
      6,
      9.819731,
      9.041185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      0.585995,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      1,
      NULL,
      4,
      1,
      1,
      4,
      0,
      1,
      3,
      0,
      NULL,
      0,
      1,
      1,
      4.520896,
      NULL,
      1,
      0,
      1,
      1.451903,
      NULL,
      NULL,
      0.696841,
      NULL,
      NULL,
      NULL,
      2,
      1.211153,
      1.899785,
      NULL,
      1.695015,
      2,
      2.260143,
      3.795142,
      2.256327,
      1.063678,
      NULL,
      0,
      0.660142,
      0,
      1.514869,
      0,
      0,
      2.930665,
      1,
      0,
      NULL,
      0,
      0,
      0,
      4,
      0,
      NULL,
      NULL,
      0.404818,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1,
      1,
      3,
      3,
      1,
      0,
      3.944279,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      3,
      0,
      5,
      0,
      2,
      NULL,
      5,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5.009384,
      3,
      '10- 7-1983',
      273,
      ' 7-18-1997',
      1244.239536,
      2.948253,
      0,
      0,
      2,
      0,
      NULL,
      3,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      5.288988,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.701707,
      1.470802,
      1,
      1.023160,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.015347,
      1,
      0.369451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      0.267302,
      NULL,
      0.200023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.124063,
      NULL,
      3,
      2,
      1,
      0,
      1,
      NULL,
      3,
      3,
      3,
      NULL,
      1.623383,
      3.372956,
      3.579684,
      3.571350,
      3.959433,
      0,
      NULL,
      NULL,
      1.637967,
      0.278188,
      NULL,
      NULL,
      1.686121,
      1,
      1.302051,
      1,
      1.699358,
      NULL,
      1.217385,
      4,
      3,
      NULL,
      6,
      0,
      0,
      NULL,
      2.664997,
      3,
      2,
      2.074412,
      0.547349,
      NULL,
      2,
      1,
      NULL,
      NULL,
      12,
      63,
      4,
      2,
      0,
      '23043',
      '',
      NULL,
      0.865882,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      0.849224,
      5,
      239,
      NULL,
      NULL,
      NULL,
      1.822696,
      35,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      3.096698,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.409169,
      2.274093,
      0,
      NULL,
      NULL,
      1.584122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.432685,
      NULL,
      NULL,
      6,
      NULL,
      6.370912,
      0,
      0.564771,
      NULL,
      NULL,
      NULL,
      0.421263,
      NULL,
      NULL,
      NULL,
      1.082982,
      0,
      3,
      2.648361,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1.788810,
      NULL,
      0.766407,
      NULL,
      0,
      1.925446,
      0,
      0,
      NULL,
      1,
      1.756336,
      NULL,
      2,
      2.336603,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.666462,
      NULL,
      NULL,
      2,
      1.792747,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.798626,
      NULL,
      NULL,
      NULL,
      0.076438,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0.651388,
      NULL,
      NULL,
      NULL,
      7,
      2.143960,
      NULL,
      0.184527,
      NULL,
      3.104358,
      0,
      2.109299,
      NULL,
      6,
      5.283028,
      7.999538,
      NULL,
      NULL,
      NULL,
      1.641330,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.669384,
      NULL,
      NULL,
      0.230996,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.253103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682576,
      NULL,
      NULL,
      NULL,
      1,
      2.464012,
      0.844857,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      3,
      NULL,
      1,
      0,
      0.637797,
      3.239704,
      3.598272,
      1,
      3.511056,
      NULL,
      1,
      NULL,
      5.287326,
      3,
      0,
      1,
      2,
      4,
      NULL,
      3,
      0,
      0.073577,
      1,
      3.677432,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      155,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.483474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.547164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698471,
      NULL,
      NULL,
      3.951054,
      NULL,
      NULL,
      3.930014,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.589792,
      1,
      0.927170,
      0.081036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925419,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.819467,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.180076,
      NULL,
      NULL,
      NULL,
      0.562133,
      60.003174,
      11.545135,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0.836860,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415701,
      NULL,
      NULL,
      0,
      1.031022,
      1.289914,
      0,
      NULL,
      1.835528,
      1.372491,
      1,
      0.839543,
      1,
      1.616846,
      0.690435,
      0,
      0,
      0.058821,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.192998,
      1.272272,
      1,
      3,
      2,
      4.769948,
      0,
      0.129430,
      1,
      1,
      1.277955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.579118,
      0.825656,
      NULL,
      0.424078,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.744436,
      3.288661,
      NULL,
      1,
      0,
      NULL,
      1,
      0.671477,
      0.488617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.985298,
      NULL,
      NULL,
      0,
      4,
      3.089873,
      1.181437,
      3.309981,
      NULL,
      NULL,
      3,
      5.768486,
      0.538243,
      '43203',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.730897,
      '',
      '',
      '');
commit;
end;
/


