set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7038100';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1210342',
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      52.540129,
      ' 6-14-2003',
      NULL,
      NULL,
      0,
      2,
      0.521315,
      NULL,
      68,
      3.619190,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.844020,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      221.991606,
      6,
      NULL,
      4.659868,
      25.940788,
      NULL,
      5,
      6,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      0.440641,
      1.612907,
      0,
      0.026077,
      0,
      0,
      1,
      112.319589,
      5,
      6,
      7,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      4.642161,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      1.638805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      2,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      0,
      1,
      4,
      2,
      1,
      NULL,
      1,
      1,
      NULL,
      4,
      NULL,
      0,
      5,
      1,
      2,
      3,
      0,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      0.427639,
      '10-15-1986',
      1840,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.753431,
      NULL,
      0,
      1,
      1.037821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.229868,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0.605185,
      0,
      1.663652,
      NULL,
      1.044992,
      1.074489,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      3,
      0,
      0,
      0,
      2,
      1.762749,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0.117965,
      NULL,
      NULL,
      0.860336,
      NULL,
      NULL,
      NULL,
      0.101697,
      NULL,
      NULL,
      0.404043,
      3,
      NULL,
      5.633557,
      3.314538,
      0,
      0.808307,
      10,
      3,
      1,
      NULL,
      NULL,
      1.147947,
      1.016704,
      0,
      NULL,
      0,
      0,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '22441',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      7.218330,
      NULL,
      3.405698,
      NULL,
      41,
      4.918800,
      361,
      NULL,
      0,
      3.715872,
      1,
      0,
      NULL,
      NULL,
      2.865073,
      2,
      NULL,
      3.253053,
      0.061108,
      0,
      13.698137,
      NULL,
      NULL,
      1,
      0,
      7,
      0.704853,
      1.195977,
      1.308699,
      NULL,
      NULL,
      NULL,
      1.380640,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.329360,
      NULL,
      NULL,
      7.618580,
      4.509392,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      0.803998,
      2.323406,
      2.933618,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0.505014,
      0,
      1.304128,
      0.428847,
      1,
      1,
      NULL,
      0.600648,
      0,
      1,
      NULL,
      0.580467,
      0.652671,
      NULL,
      13.169397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706450,
      1,
      1,
      0.858278,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      19,
      0,
      NULL,
      NULL,
      3.931636,
      0.351309,
      9.318156,
      1.234054,
      NULL,
      NULL,
      1.080424,
      NULL,
      NULL,
      2.665152,
      NULL,
      1,
      0.561077,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.429780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.684030,
      NULL,
      3.062877,
      1.290216,
      NULL,
      3,
      NULL,
      NULL,
      4.345635,
      NULL,
      2.368662,
      NULL,
      8.866441,
      7,
      NULL,
      1.325093,
      2.600425,
      0.442696,
      3,
      NULL,
      2.560304,
      1.812686,
      3,
      NULL,
      2.380341,
      NULL,
      5,
      3.798257,
      NULL,
      NULL,
      3.073174,
      NULL,
      2.188334,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.684152,
      5.121639,
      8,
      2,
      7,
      4,
      2.903098,
      0,
      0,
      2,
      0,
      0,
      0,
      1,
      1,
      2.494588,
      NULL,
      NULL,
      1.394892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079898,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.096993,
      NULL,
      NULL,
      3.832365,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2.549683,
      NULL,
      1.814856,
      3,
      6,
      1.175789,
      NULL,
      21.059408,
      NULL,
      NULL,
      NULL,
      1.326472,
      2,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1.302175,
      3.269433,
      0.317672,
      0,
      NULL,
      0.802081,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.282628,
      2,
      3,
      NULL,
      1,
      1.310401,
      NULL,
      1,
      0.396288,
      NULL,
      1,
      NULL,
      0,
      14,
      3.974610,
      2.216390,
      1.691165,
      0.334624,
      0.663418,
      1.979809,
      0.664748,
      NULL,
      3.572826,
      NULL,
      1,
      NULL,
      1.942077,
      0,
      0,
      3.843157,
      NULL,
      3,
      NULL,
      1.963663,
      NULL,
      0.111336,
      1,
      3,
      0,
      10,
      3.960798,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.761241,
      11,
      9.781582,
      NULL,
      2.487335,
      3.732915,
      2,
      7.110164,
      0,
      0,
      2.069090,
      241.657767,
      23.429328,
      0,
      16.677266,
      1.831611,
      0,
      NULL,
      NULL,
      0.429013,
      NULL,
      0,
      0.012445,
      NULL,
      NULL,
      0.874169,
      NULL,
      NULL,
      2.790124,
      21.186351,
      1.833181,
      NULL,
      6,
      NULL,
      0.719282,
      NULL,
      1.743263,
      1,
      1.497891,
      1,
      1.637630,
      0.706881,
      NULL,
      0,
      0,
      NULL,
      0,
      0.569890,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      12,
      4,
      5.757742,
      NULL,
      0,
      7.273795,
      2.613881,
      1,
      1,
      NULL,
      1,
      1,
      3.911978,
      3.595302,
      1.906914,
      2.236083,
      2.129060,
      3,
      NULL,
      1.834491,
      1.682499,
      NULL,
      3,
      3,
      0.615427,
      NULL,
      1,
      2,
      1,
      3.510950,
      NULL,
      3.764545,
      1.284924,
      2,
      1,
      1,
      1,
      0,
      2,
      0,
      1,
      1.474557,
      NULL,
      NULL,
      1.289077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.133279,
      2,
      3.947790,
      0,
      1,
      1.206100,
      0.375881,
      0.190721,
      0,
      0,
      NULL,
      1.612485,
      1.309723,
      1.081845,
      0.730257,
      1.487765,
      0.872862,
      0.382201,
      0,
      1.579338,
      0,
      0,
      0.567636,
      2.741469,
      14.189800,
      NULL,
      0.708521,
      NULL,
      1.792657,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4,
      2.358921,
      0.478705,
      3,
      32,
      NULL,
      5,
      1.110560,
      3,
      '21402',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


