set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '02',
      6.653724,
      38,
      '1324213',
      1.449045,
      NULL,
      0,
      0,
      '2332',
      5,
      0.067242,
      NULL,
      NULL,
      ' 4-14-1983',
      150.509479,
      8,
      NULL,
      0,
      0,
      ' 5- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-16-1988',
      NULL,
      NULL,
      NULL,
      2.671043,
      2,
      1,
      NULL,
      1.642800,
      0,
      1.788229,
      0.995437,
      8,
      1,
      17.434984,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026005,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      0,
      3.717013,
      0,
      1,
      NULL,
      1,
      0.338314,
      0.639925,
      1.485687,
      1.299379,
      0.894429,
      3.117102,
      1.481724,
      1.120775,
      3,
      1,
      NULL,
      8,
      0,
      NULL,
      3,
      0.243115,
      NULL,
      NULL,
      1.456567,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      3,
      1,
      1,
      1,
      0,
      1,
      1,
      4.035194,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      3,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      3,
      NULL,
      2,
      5,
      NULL,
      NULL,
      NULL,
      ' 3-21-1975',
      32,
      ' 5-19-1986',
      59,
      1,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638628,
      0,
      2.877535,
      NULL,
      5,
      0.215455,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.152902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.474180,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.923776,
      9.308269,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.883424,
      3,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      1.024115,
      3,
      1,
      1.515567,
      1.797028,
      1,
      1,
      1,
      1.940578,
      1.637120,
      0,
      1,
      0,
      0.608899,
      0.639957,
      1,
      0,
      1,
      0,
      4.069439,
      7.495696,
      0.016154,
      3,
      7,
      6.554816,
      1.540702,
      2.473885,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      54,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      '32311',
      '',
      '',
      1.074501,
      '',
      NULL,
      '',
      0.860861,
      '',
      NULL,
      '',
      1.858481,
      6,
      NULL,
      25,
      3,
      NULL,
      6,
      NULL,
      0,
      2.227409,
      0.709781,
      3.268798,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.891544,
      0.116850,
      1.633862,
      3,
      1.988345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.916219,
      NULL,
      NULL,
      0.540932,
      NULL,
      NULL,
      7.074549,
      8,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538955,
      NULL,
      NULL,
      NULL,
      2.947526,
      1,
      3.394461,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.312547,
      NULL,
      1.352534,
      NULL,
      0,
      1,
      0.348855,
      NULL,
      0.061686,
      1,
      NULL,
      0,
      1.342834,
      3.597827,
      NULL,
      1,
      0,
      NULL,
      0,
      0.984792,
      NULL,
      NULL,
      2,
      2,
      3,
      4,
      4.557898,
      1.972574,
      1,
      1.210454,
      NULL,
      NULL,
      NULL,
      0.851656,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.969985,
      NULL,
      NULL,
      1.358511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.595268,
      0.650664,
      1.334054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.077917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683371,
      NULL,
      NULL,
      1,
      0,
      2.410257,
      NULL,
      NULL,
      NULL,
      2.865650,
      4.110158,
      1.571404,
      5,
      NULL,
      1.716519,
      NULL,
      NULL,
      NULL,
      3.040256,
      NULL,
      2.246948,
      0,
      1,
      3,
      3,
      3,
      0,
      2.526888,
      7,
      0,
      1,
      1,
      2,
      1.348527,
      NULL,
      2,
      2,
      0.515272,
      0,
      NULL,
      3,
      3,
      8,
      NULL,
      2,
      4,
      4.757687,
      5,
      2,
      1,
      3,
      1.104823,
      NULL,
      0.967822,
      0.345895,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.047978,
      NULL,
      NULL,
      0.644511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860537,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.935243,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      NULL,
      NULL,
      NULL,
      0.774470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.865749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122738,
      NULL,
      NULL,
      NULL,
      1.005802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331695,
      NULL,
      NULL,
      NULL,
      2.169858,
      4.157196,
      NULL,
      2.114830,
      32.548232,
      1126,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7586,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401379,
      730.820126,
      NULL,
      1.646543,
      1.993950,
      1,
      1.662109,
      0,
      1.996483,
      0,
      1.497618,
      0,
      NULL,
      NULL,
      1.294120,
      1.822569,
      1,
      0.823607,
      0.763832,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642458,
      1,
      1.465871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149842,
      1.740654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.445277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746480,
      0.638108,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.888325,
      NULL,
      1.062095,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      0.915638,
      2,
      0,
      3.746499,
      NULL,
      8,
      3,
      0,
      NULL,
      1.418673,
      1.280115,
      NULL,
      2,
      1.577105,
      NULL,
      0.374420,
      1,
      NULL,
      0,
      1.770978,
      NULL,
      2.132271,
      1,
      NULL,
      3,
      3.319967,
      NULL,
      2.385908,
      1.691639,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409525,
      0.192001,
      0.954050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.912360,
      NULL,
      1,
      0,
      3,
      1.295485,
      NULL,
      NULL,
      31,
      7.096520,
      4,
      4,
      0,
      '44242',
      '',
      '',
      1.924146,
      '',
      '',
      '',
      1.690018,
      '',
      '',
      '');
commit;
end;
/


