set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6510781';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '2132444',
      NULL,
      1.845987,
      0,
      2,
      '3012',
      NULL,
      1.779563,
      NULL,
      NULL,
      '10-10-1995',
      41.082944,
      NULL,
      NULL,
      0,
      NULL,
      ' 2-26-1997',
      31.181157,
      2,
      292.353440,
      149.013741,
      0,
      ' 9-25-1980',
      ' 3-18-1979',
      NULL,
      2.816906,
      1.985164,
      NULL,
      0.168732,
      1.809801,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.120937,
      NULL,
      1.130085,
      9,
      3,
      10.090551,
      NULL,
      3,
      0.141125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2.425277,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1.085465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.963914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.906326,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      5,
      5,
      1,
      1,
      0,
      4,
      0,
      3,
      3,
      5,
      1,
      5,
      2,
      5,
      4,
      NULL,
      1,
      2,
      0.622865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      1.506378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.204254,
      NULL,
      NULL,
      NULL,
      0.825752,
      4.201487,
      3,
      NULL,
      0,
      0,
      0.318078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.950792,
      NULL,
      3,
      NULL,
      1.673062,
      NULL,
      52.715637,
      1.919983,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.618408,
      2.935471,
      2,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      3,
      0.775511,
      3.151478,
      2.472334,
      1,
      1,
      NULL,
      3.089724,
      0,
      1,
      0.032802,
      0,
      NULL,
      1.066906,
      1.751372,
      0,
      1,
      0.586072,
      1.211570,
      0,
      9.244713,
      7,
      0.554556,
      8,
      8.264947,
      2.408106,
      0.271214,
      NULL,
      1.377357,
      NULL,
      NULL,
      0.105453,
      37.485611,
      0,
      1,
      NULL,
      70,
      48,
      9.872358,
      3,
      NULL,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2,
      NULL,
      213,
      11,
      0,
      30,
      2,
      13.539904,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.009660,
      0,
      2,
      1.952353,
      1,
      1,
      0.446015,
      1,
      0,
      NULL,
      NULL,
      3.340537,
      NULL,
      0.842522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.458581,
      7,
      1,
      NULL,
      3,
      3,
      1.242097,
      NULL,
      3.178946,
      3,
      1.609677,
      2.350138,
      3,
      0,
      1.388610,
      0.052961,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.086648,
      0.789470,
      0,
      2.388476,
      1,
      2,
      0.516092,
      3.165698,
      1,
      3,
      1.391590,
      0.727913,
      0,
      1.446979,
      0,
      1,
      0.617906,
      NULL,
      NULL,
      1.847507,
      NULL,
      NULL,
      0.727938,
      NULL,
      NULL,
      5.241969,
      1,
      1,
      1,
      2,
      NULL,
      0.024893,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.479976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149441,
      3.717772,
      NULL,
      0,
      NULL,
      NULL,
      6.250350,
      2.076648,
      2.764000,
      0.355790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.926255,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769658,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.867079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      1,
      0.264924,
      NULL,
      3,
      NULL,
      0.858034,
      0,
      1,
      2.187589,
      3.263749,
      0.175602,
      NULL,
      NULL,
      NULL,
      1,
      2.856602,
      1,
      2,
      7.413627,
      NULL,
      NULL,
      6.446617,
      0,
      3,
      0,
      0,
      3,
      0.991143,
      1.085968,
      2,
      NULL,
      3.754958,
      1.229653,
      NULL,
      1,
      NULL,
      292,
      NULL,
      1.127537,
      1.581029,
      NULL,
      1.201438,
      1.577905,
      NULL,
      0.242392,
      NULL,
      NULL,
      2.569708,
      NULL,
      NULL,
      1.358917,
      0.023200,
      0.210971,
      2,
      NULL,
      1.636778,
      NULL,
      1.082216,
      1.171454,
      2.658382,
      NULL,
      1,
      1.365458,
      1.790535,
      1.665663,
      1,
      1.649971,
      0.206739,
      0,
      3.252072,
      0.626501,
      1,
      5,
      1.604552,
      2.836884,
      NULL,
      3,
      0,
      NULL,
      3,
      0.802843,
      0.170457,
      2.749121,
      1,
      0.086367,
      2.866340,
      NULL,
      101.882412,
      204,
      17.142887,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.620234,
      2.817887,
      0.325046,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.607192,
      2.671495,
      0,
      1.486275,
      1.723466,
      0.838052,
      2.129674,
      3,
      0.920423,
      NULL,
      3.519510,
      3.319612,
      3.190997,
      3,
      0,
      2.842118,
      NULL,
      1.735560,
      1.431581,
      0,
      2,
      3,
      2,
      2.363223,
      NULL,
      1,
      NULL,
      0,
      3.613937,
      2,
      3,
      2.468830,
      3,
      2,
      0.870736,
      3.733275,
      1.037353,
      0,
      0.189167,
      0,
      NULL,
      0.030763,
      3,
      NULL,
      1,
      1,
      NULL,
      0.807976,
      3.450664,
      12,
      6,
      13,
      1,
      3,
      0.466783,
      NULL,
      NULL,
      NULL,
      0,
      96.536188,
      NULL,
      1.609285,
      22.306266,
      3,
      0,
      1.848829,
      0,
      0.191588,
      NULL,
      NULL,
      1,
      13,
      4.111961,
      1,
      NULL,
      NULL,
      1.599594,
      NULL,
      0,
      37.821912,
      13.203845,
      0,
      1.713291,
      0.049741,
      0,
      NULL,
      0.469300,
      0.759905,
      1.868118,
      1,
      NULL,
      NULL,
      0.944087,
      0.398355,
      1,
      1,
      NULL,
      NULL,
      0.747883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      3,
      4.369402,
      0.620566,
      NULL,
      3.698184,
      2.806163,
      1.058526,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.959768,
      2,
      0.256169,
      1,
      2.394448,
      0.092079,
      1.988012,
      3,
      0,
      3,
      0.092316,
      0.995704,
      NULL,
      0.760464,
      NULL,
      0,
      0.801271,
      1,
      NULL,
      0.756157,
      NULL,
      0.290493,
      3.557436,
      2.452260,
      1.610453,
      3,
      1,
      1,
      1.944511,
      NULL,
      1.784406,
      0,
      1.065276,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1.298015,
      0,
      0,
      0,
      1.402024,
      0,
      0.503589,
      2,
      NULL,
      2,
      0,
      1,
      0.962269,
      1,
      NULL,
      NULL,
      NULL,
      0.036665,
      NULL,
      1.321768,
      3.004359,
      NULL,
      2,
      NULL,
      0.314913,
      NULL,
      0.616560,
      3,
      0.245007,
      0,
      0.357112,
      3,
      NULL,
      2.305844,
      1.074279,
      0.323421,
      3,
      0,
      1,
      NULL,
      2.142315,
      3,
      NULL,
      0.954410,
      27.337070,
      NULL,
      0.394277,
      0,
      NULL,
      1,
      1.486684,
      1,
      0,
      4,
      6,
      NULL,
      0.019122,
      NULL,
      NULL,
      NULL,
      131,
      0,
      2,
      0.201509,
      '21212',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


