set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7232191';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3034300',
      1.801549,
      0,
      2,
      0,
      '2110',
      2.094517,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      1,
      NULL,
      0,
      NULL,
      61,
      5.359148,
      273,
      24.633485,
      3,
      ' 2-18-2002',
      '10- 4-1996',
      ' 3-23-1980',
      NULL,
      3,
      1,
      3,
      0.267308,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377934,
      5,
      NULL,
      0,
      29.562639,
      1,
      NULL,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      0,
      7,
      NULL,
      0,
      1,
      1,
      1.879607,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1.658244,
      1.319386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      2,
      1,
      NULL,
      1,
      1,
      2,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      3,
      0,
      0,
      NULL,
      3,
      3,
      1,
      0,
      4,
      1,
      NULL,
      4,
      0,
      1,
      3,
      3,
      2,
      0,
      NULL,
      1,
      0.699999,
      NULL,
      NULL,
      ' 8-13-1980',
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      1,
      NULL,
      3.665854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      874,
      1,
      0,
      0,
      1,
      1,
      0.317760,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7,
      6,
      5.719241,
      5,
      0.249609,
      NULL,
      NULL,
      NULL,
      2,
      9,
      3.070579,
      1,
      2,
      2,
      2.234805,
      ' 6-12-1999',
      590,
      ' 7-29-1989',
      249,
      0.020612,
      0,
      NULL,
      1,
      1,
      0.556265,
      NULL,
      3,
      1.323715,
      1,
      NULL,
      NULL,
      0,
      0.300380,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.446487,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      2,
      3,
      2,
      0,
      1.299928,
      NULL,
      1.739541,
      1.418463,
      NULL,
      1.484821,
      5,
      1.814047,
      1.230950,
      1,
      NULL,
      NULL,
      NULL,
      0.717921,
      NULL,
      1,
      1.389487,
      0,
      0.816662,
      7.970139,
      3.899037,
      2,
      1,
      2.739877,
      0.183828,
      4.166653,
      NULL,
      2,
      3,
      2,
      0.076632,
      NULL,
      2,
      1,
      NULL,
      62,
      49,
      85,
      0,
      0.329044,
      3.012926,
      '10410',
      '04144',
      '',
      3,
      '43222',
      NULL,
      '',
      0.761035,
      '',
      '',
      '',
      NULL,
      1,
      148.780337,
      14,
      1,
      55,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2.897446,
      0,
      NULL,
      NULL,
      0.800609,
      NULL,
      0,
      0.265938,
      NULL,
      NULL,
      0.562312,
      NULL,
      NULL,
      2,
      1,
      0.094162,
      NULL,
      2.706689,
      1,
      NULL,
      NULL,
      NULL,
      0.722672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.792006,
      NULL,
      NULL,
      0.758629,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767639,
      2,
      1,
      1,
      NULL,
      0,
      1.360208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.576392,
      2,
      NULL,
      0.698820,
      0.227905,
      0,
      1.971335,
      0.029839,
      1.776569,
      1,
      1.109359,
      3.635176,
      0,
      NULL,
      NULL,
      1.476943,
      NULL,
      0.196168,
      NULL,
      NULL,
      2.061225,
      NULL,
      1.369524,
      NULL,
      3,
      3.069610,
      1,
      0.156697,
      NULL,
      NULL,
      NULL,
      1,
      2.649080,
      NULL,
      0.590475,
      1,
      NULL,
      NULL,
      3,
      0.055129,
      1,
      NULL,
      3.043046,
      0.817121,
      0.309669,
      NULL,
      NULL,
      NULL,
      3.574009,
      2,
      1.846422,
      NULL,
      NULL,
      1,
      0.621762,
      0,
      NULL,
      0,
      0.787933,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.196554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240093,
      NULL,
      NULL,
      1.718937,
      NULL,
      NULL,
      NULL,
      1.447656,
      0,
      2.062333,
      1.913407,
      1,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      3.030119,
      1.478803,
      0,
      3.555054,
      3.073334,
      1,
      3.583978,
      3,
      NULL,
      6,
      2.893930,
      1.141144,
      3,
      2,
      2,
      NULL,
      0,
      NULL,
      0.663875,
      3,
      0.669392,
      NULL,
      2,
      2.258320,
      0,
      NULL,
      4,
      NULL,
      0.610860,
      2,
      2.542153,
      2,
      NULL,
      1.740719,
      0.842995,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      2.823761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472326,
      NULL,
      NULL,
      2.486596,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.780584,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350177,
      NULL,
      NULL,
      1.824143,
      2,
      3.797286,
      0,
      3.666579,
      1.137863,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      544.495720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.557713,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.570676,
      NULL,
      NULL,
      NULL,
      3.723880,
      NULL,
      NULL,
      NULL,
      3.245871,
      NULL,
      NULL,
      NULL,
      0.991803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551998,
      NULL,
      NULL,
      NULL,
      2.124050,
      NULL,
      NULL,
      NULL,
      1.845906,
      NULL,
      NULL,
      NULL,
      3.527704,
      NULL,
      NULL,
      NULL,
      0.424525,
      NULL,
      NULL,
      NULL,
      2.825845,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2,
      2.231021,
      2.363778,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.362417,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      363.843150,
      42,
      0.313523,
      NULL,
      0.343937,
      0.614399,
      1,
      1,
      1.769340,
      NULL,
      1.705641,
      NULL,
      1.514997,
      NULL,
      1,
      0.604187,
      0,
      NULL,
      NULL,
      1.417350,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.409811,
      NULL,
      2.833194,
      NULL,
      32,
      NULL,
      3.139712,
      24,
      61.469863,
      2.124402,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658677,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.454617,
      NULL,
      0.199220,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.000216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.088633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626329,
      3.313967,
      NULL,
      0.945834,
      NULL,
      1.410399,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.257668,
      NULL,
      NULL,
      1.180186,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      0.308847,
      2.905557,
      NULL,
      1,
      5,
      3.581397,
      3,
      0,
      0.239439,
      1.168851,
      NULL,
      1.805667,
      1,
      NULL,
      2,
      1.367073,
      NULL,
      0,
      1.502325,
      NULL,
      3,
      1,
      NULL,
      2.798691,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.027210,
      NULL,
      NULL,
      0.381637,
      NULL,
      NULL,
      0.883547,
      3.781028,
      NULL,
      0.844606,
      0,
      NULL,
      0,
      0.678419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314867,
      1.856320,
      NULL,
      1.052980,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.390504,
      NULL,
      3.798219,
      NULL,
      1,
      NULL,
      1.856131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794814,
      NULL,
      22.006749,
      0.578585,
      NULL,
      0.556276,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      2.962664,
      24.289252,
      19.222088,
      NULL,
      1.669970,
      NULL,
      '20334',
      '00333',
      NULL,
      1,
      '32114',
      '',
      '',
      1.623213,
      '',
      '',
      '');
commit;
end;
/


