set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7232191';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      NULL,
      5.406391,
      40,
      NULL,
      5,
      1.161051,
      0,
      NULL,
      '3104',
      0,
      0.061258,
      NULL,
      NULL,
      ' 5-13-1980',
      54,
      119.808347,
      NULL,
      3.391119,
      NULL,
      '10-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 7- 9-1974',
      ' 0-18-1982',
      '11-20-1992',
      1.014738,
      2.442974,
      NULL,
      1,
      3.585538,
      NULL,
      3,
      0,
      NULL,
      7,
      NULL,
      8.267749,
      2.313721,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      1,
      1,
      1,
      1,
      0,
      NULL,
      5,
      1,
      0,
      0,
      1,
      0,
      7.072993,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.724523,
      NULL,
      NULL,
      NULL,
      1,
      1.921926,
      1.310895,
      1,
      NULL,
      1.287211,
      2.582039,
      0.943770,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.734304,
      2,
      3.916422,
      1,
      1,
      NULL,
      0,
      5.430352,
      1,
      1,
      0,
      0.056613,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      1,
      5,
      5,
      1,
      NULL,
      1,
      1,
      0,
      0,
      3.010710,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      5,
      0,
      0,
      4,
      4,
      5,
      NULL,
      1,
      0,
      0,
      NULL,
      2.880652,
      ' 3- 4-1997',
      1254,
      ' 7- 1-1977',
      421,
      3,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      1,
      1,
      NULL,
      1.181552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983614,
      0,
      1.708320,
      1.696737,
      0.647440,
      2.589322,
      1.321509,
      NULL,
      0,
      NULL,
      1.012768,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476112,
      1.819224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063473,
      0.313068,
      0,
      NULL,
      0,
      1.542110,
      NULL,
      2,
      102.659751,
      1.748970,
      0.716807,
      NULL,
      NULL,
      NULL,
      2,
      0.212488,
      NULL,
      0,
      1,
      0,
      2,
      3,
      0,
      3,
      NULL,
      3,
      NULL,
      3,
      1.828219,
      2,
      NULL,
      0.825706,
      1.372680,
      2.771027,
      0.438552,
      0.822318,
      0,
      NULL,
      1,
      1.994273,
      1.052251,
      0.495612,
      NULL,
      1.666382,
      3,
      0,
      9.193012,
      8,
      6,
      10.497108,
      11.914048,
      7.057529,
      NULL,
      2,
      7,
      0,
      1,
      0,
      53,
      2,
      1,
      27,
      NULL,
      19,
      0,
      2,
      NULL,
      0,
      '34030',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.221480,
      NULL,
      '',
      '',
      2.734326,
      47.208705,
      NULL,
      NULL,
      2,
      51,
      4,
      8.153379,
      0,
      2.440193,
      0,
      1.963013,
      0,
      NULL,
      NULL,
      1.219621,
      3.931909,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712739,
      3.553755,
      2,
      3.017465,
      0.422800,
      NULL,
      NULL,
      1.967299,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.081458,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      1.463961,
      0,
      NULL,
      1.131078,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.041558,
      1,
      2,
      0.403368,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.244419,
      1,
      NULL,
      NULL,
      3,
      2.885110,
      NULL,
      1.125648,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.600263,
      9.598335,
      NULL,
      3.976792,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.695484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.712074,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.749991,
      NULL,
      3,
      2,
      5.204498,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243686,
      NULL,
      NULL,
      0.855779,
      NULL,
      NULL,
      0.457147,
      NULL,
      NULL,
      NULL,
      0.143172,
      0.997528,
      5,
      NULL,
      1.164842,
      5.906953,
      1.307231,
      1.693535,
      2.570680,
      NULL,
      NULL,
      NULL,
      1.696407,
      1,
      1,
      2,
      0,
      1.389338,
      1,
      1.255542,
      3,
      1.279665,
      3,
      0,
      2.060454,
      0.723106,
      NULL,
      1,
      NULL,
      0.584164,
      3.578594,
      NULL,
      0,
      NULL,
      3.241720,
      0.721503,
      1,
      0.142795,
      NULL,
      4.057826,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.809013,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.798697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953688,
      NULL,
      NULL,
      3.536088,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.702458,
      1,
      2.110744,
      NULL,
      NULL,
      1,
      1.246223,
      NULL,
      6.866909,
      NULL,
      NULL,
      NULL,
      123,
      492,
      NULL,
      NULL,
      2.733032,
      0,
      NULL,
      NULL,
      1.964613,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.565828,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.326895,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.254784,
      NULL,
      NULL,
      NULL,
      3,
      0.248225,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2.507801,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.503657,
      0.404250,
      NULL,
      NULL,
      13.778019,
      5.850638,
      NULL,
      NULL,
      3.558738,
      0,
      NULL,
      2,
      1,
      0.912594,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588334,
      7.855992,
      2,
      0.497823,
      NULL,
      NULL,
      1.908190,
      NULL,
      1,
      NULL,
      30,
      0.783030,
      NULL,
      0,
      1.086124,
      1,
      1,
      0,
      0,
      1.035047,
      NULL,
      0.085481,
      NULL,
      0.878394,
      1.672949,
      1.995212,
      1.879185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.957742,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.114202,
      3,
      1.029036,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.673490,
      NULL,
      1,
      NULL,
      1.090889,
      NULL,
      NULL,
      NULL,
      1.506932,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.748606,
      NULL,
      NULL,
      0.674779,
      0.918361,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350234,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.090642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.565333,
      NULL,
      1.031116,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452425,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2.903314,
      3,
      NULL,
      2,
      6,
      3.471095,
      2.877546,
      0,
      0.186405,
      1,
      NULL,
      0.254296,
      0.704639,
      NULL,
      1,
      1.521458,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.089993,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.494630,
      NULL,
      3.919622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.782787,
      0,
      NULL,
      3.287734,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.584726,
      3,
      NULL,
      0.972810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487178,
      NULL,
      3.145184,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.007611,
      NULL,
      11,
      NULL,
      NULL,
      0,
      NULL,
      3.693357,
      NULL,
      0.146347,
      NULL,
      3,
      4,
      7,
      0.230254,
      1.471119,
      2,
      48.101514,
      71,
      3,
      2.232299,
      NULL,
      '13103',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.837328,
      '',
      '',
      '');
commit;
end;
/


