set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '40',
      13,
      NULL,
      '0123423',
      3.708863,
      0,
      1,
      3,
      NULL,
      NULL,
      1.956506,
      NULL,
      NULL,
      ' 9-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      2.824913,
      ' 6- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3- 2-1984',
      ' 9-27-1976',
      NULL,
      1.931248,
      NULL,
      NULL,
      2,
      1,
      2.908835,
      2,
      1,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.574001,
      1.225404,
      NULL,
      0,
      5,
      1,
      0,
      1,
      3,
      2,
      0,
      2.446068,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      1,
      3,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      1.372931,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      4,
      NULL,
      5,
      0,
      0,
      0,
      0,
      0,
      0,
      4,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      1,
      5,
      5,
      5,
      1,
      2,
      4,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      5,
      1,
      1,
      2,
      NULL,
      2,
      4,
      NULL,
      2.834939,
      ' 0-14-2001',
      901.666721,
      ' 7-11-2000',
      NULL,
      2.867626,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      0.434135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318301,
      6.786759,
      1.382473,
      1.921517,
      NULL,
      1.041321,
      NULL,
      NULL,
      NULL,
      1.371180,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.468277,
      NULL,
      3.403316,
      0.203189,
      0,
      NULL,
      1,
      7,
      2.961458,
      1.203697,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.447144,
      0,
      3,
      3,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      1.385192,
      0,
      0,
      1.627075,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0.808602,
      1,
      1,
      0,
      NULL,
      1.247911,
      NULL,
      5.312082,
      5.233033,
      1.467617,
      0.018544,
      1,
      NULL,
      2,
      6.686242,
      NULL,
      0.390590,
      0,
      38.007120,
      2,
      1,
      NULL,
      NULL,
      22,
      20,
      1,
      3.483335,
      2,
      '40413',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.696095,
      29,
      356.955480,
      26,
      3.594201,
      54.811421,
      3.473997,
      NULL,
      NULL,
      1,
      1.205191,
      2,
      1.373332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.647784,
      NULL,
      NULL,
      2.432534,
      1.459764,
      3,
      1,
      NULL,
      NULL,
      0.879106,
      NULL,
      NULL,
      1.468778,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.071896,
      0,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597594,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.368473,
      1.486550,
      NULL,
      1,
      1.583324,
      NULL,
      NULL,
      3.362228,
      2,
      NULL,
      0.655815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.830432,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.074937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327173,
      NULL,
      NULL,
      1.646775,
      NULL,
      NULL,
      0,
      2,
      0.816648,
      2,
      NULL,
      2.837701,
      1,
      NULL,
      5.760882,
      6.741438,
      3.732172,
      1,
      1,
      NULL,
      NULL,
      0.185382,
      NULL,
      NULL,
      NULL,
      1,
      1.854720,
      NULL,
      2,
      0,
      3.669058,
      5,
      4.910945,
      3,
      0.680372,
      1,
      1.272916,
      1.147631,
      2.050050,
      3,
      0.094332,
      1,
      0,
      3,
      3,
      5,
      3,
      5.598898,
      0.152465,
      2,
      1.878033,
      NULL,
      4,
      1,
      1,
      0.413387,
      0,
      1.499044,
      0.738912,
      3.107598,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.999814,
      NULL,
      NULL,
      0.907815,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.995095,
      1.363610,
      1.681942,
      0.202861,
      0.614026,
      3,
      1.034162,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3.703461,
      3.359553,
      NULL,
      NULL,
      2.442964,
      3.056825,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.208297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.258939,
      NULL,
      NULL,
      1.306444,
      1.248730,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.090931,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.460142,
      0.305198,
      NULL,
      NULL,
      2.928157,
      4.272315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.642787,
      0.916994,
      0,
      1.179315,
      NULL,
      NULL,
      0.679613,
      1.645264,
      1,
      1,
      NULL,
      NULL,
      1.603221,
      NULL,
      NULL,
      0.062810,
      NULL,
      0,
      459,
      0.710564,
      0,
      0.889850,
      1,
      1.166492,
      0.147326,
      1,
      NULL,
      0,
      0.933156,
      NULL,
      1,
      1,
      1,
      0.823128,
      1,
      0,
      1,
      0.555221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.268498,
      1,
      NULL,
      3,
      0.779123,
      0.168244,
      0,
      1.997320,
      0.753182,
      1,
      NULL,
      1.022152,
      NULL,
      0.947377,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      2.385095,
      0.653313,
      3,
      2.338547,
      NULL,
      2,
      1.216471,
      2,
      0.329960,
      0,
      0.883173,
      0,
      1.102416,
      2.771213,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.807260,
      1.329881,
      0,
      NULL,
      1,
      0,
      1,
      6,
      3.009373,
      0,
      3.617834,
      NULL,
      NULL,
      2,
      4.720083,
      NULL,
      '23200',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


