set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636027';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      NULL,
      20.800412,
      39,
      '3421404',
      3,
      NULL,
      2,
      1,
      '2210',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2.452459,
      NULL,
      ' 9- 6-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 9- 3-1992',
      NULL,
      1.870183,
      3,
      1,
      0,
      0,
      2,
      4,
      0.460074,
      NULL,
      NULL,
      NULL,
      18.451885,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      3,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1.974334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.191657,
      0.555291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0.073943,
      NULL,
      1.956436,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      3,
      0,
      1,
      1,
      1,
      NULL,
      0,
      3,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1.772169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764085,
      0,
      NULL,
      1.382962,
      0.672555,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.569755,
      0,
      0.855028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.392061,
      0,
      1.585462,
      0,
      1.053643,
      1.722585,
      NULL,
      2.983543,
      1.899713,
      1.383223,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      3,
      NULL,
      3,
      3,
      2,
      3,
      2,
      0,
      2,
      3.071764,
      0,
      0.053125,
      1,
      1.854562,
      2.169947,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1.753943,
      0.091815,
      NULL,
      1.188131,
      3.329786,
      1.953009,
      11,
      8,
      6,
      10.154703,
      4,
      2,
      NULL,
      0.007538,
      7,
      3.284238,
      3,
      2.863902,
      46,
      3,
      0,
      NULL,
      NULL,
      88,
      52,
      5,
      2.001104,
      1.855822,
      '31031',
      '',
      '',
      1,
      '',
      '',
      '',
      0.272785,
      '44232',
      '2134',
      '',
      0.899086,
      20.917399,
      287,
      96,
      3,
      60.102737,
      NULL,
      10.537740,
      0,
      3.095339,
      0,
      1.172714,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.282702,
      1.948833,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.654960,
      0,
      3.335928,
      0.179588,
      1,
      3,
      1.244824,
      1,
      2.447302,
      NULL,
      0,
      NULL,
      1.513969,
      1,
      2.097597,
      1,
      NULL,
      9,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.110912,
      1,
      0.818405,
      1,
      NULL,
      NULL,
      1.487159,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      0.339697,
      0.735118,
      0,
      1.842428,
      1,
      0,
      1,
      1,
      0,
      3.969761,
      0.120616,
      NULL,
      NULL,
      1.303634,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.899032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.698319,
      2.686694,
      1.919192,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.554456,
      3.004621,
      1,
      1.189279,
      2.348776,
      1.645126,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.899973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.888009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891652,
      NULL,
      NULL,
      3.492174,
      NULL,
      0.904495,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.208396,
      3.859938,
      NULL,
      NULL,
      1,
      0,
      0.143067,
      1,
      NULL,
      3.091228,
      2,
      0.399845,
      0.181971,
      0,
      2,
      2.285650,
      0,
      NULL,
      0.323063,
      NULL,
      2.466771,
      0,
      7.357263,
      1.397359,
      3,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      0.590351,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.225532,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      2,
      1.047256,
      1.984156,
      0.100658,
      1.608113,
      1.030960,
      NULL,
      NULL,
      NULL,
      6.681035,
      0.366776,
      NULL,
      NULL,
      8.775410,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.655776,
      NULL,
      NULL,
      NULL,
      0.610977,
      NULL,
      NULL,
      NULL,
      3,
      1.251462,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.559047,
      0,
      NULL,
      NULL,
      1.080698,
      1.577843,
      NULL,
      NULL,
      6.919712,
      1,
      NULL,
      NULL,
      2,
      2.109170,
      3,
      1,
      3,
      176,
      NULL,
      2,
      6,
      1278.385899,
      0.078098,
      NULL,
      NULL,
      0.946919,
      NULL,
      NULL,
      0.004641,
      0.006849,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      750.389198,
      183347,
      NULL,
      0.768986,
      1.014738,
      0,
      0,
      0,
      1.041398,
      NULL,
      1,
      0.140554,
      NULL,
      3,
      1.034283,
      2,
      1,
      1.416405,
      1,
      3,
      NULL,
      1.013588,
      NULL,
      0.814049,
      NULL,
      0.763636,
      NULL,
      3.407740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      37.311211,
      2.221352,
      2.430859,
      NULL,
      NULL,
      2.919039,
      NULL,
      NULL,
      NULL,
      1.025703,
      NULL,
      0.777491,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.113078,
      NULL,
      NULL,
      NULL,
      0.180056,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2.364550,
      1.791872,
      0.572711,
      0.609205,
      0.096979,
      3.057194,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1.171765,
      0.284769,
      NULL,
      0,
      1,
      3,
      0.568410,
      1,
      NULL,
      1,
      1.082398,
      1.615269,
      0.084147,
      1.303544,
      1,
      NULL,
      0.350602,
      NULL,
      NULL,
      3,
      1.053253,
      1.762672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.793276,
      NULL,
      NULL,
      1.585234,
      NULL,
      0.506108,
      NULL,
      0.333165,
      NULL,
      1.383949,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.649973,
      NULL,
      0.254745,
      NULL,
      0.094907,
      NULL,
      1.236211,
      NULL,
      0.327140,
      NULL,
      1.803348,
      NULL,
      64.015888,
      NULL,
      10.082132,
      1.189523,
      NULL,
      1.993872,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      26,
      34,
      3,
      1,
      1.694616,
      '40400',
      '14103',
      '',
      1,
      '',
      NULL,
      '',
      0.523162,
      '30243',
      '1242',
      '');
commit;
end;
/


