set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      0,
      0.531748,
      1,
      NULL,
      NULL,
      NULL,
      0.093391,
      NULL,
      NULL,
      ' 4- 7-1978',
      NULL,
      NULL,
      5,
      2.862418,
      5.885904,
      ' 2-26-1977',
      NULL,
      0,
      30.212937,
      80,
      1,
      ' 7-26-1984',
      '10-21-1991',
      '10- 5-1979',
      2,
      0.922647,
      NULL,
      2,
      0,
      2.373247,
      1,
      1,
      0.714510,
      NULL,
      1,
      NULL,
      4.851940,
      4,
      10,
      NULL,
      6,
      2,
      0,
      8.173534,
      1,
      0,
      0,
      0,
      0.361936,
      0,
      1,
      NULL,
      0.488181,
      3.650049,
      1,
      2,
      0,
      5,
      3.569973,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      2,
      4,
      5,
      NULL,
      3,
      1,
      3.128809,
      0,
      0,
      NULL,
      1,
      0.965826,
      NULL,
      NULL,
      0.252717,
      NULL,
      NULL,
      NULL,
      0,
      0.815060,
      1,
      1.540936,
      3.608769,
      1.272543,
      0.855535,
      0.654995,
      0.128624,
      0,
      1,
      1,
      0,
      0.970292,
      0,
      2.347046,
      0,
      1,
      0,
      1,
      NULL,
      5.099438,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.330550,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1.081918,
      NULL,
      4,
      NULL,
      2,
      0,
      4,
      0,
      0,
      3,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      4,
      4,
      2,
      2,
      2,
      2,
      5,
      0,
      1,
      2,
      4,
      0.287008,
      ' 6-22-1999',
      50.455724,
      ' 7-23-1998',
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      4,
      4,
      0.121294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.624341,
      NULL,
      1.601758,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.238779,
      0,
      3.970414,
      5,
      2,
      1.933278,
      2,
      NULL,
      1,
      4.936448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      0.800534,
      NULL,
      NULL,
      9.631436,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.591074,
      2,
      2,
      0,
      3,
      1,
      2,
      1,
      1,
      0,
      0,
      2,
      3,
      3.614667,
      2.419937,
      1.184625,
      1.644261,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      11,
      5,
      1.662598,
      8,
      NULL,
      5,
      0.218567,
      4,
      0,
      2.293501,
      2.227468,
      NULL,
      1,
      NULL,
      NULL,
      32,
      0,
      2,
      NULL,
      55,
      43,
      22,
      4,
      4,
      5,
      '23400',
      '13003',
      '43144',
      3.382180,
      '1141',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      27,
      NULL,
      13.063993,
      0.575745,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.154107,
      1,
      0.842426,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.352523,
      3,
      NULL,
      NULL,
      NULL,
      0.689490,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.776012,
      2.073635,
      1,
      NULL,
      NULL,
      1.978895,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.213991,
      NULL,
      NULL,
      0.216537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416772,
      NULL,
      NULL,
      2,
      3,
      3.965177,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.710415,
      NULL,
      5.935673,
      2.381241,
      NULL,
      NULL,
      3.567893,
      0,
      2.426890,
      3.874979,
      3,
      1,
      1.029837,
      NULL,
      NULL,
      1.628944,
      NULL,
      NULL,
      1.179579,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.342132,
      2,
      NULL,
      1.195200,
      4,
      4.328723,
      2.352830,
      5,
      NULL,
      0.049610,
      NULL,
      NULL,
      2.574983,
      1,
      0.883424,
      1,
      NULL,
      3.432600,
      0,
      1,
      1.375818,
      9.124390,
      0.202415,
      1,
      1.481633,
      NULL,
      0.756021,
      0.600596,
      2,
      2,
      3,
      1.178028,
      1,
      1,
      1.577512,
      2,
      5.098278,
      NULL,
      6.973936,
      1,
      3,
      0,
      1.954149,
      NULL,
      NULL,
      0,
      1.485207,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089298,
      1.683176,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      1,
      0,
      2,
      0.422454,
      1.033737,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.476591,
      NULL,
      NULL,
      1.119150,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349151,
      67,
      5,
      0.055678,
      0.698523,
      0.700381,
      1.059905,
      0,
      0,
      NULL,
      1.687851,
      NULL,
      1.171589,
      0,
      0.757825,
      1.998675,
      0.168522,
      NULL,
      0,
      1.754068,
      0.999825,
      NULL,
      0.051499,
      NULL,
      1.034424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      17.646956,
      1.218096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868871,
      NULL,
      0.529113,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.515519,
      NULL,
      1.583855,
      NULL,
      1.524092,
      NULL,
      0.818407,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319696,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.008454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.215209,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.933343,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.546124,
      0.545348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.586380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323859,
      3,
      NULL,
      2,
      NULL,
      1.274537,
      NULL,
      59,
      NULL,
      3.032037,
      NULL,
      1,
      NULL,
      0.140072,
      NULL,
      2.635541,
      NULL,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      2.874191,
      0,
      0,
      3,
      NULL,
      0.314054,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.136855,
      NULL,
      0.907901,
      2.129879,
      NULL,
      0.693274,
      3.798696,
      NULL,
      2,
      1.093480,
      NULL,
      2.651284,
      3,
      NULL,
      0,
      3.314126,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280034,
      NULL,
      1.960714,
      NULL,
      0,
      NULL,
      1,
      3,
      3,
      1.854743,
      0,
      NULL,
      54,
      17,
      1,
      0,
      2.435401,
      '41314',
      NULL,
      '40102',
      1.956524,
      '1241',
      '',
      NULL,
      1.560308,
      '',
      '',
      '');
commit;
end;
/


