set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7626303';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0234420',
      1,
      0.384190,
      2,
      3,
      NULL,
      0,
      3,
      0,
      16,
      ' 3- 7-1981',
      40.795297,
      NULL,
      3,
      2.613783,
      0.457863,
      NULL,
      84,
      5.555400,
      NULL,
      87.524778,
      3,
      NULL,
      NULL,
      ' 7-13-1979',
      1.539257,
      0.431176,
      1.545335,
      NULL,
      1,
      0.128280,
      NULL,
      0,
      1.235481,
      NULL,
      NULL,
      19,
      1.086143,
      18,
      33.540915,
      NULL,
      16.103085,
      4,
      0,
      5.106362,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0.455708,
      0.318881,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3,
      1,
      0,
      2,
      1,
      1,
      0,
      0,
      1,
      1,
      3,
      2,
      5,
      0,
      0,
      0,
      1,
      1.552418,
      NULL,
      NULL,
      0.499209,
      NULL,
      NULL,
      NULL,
      0,
      0.559524,
      2.843988,
      0.875725,
      0,
      NULL,
      NULL,
      NULL,
      1.635881,
      1.778947,
      0.663044,
      1,
      NULL,
      NULL,
      0,
      2.079713,
      0.643944,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.218973,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      5.869532,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.483577,
      NULL,
      0,
      1,
      1,
      0,
      2,
      1,
      5,
      2,
      5,
      1,
      1,
      NULL,
      0,
      0,
      2,
      2,
      1,
      3,
      3,
      4,
      3,
      4,
      NULL,
      2,
      1.683304,
      2.192820,
      ' 6-10-1982',
      484,
      NULL,
      910.067582,
      3,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.007736,
      0,
      3.621311,
      0,
      1.389417,
      0.371901,
      0.595712,
      2,
      2.478539,
      3.943754,
      0.443439,
      0,
      NULL,
      NULL,
      NULL,
      1.000896,
      3,
      1.511942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.667482,
      1.166127,
      0,
      0.857892,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      1.614738,
      1.253327,
      1,
      0,
      NULL,
      NULL,
      1.376395,
      1,
      0.050018,
      1.144808,
      0.917624,
      0,
      0.159989,
      NULL,
      1,
      0.029243,
      3,
      1.653819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      44,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      '02432',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      3,
      22,
      101.685093,
      36,
      0.054285,
      28.030295,
      3,
      971,
      0,
      3,
      2,
      1,
      1.529914,
      2,
      0.290747,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853862,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.953140,
      3.405260,
      3,
      2.573461,
      3,
      0.484209,
      1.500636,
      NULL,
      0,
      0,
      1.718501,
      0,
      1.437661,
      NULL,
      0,
      NULL,
      0.180587,
      0,
      1,
      NULL,
      3.567461,
      6,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.053779,
      0.963822,
      0.366395,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139758,
      1.907309,
      NULL,
      0,
      2,
      0.249569,
      1.946982,
      3.576543,
      1.997519,
      0,
      0.498052,
      NULL,
      NULL,
      NULL,
      0.655669,
      0,
      1.845962,
      NULL,
      NULL,
      2.530246,
      NULL,
      NULL,
      0.794603,
      1.162151,
      1.207367,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.763066,
      NULL,
      3.477403,
      3.257179,
      1.460181,
      NULL,
      NULL,
      0,
      7.969884,
      NULL,
      0,
      NULL,
      0.986781,
      0,
      NULL,
      NULL,
      6.105665,
      NULL,
      0.869662,
      1.318038,
      NULL,
      3.963284,
      3.882896,
      3.305102,
      3.466288,
      5.686028,
      2.639573,
      7.107435,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501354,
      NULL,
      NULL,
      1.508263,
      NULL,
      NULL,
      1.373741,
      NULL,
      NULL,
      0.502539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017215,
      NULL,
      NULL,
      6.513517,
      6.100385,
      4.510335,
      7.435345,
      2.007378,
      1,
      1,
      0.991561,
      0.386222,
      3,
      0,
      1.786636,
      0.877983,
      1,
      1.474114,
      3.663621,
      3,
      0,
      9.162637,
      8,
      NULL,
      3.711218,
      NULL,
      0.927448,
      2,
      3,
      1,
      NULL,
      0.811660,
      3,
      1,
      1,
      3.577113,
      NULL,
      6.812969,
      1.515233,
      3,
      1.659166,
      5.075591,
      2.903594,
      NULL,
      4,
      NULL,
      1.827950,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.186755,
      NULL,
      NULL,
      1125.323739,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.942035,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.038227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.444412,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.339986,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.299222,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2.104177,
      NULL,
      NULL,
      NULL,
      2,
      2.977296,
      NULL,
      NULL,
      NULL,
      1053.613115,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338992,
      NULL,
      NULL,
      3,
      1.733247,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.630467,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.139640,
      1,
      NULL,
      NULL,
      0,
      0.611645,
      NULL,
      NULL,
      3.250653,
      1.617200,
      NULL,
      NULL,
      0.681416,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643147,
      NULL,
      NULL,
      3.742559,
      3.838426,
      NULL,
      NULL,
      1.316350,
      1.912025,
      NULL,
      NULL,
      2,
      7.199154,
      NULL,
      NULL,
      40.561676,
      NULL,
      5.382587,
      1,
      1,
      1,
      71,
      117.728468,
      2.855760,
      487.278124,
      1494,
      0,
      NULL,
      NULL,
      0.422997,
      NULL,
      1452.652467,
      0,
      675.271678,
      1507.678584,
      1,
      NULL,
      NULL,
      1,
      12,
      NULL,
      14599.032587,
      44.394880,
      1,
      0.868919,
      0.146481,
      0,
      1,
      1,
      0.833665,
      0.120405,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.116741,
      1.948946,
      0,
      NULL,
      3,
      NULL,
      0.060726,
      NULL,
      0,
      NULL,
      0.766883,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.285172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      11.516016,
      3.749951,
      NULL,
      1,
      NULL,
      6.237099,
      NULL,
      1.874661,
      NULL,
      0.599998,
      0,
      NULL,
      0,
      0.453941,
      NULL,
      3,
      2.997033,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.532373,
      NULL,
      NULL,
      1,
      2.577146,
      NULL,
      1.587103,
      0,
      NULL,
      1.198230,
      3,
      NULL,
      NULL,
      2,
      NULL,
      1.598097,
      1.628938,
      NULL,
      3,
      0.927476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234078,
      NULL,
      1.068355,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      29.099081,
      44.215650,
      5,
      NULL,
      NULL,
      '34100',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


