set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '4240144',
      3.575604,
      0,
      3,
      NULL,
      NULL,
      2,
      1.247477,
      NULL,
      NULL,
      ' 5- 6-1995',
      NULL,
      NULL,
      NULL,
      2,
      1.240404,
      '10- 0-1982',
      31,
      NULL,
      352.953611,
      102,
      4,
      NULL,
      NULL,
      ' 0-25-1982',
      1,
      1,
      1.967425,
      2.038258,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      7,
      0.882054,
      NULL,
      11,
      NULL,
      12.694986,
      0,
      1,
      NULL,
      0.979551,
      NULL,
      NULL,
      0.512083,
      1.073521,
      1,
      NULL,
      0,
      1.762436,
      1,
      1.023665,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.984595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0.233568,
      NULL,
      1,
      0,
      1,
      1.297055,
      NULL,
      NULL,
      2,
      3,
      0,
      0,
      NULL,
      2,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      0,
      3,
      1,
      4,
      2,
      1,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      4,
      0.632301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.005054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527882,
      0.761801,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0.071972,
      2.277357,
      1.837022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.685605,
      0.306903,
      0,
      0.629467,
      1.028575,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      2,
      2,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      0,
      0,
      3,
      2,
      1,
      1,
      3.903087,
      1,
      0,
      1,
      1.658713,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0.684681,
      1.170224,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983771,
      26,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.789601,
      '30012',
      '',
      '',
      0.120649,
      '',
      '',
      NULL,
      0.109166,
      '',
      '',
      '',
      1.001742,
      NULL,
      22,
      NULL,
      2.947536,
      16,
      3.910322,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      1.348781,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0.024611,
      NULL,
      NULL,
      3.543210,
      NULL,
      NULL,
      0.148308,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.779168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.868707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.766341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710689,
      NULL,
      NULL,
      0.285150,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.368910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711611,
      NULL,
      NULL,
      2,
      1.401839,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.865585,
      3.190848,
      1.388210,
      0.132135,
      3.454780,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398560,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.629004,
      2.063369,
      1,
      0,
      NULL,
      NULL,
      NULL,
      8.790384,
      9,
      2.520699,
      4.198817,
      NULL,
      6.561970,
      NULL,
      5.205075,
      1.022597,
      NULL,
      NULL,
      0,
      0.182334,
      1.464947,
      0.495088,
      1,
      0,
      NULL,
      NULL,
      2.578498,
      0,
      0.949611,
      0.021340,
      19.861838,
      NULL,
      NULL,
      0.765967,
      3.307905,
      NULL,
      NULL,
      2.428599,
      0.149768,
      3.910618,
      7.523401,
      NULL,
      2,
      NULL,
      4,
      1.309320,
      4,
      1,
      0.516312,
      0.341665,
      NULL,
      NULL,
      0.526364,
      2.555128,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.674363,
      NULL,
      NULL,
      0.591495,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.773133,
      0,
      1,
      1,
      0,
      3.041988,
      NULL,
      NULL,
      NULL,
      NULL,
      0.786096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.135712,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.114117,
      10.845828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766693,
      1,
      NULL,
      NULL,
      1.147960,
      NULL,
      NULL,
      NULL,
      3.973527,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.833601,
      3.106691,
      NULL,
      NULL,
      3,
      2.008853,
      NULL,
      NULL,
      0.858159,
      0.801940,
      NULL,
      NULL,
      2,
      7.700004,
      NULL,
      NULL,
      0.374352,
      NULL,
      NULL,
      NULL,
      3.563318,
      6.092852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719109,
      NULL,
      NULL,
      1.810138,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.061514,
      NULL,
      NULL,
      NULL,
      0.272618,
      0,
      0,
      NULL,
      1.627013,
      0.908132,
      0,
      1.529695,
      NULL,
      0.381062,
      0.025467,
      1.357751,
      1.461972,
      1,
      1,
      NULL,
      0,
      NULL,
      1.229528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.526045,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.946187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973584,
      1.566449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.587870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.359214,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1.069377,
      1.781106,
      1,
      2,
      NULL,
      4.756840,
      0.700328,
      2.867027,
      0,
      1.728609,
      NULL,
      0,
      0,
      1.919636,
      0,
      0,
      NULL,
      0,
      NULL,
      0.090348,
      1.026238,
      0.575785,
      1.607073,
      NULL,
      1.367176,
      NULL,
      2,
      NULL,
      3,
      3,
      0,
      0.766973,
      0,
      1.152484,
      3,
      3.004841,
      1.171642,
      NULL,
      2,
      1.622180,
      NULL,
      1.496852,
      NULL,
      1.050169,
      1.494170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.958339,
      0.549823,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      27.939727,
      162.837494,
      5,
      0,
      2.137120,
      '13213',
      '',
      '',
      0.461930,
      '',
      '',
      '',
      0.346949,
      NULL,
      '',
      '');
commit;
end;
/


