set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0222131',
      NULL,
      1,
      5,
      0,
      '3142',
      0.413754,
      1.058641,
      NULL,
      NULL,
      ' 8- 9-1984',
      15,
      NULL,
      NULL,
      0.336595,
      NULL,
      ' 4-21-1993',
      33,
      3,
      192,
      60,
      4,
      NULL,
      NULL,
      ' 7-15-1999',
      1,
      1.079542,
      1,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      11.773007,
      3,
      13,
      NULL,
      0,
      16.613894,
      5,
      0,
      4.821486,
      0.456778,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0.923656,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0.508629,
      NULL,
      5,
      1,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      5,
      NULL,
      4,
      5,
      5,
      3,
      1,
      4,
      1,
      1,
      3,
      NULL,
      0.759996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1.055244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.191786,
      1.419853,
      1.424993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.126843,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.661019,
      1.121410,
      0,
      1.053165,
      1.098885,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978056,
      2,
      1,
      1,
      1,
      3,
      2,
      0,
      2,
      1,
      3,
      NULL,
      2.147221,
      1,
      0.716560,
      1,
      1,
      NULL,
      0.434334,
      0,
      0,
      1,
      0.535581,
      NULL,
      0,
      1.596294,
      1,
      1,
      2.371812,
      5,
      NULL,
      11.480280,
      3,
      NULL,
      9,
      3.144536,
      0,
      5,
      NULL,
      2.478163,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      '14141',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.197436,
      '',
      NULL,
      '',
      0,
      30.654437,
      19,
      32,
      1.951157,
      33.696074,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.614190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843114,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.955724,
      NULL,
      NULL,
      0.060961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928539,
      NULL,
      NULL,
      3.638830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998345,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.687391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360763,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      6,
      NULL,
      1,
      0.115283,
      1.860150,
      0.705428,
      NULL,
      NULL,
      NULL,
      2.018779,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.396542,
      NULL,
      NULL,
      0.404207,
      NULL,
      NULL,
      1.613293,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.848491,
      3.818764,
      1,
      2,
      1,
      NULL,
      3.380706,
      1,
      5.884813,
      0.791783,
      3.191418,
      3.632821,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.345323,
      0,
      3,
      2.924151,
      0.388777,
      NULL,
      0,
      NULL,
      5.646180,
      1,
      2.590785,
      NULL,
      1.285415,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.069068,
      NULL,
      4.389174,
      5.956324,
      0.116952,
      3.437103,
      1.233759,
      0,
      NULL,
      4,
      1,
      0,
      0.494551,
      1.010936,
      1,
      NULL,
      0.755812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.007272,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.977180,
      NULL,
      NULL,
      3.712429,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874187,
      NULL,
      0.217940,
      NULL,
      0.593566,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.043127,
      NULL,
      NULL,
      NULL,
      2.478789,
      NULL,
      NULL,
      NULL,
      0.211790,
      1.500955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.366095,
      1,
      NULL,
      NULL,
      2,
      1.781644,
      NULL,
      NULL,
      2,
      0.144104,
      NULL,
      NULL,
      2,
      3.314101,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580522,
      NULL,
      NULL,
      8.778610,
      NULL,
      NULL,
      NULL,
      0.619659,
      NULL,
      NULL,
      NULL,
      0,
      8,
      3.034596,
      0.932884,
      3.788275,
      2.267819,
      1.160710,
      NULL,
      NULL,
      0.497231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      29,
      0,
      NULL,
      0.489839,
      1,
      0.949889,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.021650,
      1,
      0,
      1.361721,
      0.335455,
      0.579864,
      NULL,
      1.656682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.130512,
      0.274309,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798550,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391243,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550659,
      NULL,
      2.350527,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.239745,
      NULL,
      0,
      0.530050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1.580308,
      0,
      1.591859,
      1,
      0,
      7,
      2.798498,
      3,
      2,
      0,
      NULL,
      1.228072,
      0.949792,
      1.922743,
      0.229327,
      NULL,
      0,
      0,
      0.365661,
      1,
      NULL,
      1,
      1.434476,
      1,
      NULL,
      NULL,
      0.034240,
      NULL,
      0,
      NULL,
      0.132261,
      3.345361,
      3.163622,
      NULL,
      0.967487,
      0.643669,
      1.530686,
      2.612953,
      NULL,
      1,
      1,
      1.889248,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.589084,
      0,
      0.693530,
      1,
      1,
      2,
      7,
      0,
      NULL,
      NULL,
      106.054810,
      114,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      0.469898,
      '',
      '',
      '',
      0.276946,
      '',
      '',
      '');
commit;
end;
/


