set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      2,
      3,
      1.473113,
      NULL,
      NULL,
      2.655414,
      '402',
      '04022321',
      9,
      55,
      '4100102',
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 6-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      1.530507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-18-1985',
      ' 0-11-1983',
      NULL,
      NULL,
      1.621820,
      NULL,
      NULL,
      0.859242,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      9,
      2.060395,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.260388,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0.992776,
      1,
      0,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      4,
      4,
      1,
      2,
      5.492653,
      1,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      3,
      3.697537,
      0,
      0,
      NULL,
      3,
      1,
      1,
      1,
      3,
      3.638090,
      2,
      0.039148,
      0.226163,
      0.655811,
      0,
      0,
      4,
      2.167212,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.514336,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      4,
      NULL,
      2,
      5,
      1,
      4,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      0,
      0,
      1,
      3,
      5,
      1,
      3.144267,
      NULL,
      ' 5-27-1981',
      NULL,
      ' 9- 8-2002',
      91,
      1.228589,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.098528,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.938276,
      0.913258,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.852250,
      1,
      7,
      1.502922,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126266,
      NULL,
      1,
      2,
      0.475909,
      0.827859,
      1,
      NULL,
      38.901710,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      2,
      0,
      2,
      0,
      0,
      0,
      2,
      3,
      2,
      0.687100,
      NULL,
      NULL,
      1.944774,
      2,
      0.528626,
      0,
      NULL,
      NULL,
      0.772210,
      1,
      1,
      1,
      0,
      NULL,
      3,
      1.091151,
      6,
      3.550349,
      6.277772,
      1,
      5.728594,
      NULL,
      NULL,
      1,
      4.320973,
      1.036215,
      2,
      0.975518,
      7.246545,
      1,
      2.441428,
      34,
      NULL,
      42,
      NULL,
      4,
      0.266560,
      1.579650,
      '13104',
      NULL,
      '',
      1.265693,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      53.007732,
      NULL,
      0.113156,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.060367,
      1.505757,
      1,
      0,
      1,
      1,
      0.361184,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.110811,
      3.782639,
      2,
      NULL,
      3,
      1,
      3,
      0,
      2,
      NULL,
      NULL,
      2,
      5,
      9,
      4,
      0,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.276425,
      3.828055,
      1.077432,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.537125,
      0,
      2,
      2,
      3,
      0,
      3.970841,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.507176,
      NULL,
      0,
      1,
      0.182623,
      0.683327,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      2.079590,
      4.585081,
      2,
      4.580554,
      1,
      1.111741,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.512772,
      3,
      0.759763,
      0.714123,
      NULL,
      NULL,
      2.187300,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.281109,
      0,
      7,
      1,
      1.375355,
      NULL,
      NULL,
      0.138243,
      NULL,
      NULL,
      1.288265,
      NULL,
      NULL,
      1.596972,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.542323,
      1.707540,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.545078,
      NULL,
      3.606814,
      1.058851,
      NULL,
      1,
      NULL,
      NULL,
      0.386947,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.551269,
      1.744436,
      2,
      5,
      7.770412,
      5,
      0.355009,
      NULL,
      1,
      0,
      NULL,
      1,
      1.661537,
      NULL,
      NULL,
      0,
      1,
      1.074132,
      NULL,
      1.009715,
      5,
      NULL,
      5,
      0,
      1,
      0,
      1,
      1.583802,
      0,
      0,
      1.763769,
      NULL,
      2.236820,
      NULL,
      NULL,
      1.875834,
      4,
      NULL,
      NULL,
      2.527594,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.956706,
      NULL,
      NULL,
      1.975411,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2.359610,
      NULL,
      1.944354,
      1,
      NULL,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.186491,
      NULL,
      1,
      NULL,
      NULL,
      3.345210,
      10.897660,
      NULL,
      5.722947,
      3,
      NULL,
      1.477604,
      NULL,
      0,
      0.526618,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.043167,
      NULL,
      NULL,
      NULL,
      36.244869,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.445449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.941483,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.067426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.427827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755459,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5.684843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.333168,
      18.061011,
      15,
      1,
      31.012138,
      4.318671,
      1.877424,
      NULL,
      NULL,
      NULL,
      11.028052,
      0,
      1.502423,
      NULL,
      NULL,
      0.934086,
      NULL,
      NULL,
      1.558747,
      NULL,
      0,
      1.049403,
      1.763564,
      NULL,
      NULL,
      1,
      NULL,
      1.417464,
      1.932774,
      1,
      0,
      1,
      1,
      1,
      1.133132,
      0.972388,
      1,
      0.212541,
      NULL,
      0.041125,
      0.190950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      3.786039,
      3,
      6,
      0,
      NULL,
      NULL,
      0,
      1.206374,
      NULL,
      1.471696,
      0,
      NULL,
      0,
      1,
      NULL,
      0.867648,
      1,
      NULL,
      0.484669,
      0.497082,
      NULL,
      NULL,
      1.363385,
      NULL,
      1.390539,
      1.851137,
      NULL,
      NULL,
      0.503217,
      NULL,
      0.426742,
      0.542723,
      NULL,
      0.602557,
      0,
      NULL,
      1,
      1.365324,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0.064929,
      NULL,
      NULL,
      28.706650,
      93.199654,
      2,
      2,
      NULL,
      '42110',
      NULL,
      '',
      0.153547,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


