set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9413327';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '1002411',
      1.038298,
      0.434319,
      5,
      NULL,
      '1442',
      NULL,
      0,
      NULL,
      NULL,
      '11- 3-1998',
      NULL,
      NULL,
      NULL,
      3,
      1.201646,
      NULL,
      17,
      1,
      166.399707,
      3.225885,
      3,
      ' 6-26-1995',
      '10-18-1994',
      ' 5-24-1998',
      0,
      0.409784,
      2,
      1.597859,
      0,
      1.676562,
      1,
      0,
      0,
      NULL,
      0,
      13,
      7,
      85,
      10,
      0,
      8,
      NULL,
      2,
      9.050257,
      0.531136,
      1,
      0,
      NULL,
      NULL,
      0.927589,
      0,
      NULL,
      0.934776,
      135,
      1,
      6,
      0,
      NULL,
      2.190635,
      2,
      NULL,
      0,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7,
      NULL,
      NULL,
      0,
      0,
      0.009148,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.979913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.355063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      5,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      5.967013,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.389288,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      3,
      2,
      2,
      1,
      4,
      1,
      0,
      3,
      0,
      NULL,
      1,
      NULL,
      ' 2-28-2002',
      9,
      ' 5-13-1994',
      6.548092,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      5,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.705455,
      0.138747,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      3,
      2.836428,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.936311,
      1.127544,
      1.842974,
      NULL,
      0.920074,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952339,
      0,
      1,
      3,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      NULL,
      0,
      2.187067,
      19,
      4,
      112.959076,
      39.065190,
      NULL,
      118.002730,
      125,
      129.375142,
      0.846114,
      1,
      NULL,
      2,
      1.514418,
      1.922748,
      1,
      2,
      12,
      1,
      4,
      NULL,
      NULL,
      2.232843,
      4.036657,
      0.878242,
      4.573289,
      NULL,
      4,
      2.010427,
      2,
      1.278605,
      NULL,
      0,
      3,
      NULL,
      32,
      69,
      27,
      2,
      2,
      2.385141,
      '00401',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.599843,
      1,
      5.114066,
      17.777340,
      2.324478,
      41.398299,
      NULL,
      1.290787,
      4,
      3.811336,
      1,
      1.651570,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.295973,
      1,
      1,
      0,
      0.345054,
      NULL,
      0.919730,
      NULL,
      NULL,
      NULL,
      1.710823,
      0,
      0.587461,
      NULL,
      NULL,
      NULL,
      0.790428,
      0.792028,
      0.827833,
      NULL,
      NULL,
      0.354367,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.871875,
      5,
      NULL,
      NULL,
      1.008923,
      NULL,
      NULL,
      NULL,
      0.757049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358977,
      NULL,
      NULL,
      0.908144,
      NULL,
      NULL,
      1.108848,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1.236462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.717608,
      NULL,
      NULL,
      0.905296,
      NULL,
      NULL,
      3,
      2.096153,
      NULL,
      1.783186,
      5,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456983,
      NULL,
      NULL,
      1.728709,
      2,
      3,
      0,
      NULL,
      2.277817,
      NULL,
      5,
      2.267752,
      NULL,
      3,
      NULL,
      1,
      2.016828,
      3.615234,
      NULL,
      3,
      3,
      0,
      2.773415,
      1.623313,
      2,
      4.484787,
      9,
      2.408379,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      2.301565,
      NULL,
      NULL,
      1.934458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096528,
      NULL,
      NULL,
      2.252960,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.288493,
      NULL,
      NULL,
      0,
      0.267859,
      0,
      NULL,
      NULL,
      5.802807,
      3,
      NULL,
      NULL,
      NULL,
      39.666717,
      NULL,
      NULL,
      NULL,
      1.175791,
      NULL,
      NULL,
      0.562614,
      NULL,
      NULL,
      NULL,
      0.145848,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.875971,
      1.737727,
      NULL,
      NULL,
      0.962632,
      1.805519,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.387989,
      NULL,
      NULL,
      NULL,
      1.156985,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      5,
      7.646535,
      NULL,
      NULL,
      2.738856,
      2,
      3,
      1,
      NULL,
      24.624137,
      5,
      0,
      7,
      1.612369,
      0,
      NULL,
      NULL,
      0.050141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.453374,
      NULL,
      NULL,
      0.459024,
      NULL,
      NULL,
      85,
      6.304588,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1.122775,
      0.967377,
      1,
      3.742864,
      1.161320,
      0.140231,
      NULL,
      NULL,
      1,
      3.997952,
      NULL,
      0.454283,
      NULL,
      NULL,
      NULL,
      1.384238,
      NULL,
      0,
      NULL,
      2.265405,
      NULL,
      NULL,
      NULL,
      1,
      12,
      26,
      1,
      0.126121,
      2.383992,
      NULL,
      0.160849,
      NULL,
      1.371654,
      NULL,
      1.013391,
      NULL,
      NULL,
      NULL,
      1.637694,
      NULL,
      0.765587,
      NULL,
      1.631497,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.923407,
      NULL,
      0,
      NULL,
      1.369001,
      NULL,
      0.996866,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.721740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474988,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658594,
      1.188608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361745,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.067504,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      1.147925,
      NULL,
      0,
      3,
      NULL,
      3,
      1.065852,
      3.602178,
      0,
      0,
      NULL,
      1.372935,
      3.060295,
      0.554483,
      NULL,
      3.210569,
      1.647863,
      1,
      0.746683,
      1,
      1,
      0.439473,
      1,
      1.358722,
      NULL,
      0,
      1.330831,
      1,
      1,
      1.777676,
      1,
      0,
      0.218611,
      1,
      1,
      NULL,
      1.580386,
      1.527815,
      NULL,
      1.154606,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.638963,
      1,
      1,
      1.558350,
      0,
      4,
      4,
      NULL,
      1.016382,
      NULL,
      NULL,
      57,
      38.536935,
      NULL,
      2,
      NULL,
      '43324',
      '04123',
      '',
      1,
      NULL,
      '',
      '',
      1.817710,
      '',
      '',
      NULL);
commit;
end;
/


