set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '14',
      NULL,
      11,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '1200',
      5,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1976',
      53.415872,
      22,
      NULL,
      0.830904,
      1,
      ' 0-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1992',
      ' 8-11-1975',
      NULL,
      1.762022,
      NULL,
      NULL,
      0.204799,
      0.623060,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      11,
      2.465719,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.034306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.040650,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      3.285372,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.298102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.766945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      0,
      0,
      1,
      2,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      3,
      2,
      1,
      0,
      0,
      0,
      2,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      '11-13-1989',
      6,
      2,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      5,
      5,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      0.004926,
      0.940849,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069425,
      1.857453,
      1.309854,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.419128,
      1.200203,
      NULL,
      NULL,
      NULL,
      1,
      0.462823,
      0,
      3,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      2.401756,
      NULL,
      2,
      0.283077,
      1.210902,
      1.481705,
      1,
      1.383079,
      1.099145,
      1.951552,
      0.565221,
      NULL,
      0.690214,
      NULL,
      1.950080,
      0,
      1,
      2,
      1,
      0.591044,
      2,
      2,
      NULL,
      4,
      0,
      4,
      0.588635,
      NULL,
      0.453800,
      3,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      28,
      75.903022,
      5,
      NULL,
      2.042469,
      '10030',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.542146,
      '',
      '',
      NULL,
      0,
      21.656714,
      22.017248,
      27.109427,
      1.899392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.758814,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.783163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.168236,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245600,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.861424,
      NULL,
      NULL,
      0.270961,
      NULL,
      NULL,
      1.808431,
      NULL,
      NULL,
      1.011212,
      NULL,
      NULL,
      0.333911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.240791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.878304,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132421,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.515500,
      0.729381,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.690892,
      NULL,
      0,
      1,
      2,
      3,
      0,
      0,
      NULL,
      NULL,
      0.343731,
      2,
      NULL,
      2.614956,
      1,
      0,
      2,
      0,
      0.296278,
      1.011859,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.854186,
      1,
      0,
      1,
      0.024597,
      0.017526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.283849,
      NULL,
      NULL,
      1,
      6.400251,
      NULL,
      NULL,
      NULL,
      17.560284,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.421211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.305713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.364995,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.838968,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643225,
      1.108582,
      3.693879,
      1.570401,
      0.188398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.742182,
      NULL,
      NULL,
      1.214931,
      NULL,
      NULL,
      220.636771,
      3.689262,
      0,
      1.852311,
      0,
      NULL,
      0.455231,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0.391889,
      NULL,
      0.013460,
      1.173562,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.906326,
      1.559096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.901273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.543039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132386,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.061154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.886832,
      0.398417,
      1,
      1.615658,
      0.160604,
      1.928381,
      NULL,
      NULL,
      0.347315,
      1,
      1.262894,
      0.229644,
      0,
      0.898533,
      1.057159,
      0.875328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.116068,
      1,
      0,
      NULL,
      4,
      2.556381,
      0.794300,
      NULL,
      0.185356,
      1.011874,
      0.539544,
      0,
      1,
      0,
      1.424641,
      0.604182,
      1,
      0,
      0.671671,
      NULL,
      1.035213,
      1.035618,
      NULL,
      0,
      0.670385,
      1,
      0,
      0,
      1.565054,
      0,
      NULL,
      0,
      1,
      0.455604,
      1,
      1.829306,
      1,
      0,
      0,
      0.166754,
      1,
      3,
      1.953862,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405748,
      0,
      1,
      NULL,
      1,
      1,
      2,
      5,
      4,
      0.562802,
      NULL,
      NULL,
      NULL,
      114,
      3,
      2.340814,
      0.749536,
      NULL,
      NULL,
      NULL,
      1.930021,
      NULL,
      '',
      '',
      3,
      '0301',
      '3402',
      NULL);
commit;
end;
/


