set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1143023',
      NULL,
      0,
      2,
      3,
      '3032',
      NULL,
      0.338709,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      2,
      3.912690,
      5.306617,
      ' 7-27-1998',
      2.187637,
      2,
      40,
      49.291253,
      0,
      ' 8- 2-1981',
      ' 9- 6-1976',
      ' 8-10-1987',
      NULL,
      1,
      3,
      2.391569,
      NULL,
      2.025257,
      1,
      0.464432,
      NULL,
      NULL,
      NULL,
      8,
      3,
      7,
      28,
      1,
      18.503143,
      4,
      0,
      1,
      1.687671,
      NULL,
      0,
      1,
      0,
      1,
      0.677339,
      3.155754,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3.320018,
      2,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      0,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      5.286146,
      1,
      NULL,
      1,
      1,
      0.953959,
      NULL,
      0,
      2,
      3,
      NULL,
      1,
      NULL,
      5,
      1,
      0,
      0,
      0,
      NULL,
      5,
      NULL,
      2,
      3,
      4,
      0,
      0,
      1,
      NULL,
      3,
      4,
      3,
      3,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.512406,
      NULL,
      1.821988,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.063293,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656938,
      1.572901,
      NULL,
      7.765373,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.006612,
      0,
      1,
      2,
      3,
      2,
      3,
      NULL,
      2,
      0,
      NULL,
      2,
      NULL,
      4.516154,
      NULL,
      NULL,
      1.962801,
      0.340179,
      0.174372,
      0,
      NULL,
      0.542656,
      NULL,
      0.883985,
      NULL,
      0,
      1,
      15.308505,
      14,
      1.194400,
      NULL,
      NULL,
      0,
      NULL,
      10.268659,
      2,
      4.689720,
      1.142573,
      3,
      3.417067,
      1.656231,
      2,
      47.038893,
      0,
      0,
      NULL,
      87,
      9,
      15.255258,
      0,
      1,
      1,
      '41141',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.196378,
      '',
      '',
      '',
      3,
      2.936395,
      91.788932,
      9,
      3,
      NULL,
      1,
      1.862771,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.437835,
      NULL,
      NULL,
      0.091520,
      NULL,
      NULL,
      3.817692,
      0,
      1.314399,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.093466,
      1.387681,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.270695,
      NULL,
      NULL,
      NULL,
      2.918541,
      1.742039,
      1.437499,
      3.542749,
      1,
      1.972624,
      0.085839,
      0.519470,
      1.465380,
      2,
      NULL,
      0.344395,
      3,
      2,
      2,
      1,
      2,
      NULL,
      0,
      0,
      0.258701,
      1,
      0.420426,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.971780,
      NULL,
      NULL,
      3.315317,
      1,
      1,
      NULL,
      0.283112,
      NULL,
      NULL,
      NULL,
      0.205305,
      NULL,
      NULL,
      NULL,
      0.767025,
      NULL,
      NULL,
      1,
      2,
      3.370588,
      NULL,
      1.485340,
      2,
      NULL,
      2.744051,
      3.728108,
      NULL,
      4,
      5,
      NULL,
      0.830154,
      NULL,
      1.928584,
      NULL,
      NULL,
      5.807459,
      NULL,
      1.119776,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.383207,
      NULL,
      NULL,
      1.301116,
      NULL,
      NULL,
      1.338338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      5,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.209037,
      2,
      1.112609,
      0,
      2.117057,
      NULL,
      2.492673,
      3.581284,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.993045,
      0,
      1.236543,
      0.159831,
      NULL,
      NULL,
      1,
      NULL,
      3.529788,
      0,
      0,
      2,
      NULL,
      NULL,
      1.215908,
      0,
      4,
      2.456630,
      0,
      1,
      0.912592,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.831502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200909,
      NULL,
      NULL,
      0.774153,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.596252,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.954296,
      NULL,
      NULL,
      0.970099,
      0.643053,
      1,
      0.693841,
      1,
      3,
      0.259076,
      NULL,
      NULL,
      1.895881,
      1.496212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.149816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.035314,
      0,
      NULL,
      NULL,
      1.307682,
      0.052939,
      NULL,
      NULL,
      2.666689,
      2,
      NULL,
      NULL,
      1,
      0.431595,
      NULL,
      NULL,
      NULL,
      1.270332,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222495,
      30,
      1,
      3.722337,
      2.598974,
      0.927155,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.579646,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793848,
      132,
      1.126007,
      1.656658,
      1,
      0,
      1,
      0.869386,
      1.486658,
      1,
      0,
      0,
      0.605616,
      NULL,
      NULL,
      0.647558,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      7,
      2.897569,
      2,
      8,
      3,
      NULL,
      1.501833,
      0,
      3,
      NULL,
      1,
      3,
      0,
      2.157069,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      1.850237,
      0.591055,
      0.510462,
      NULL,
      1.079956,
      1,
      0,
      2,
      0,
      1.423951,
      NULL,
      0.437993,
      0,
      0.477929,
      3.937457,
      NULL,
      0.993915,
      NULL,
      0.341194,
      NULL,
      0,
      1,
      1.231344,
      2,
      1.737550,
      0.709150,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.333617,
      NULL,
      NULL,
      NULL,
      0.482376,
      NULL,
      1.027401,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.978307,
      NULL,
      1.217347,
      NULL,
      NULL,
      NULL,
      10.679485,
      1.755381,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.993682,
      NULL,
      NULL,
      0.981003,
      2,
      NULL,
      5,
      NULL,
      0,
      1.199750,
      35.347476,
      23,
      4,
      NULL,
      NULL,
      '24041',
      '',
      '',
      0.610546,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


