set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637671';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      10,
      NULL,
      '3103034',
      NULL,
      0.034449,
      NULL,
      NULL,
      '3141',
      5.241032,
      0,
      NULL,
      NULL,
      '10-25-1977',
      65,
      NULL,
      NULL,
      3,
      15,
      ' 3-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 0- 7-1980',
      ' 8-19-2001',
      1.463484,
      NULL,
      3.712381,
      0,
      NULL,
      2.216745,
      0,
      1,
      1.456409,
      523.032280,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.373342,
      1,
      0,
      0,
      NULL,
      1.302637,
      0.548101,
      NULL,
      1,
      0,
      23.443638,
      2,
      1,
      3,
      0.696847,
      3,
      0,
      0,
      1,
      4,
      1,
      0,
      1,
      4,
      0,
      4,
      3,
      0,
      1,
      1,
      2,
      0,
      0.719586,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      5,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      5.591216,
      2.891245,
      7,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      1,
      2,
      3,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      2,
      4,
      0,
      2,
      1,
      5,
      1,
      NULL,
      0,
      4.967263,
      0,
      '11-15-1978',
      301,
      '10-19-1998',
      NULL,
      1,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1.853176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357878,
      NULL,
      1.164233,
      1,
      0.414261,
      1,
      0.331253,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697266,
      1.719804,
      1.636854,
      0,
      1.802685,
      1,
      NULL,
      3,
      1,
      0,
      2.327925,
      48.423381,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      2,
      0,
      2,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      0.625577,
      NULL,
      2,
      3,
      1,
      0.987255,
      0,
      1.823689,
      1,
      NULL,
      0,
      1,
      0.241987,
      1.713020,
      0.516664,
      0,
      0,
      2,
      1,
      6.794577,
      5,
      2.553108,
      0,
      1.322158,
      7,
      1,
      NULL,
      3,
      1,
      NULL,
      3.450945,
      31,
      3,
      NULL,
      23,
      NULL,
      28,
      52,
      NULL,
      NULL,
      1,
      '23430',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '04441',
      NULL,
      NULL,
      1.286659,
      14.149187,
      323,
      21,
      NULL,
      32.648112,
      4.289124,
      77.120072,
      0,
      NULL,
      3.872104,
      2.865666,
      0.652280,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.901523,
      NULL,
      1,
      1,
      2,
      1.844274,
      3,
      NULL,
      NULL,
      3,
      NULL,
      1.895257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356086,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.698700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.132604,
      0,
      NULL,
      2.082278,
      0,
      1,
      NULL,
      3,
      1,
      1.511127,
      NULL,
      NULL,
      0,
      0.415829,
      NULL,
      0.028712,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.183503,
      2,
      0.949775,
      5,
      7.843042,
      3.486941,
      0,
      0.654858,
      NULL,
      NULL,
      NULL,
      0.569043,
      NULL,
      NULL,
      NULL,
      0.374738,
      NULL,
      NULL,
      NULL,
      2.531993,
      0,
      0.637544,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.465305,
      2,
      1.457236,
      NULL,
      NULL,
      NULL,
      0,
      4.489566,
      NULL,
      NULL,
      0.692964,
      1.499304,
      NULL,
      NULL,
      0.691828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023781,
      1,
      3.219472,
      3.042405,
      2,
      NULL,
      0,
      2.278289,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3.765461,
      2.768083,
      NULL,
      8,
      0.926238,
      0.536786,
      3.529609,
      1,
      1.730654,
      NULL,
      NULL,
      0,
      1,
      2.506790,
      0.116243,
      NULL,
      NULL,
      7.424634,
      9,
      3,
      2.054959,
      0.742676,
      0.385934,
      NULL,
      3.010399,
      3.838161,
      0,
      2,
      3,
      NULL,
      1.107665,
      1.661317,
      8,
      6,
      4,
      0,
      3.455097,
      3,
      2,
      4,
      2,
      0.680539,
      NULL,
      NULL,
      0.302898,
      0,
      3.305854,
      NULL,
      NULL,
      0.080001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.103087,
      NULL,
      NULL,
      0,
      0.897637,
      NULL,
      NULL,
      0,
      2.838875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.897465,
      NULL,
      NULL,
      NULL,
      0.585676,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.558466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.119271,
      NULL,
      NULL,
      NULL,
      2.834099,
      273,
      49486.494501,
      NULL,
      10.375940,
      779,
      NULL,
      NULL,
      NULL,
      NULL,
      18.882275,
      NULL,
      1.757865,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      459.519348,
      54468,
      NULL,
      0.090539,
      0,
      0,
      0.267552,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1.235963,
      1.014453,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.967387,
      0.293731,
      4.443553,
      0,
      3,
      4.095617,
      3.781095,
      NULL,
      0.012627,
      0.201191,
      1.009035,
      NULL,
      0.364721,
      0,
      NULL,
      1.044651,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.624544,
      0,
      NULL,
      1.282154,
      1.740326,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.993038,
      1.597988,
      NULL,
      3,
      NULL,
      1.889346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966277,
      NULL,
      0,
      NULL,
      1.510467,
      NULL,
      2,
      6,
      2,
      0.380722,
      1.848881,
      2.381010,
      NULL,
      1,
      5,
      NULL,
      1,
      '42330',
      '',
      '',
      1.733964,
      '',
      '',
      '',
      0.156936,
      '30300',
      '',
      '');
commit;
end;
/


