set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '4440413',
      0,
      NULL,
      NULL,
      0,
      '4442',
      0.718169,
      0,
      NULL,
      NULL,
      ' 0- 7-1995',
      23.999243,
      NULL,
      3,
      2,
      2.782748,
      ' 7- 9-1986',
      38,
      0.992320,
      202.369555,
      76.625739,
      3,
      ' 6- 3-1979',
      ' 4-22-1974',
      ' 2-14-1983',
      2,
      2,
      3,
      NULL,
      2,
      2.276201,
      3,
      3,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      17,
      6,
      5,
      21.746522,
      0,
      NULL,
      3.943183,
      3.584708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      3.908113,
      1,
      1,
      0,
      2,
      2,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.038778,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      2,
      3,
      0.763751,
      1.934943,
      NULL,
      0.512277,
      1,
      1,
      2.853309,
      NULL,
      0.119270,
      2,
      3,
      1,
      1,
      1,
      1,
      NULL,
      7,
      0,
      1,
      0,
      0.669094,
      NULL,
      NULL,
      1.245400,
      NULL,
      NULL,
      4,
      4,
      0,
      2,
      4,
      2,
      5,
      0,
      0,
      4,
      0,
      0,
      NULL,
      3,
      1,
      0,
      1,
      0,
      5,
      0,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      5,
      2,
      1,
      1,
      2,
      0,
      0,
      5,
      3,
      2,
      4,
      0,
      2,
      0,
      1,
      3,
      0,
      3,
      2,
      NULL,
      7.124820,
      0,
      NULL,
      14.192030,
      '10- 0-1994',
      11,
      2,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      19,
      2.817811,
      1.175000,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.116822,
      3.650367,
      0.245258,
      0.226144,
      NULL,
      1,
      5.468706,
      5,
      NULL,
      3,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.383003,
      1,
      1.992630,
      1.397037,
      0.774231,
      NULL,
      0,
      0.515619,
      50,
      1.166721,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      3,
      2,
      NULL,
      3,
      NULL,
      3.262208,
      2.515097,
      1.945127,
      1.463005,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.204639,
      1.218761,
      1,
      1,
      1,
      0,
      0,
      11,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.653264,
      5.941797,
      2.628493,
      1,
      0.199161,
      53,
      3,
      1,
      NULL,
      23,
      28,
      36,
      5,
      2,
      4.219458,
      NULL,
      NULL,
      '',
      1.372204,
      '',
      '',
      '',
      1.773929,
      '',
      '',
      '',
      0.800743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.493633,
      2,
      0,
      0,
      NULL,
      NULL,
      1.304898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675334,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.820072,
      90,
      2.226945,
      0.068068,
      0,
      1.137852,
      1,
      1,
      0.008828,
      NULL,
      NULL,
      1.399513,
      1,
      1.148632,
      2,
      NULL,
      0.116957,
      0,
      0,
      1.549740,
      0.465279,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.641138,
      NULL,
      0.183679,
      NULL,
      1.397828,
      NULL,
      0.636636,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903720,
      1.874080,
      1.743012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164641,
      NULL,
      1.378458,
      NULL,
      2.754447,
      NULL,
      123,
      NULL,
      0,
      NULL,
      0.798875,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.431119,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570272,
      1.213347,
      1.180803,
      NULL,
      1.998459,
      NULL,
      NULL,
      NULL,
      1.349203,
      NULL,
      1.797798,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      NULL,
      0,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      1.189624,
      NULL,
      NULL,
      0,
      0.597858,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      NULL,
      1.997189,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.793400,
      1,
      NULL,
      0.455312,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.292289,
      0.378027,
      0.333749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.739225,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      45,
      8,
      2,
      2,
      1.970575,
      '24144',
      '32214',
      '',
      NULL,
      '',
      '',
      '',
      0.353639,
      NULL,
      '',
      NULL);
commit;
end;
/


