set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '0200002',
      1.940143,
      0.828190,
      5,
      1,
      '4400',
      NULL,
      1.543688,
      NULL,
      NULL,
      ' 1- 4-1982',
      16.396262,
      NULL,
      2,
      2,
      0.874267,
      ' 4-24-2003',
      10,
      0,
      24.983322,
      68,
      3,
      ' 7-17-2002',
      ' 2-21-1974',
      ' 4-19-1989',
      3.717455,
      3,
      1.877413,
      3.514015,
      0.287295,
      0.223517,
      3,
      1,
      1,
      2.280165,
      NULL,
      9,
      1.039533,
      4,
      NULL,
      NULL,
      27.555064,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0.246376,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      0,
      1,
      1,
      5,
      0,
      0,
      1,
      1,
      1.644682,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      1,
      1.789003,
      NULL,
      NULL,
      NULL,
      0.289351,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      5,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0.058582,
      2,
      0,
      0,
      4,
      NULL,
      1,
      2,
      0,
      NULL,
      3,
      4,
      2,
      3,
      0,
      2,
      5,
      2,
      NULL,
      1,
      2,
      4,
      NULL,
      0,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.939621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      15,
      2.340076,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.470224,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.251153,
      NULL,
      4.107007,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.329731,
      1.616814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.758930,
      1.687484,
      1.097411,
      NULL,
      0,
      3.777280,
      19.779571,
      2.508389,
      0.795223,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      2,
      3,
      3,
      2,
      2.576060,
      1.446265,
      2.047927,
      NULL,
      0,
      1,
      4,
      NULL,
      1,
      1.343865,
      1,
      1.889983,
      0.077260,
      0.112143,
      1.746073,
      0,
      NULL,
      0.150617,
      1,
      1.212523,
      6.009792,
      NULL,
      7.694423,
      11,
      NULL,
      2.001432,
      2,
      7.672663,
      3,
      0.149644,
      0.664397,
      11.707458,
      2,
      2.739094,
      NULL,
      44,
      30,
      29,
      4,
      3.395757,
      3,
      '20232',
      NULL,
      '',
      0.622979,
      '',
      '',
      '',
      0.216217,
      '',
      NULL,
      '',
      0.096575,
      8,
      175.678673,
      17.018075,
      0,
      25,
      2.315621,
      2.167136,
      3,
      2,
      1,
      0.591210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.679521,
      0.403485,
      0,
      1,
      NULL,
      NULL,
      1,
      1.180079,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.017295,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.693702,
      NULL,
      NULL,
      2.374101,
      0,
      1.254194,
      1,
      1.439782,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.508422,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.726657,
      1,
      NULL,
      0,
      1.810285,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.267017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.378245,
      1.664501,
      1.912407,
      NULL,
      NULL,
      NULL,
      1.494342,
      NULL,
      NULL,
      4.641850,
      7,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860926,
      NULL,
      NULL,
      0.882566,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.115515,
      0.355181,
      NULL,
      NULL,
      0,
      3,
      0,
      1.325580,
      3.729067,
      3,
      0,
      NULL,
      NULL,
      0.314750,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2.328706,
      0.549039,
      3,
      4,
      1.343714,
      1.944569,
      NULL,
      0.660314,
      0.463341,
      2,
      0,
      1,
      2,
      1.054230,
      3,
      1.258539,
      2,
      6.485885,
      7.546302,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.672610,
      0,
      NULL,
      0.667106,
      1.001860,
      NULL,
      NULL,
      NULL,
      0.583365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097345,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.137418,
      NULL,
      NULL,
      0.431591,
      1.418656,
      1,
      0.083895,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.065235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044663,
      1,
      NULL,
      NULL,
      1.982565,
      2,
      NULL,
      NULL,
      0.904073,
      0.401208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.230690,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.962131,
      2.509152,
      1,
      10.578106,
      0.279430,
      1.733223,
      NULL,
      NULL,
      0.676565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072652,
      NULL,
      NULL,
      0.560981,
      NULL,
      0,
      NULL,
      1.783070,
      1,
      0,
      NULL,
      1,
      1.494897,
      NULL,
      1.755727,
      1.050186,
      NULL,
      0.765059,
      1.838148,
      0,
      0,
      1.504593,
      0.780471,
      0,
      0.126981,
      1.021726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      2,
      2,
      2,
      9.324443,
      3.824049,
      3.610102,
      1,
      1,
      0,
      1.041590,
      NULL,
      NULL,
      0.472375,
      1.089477,
      1.254672,
      2.477225,
      0,
      0.389747,
      NULL,
      0.888131,
      3.121776,
      3.701598,
      0.835862,
      1,
      1.659806,
      1,
      NULL,
      2,
      0.160311,
      NULL,
      2,
      0,
      3.229763,
      1,
      1,
      NULL,
      3,
      1,
      0.317347,
      2.631061,
      0.276239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649551,
      NULL,
      0.208771,
      1.250054,
      NULL,
      0,
      4,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      101.913869,
      3,
      4,
      1.643364,
      '23022',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


