set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      NULL,
      1.574613,
      2,
      1,
      0.124695,
      NULL,
      '200',
      NULL,
      44.816365,
      48,
      '0213342',
      NULL,
      NULL,
      NULL,
      1,
      '3322',
      1.275630,
      0,
      NULL,
      NULL,
      ' 5-16-1977',
      8.752632,
      2.844817,
      NULL,
      0,
      1.660331,
      ' 2-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 3-11-2002',
      NULL,
      1.049270,
      NULL,
      2.399920,
      0,
      3.325781,
      1,
      3.082864,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.895731,
      0,
      0,
      1.667564,
      0.265612,
      0,
      0,
      0,
      NULL,
      2.875032,
      3,
      0,
      0,
      NULL,
      0,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      8,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.041680,
      NULL,
      NULL,
      3,
      0,
      9,
      NULL,
      0.091344,
      0.112595,
      NULL,
      0,
      1.140739,
      1,
      NULL,
      1,
      3,
      2.417581,
      0.473956,
      NULL,
      0,
      0.994163,
      0,
      4,
      3,
      NULL,
      3,
      0,
      2,
      1.389552,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      4,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1.118640,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1.328790,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      4,
      NULL,
      NULL,
      1,
      0,
      0,
      5,
      0,
      1,
      0,
      4,
      3,
      3,
      1,
      NULL,
      1,
      4,
      NULL,
      0,
      0.025133,
      2.010231,
      NULL,
      624,
      ' 9-11-1978',
      39.862045,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874408,
      0.215686,
      NULL,
      0,
      0.777444,
      4.589606,
      0.010752,
      NULL,
      NULL,
      NULL,
      1,
      2.742470,
      1.023778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950743,
      1,
      0,
      0.471124,
      NULL,
      0.353455,
      0,
      NULL,
      NULL,
      0.547417,
      1.250789,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      2,
      3,
      3,
      NULL,
      2,
      0,
      2,
      2,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.479570,
      1.585095,
      1,
      0,
      NULL,
      NULL,
      0,
      0.556305,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.311692,
      NULL,
      2,
      3,
      5,
      2.654410,
      0.554938,
      1,
      NULL,
      5,
      NULL,
      1.702555,
      3,
      54,
      NULL,
      1.537364,
      12,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      '33133',
      '02100',
      '',
      1.996639,
      NULL,
      '',
      '',
      1.874178,
      '',
      '',
      '',
      3,
      10.127680,
      17,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209003,
      2.139586,
      2,
      NULL,
      NULL,
      NULL,
      0.739253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066202,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.514439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.467828,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.915269,
      2,
      3,
      NULL,
      0.241028,
      0.986374,
      NULL,
      2.526534,
      NULL,
      NULL,
      NULL,
      3.818227,
      3.043764,
      0.739555,
      NULL,
      1,
      0.996981,
      NULL,
      1.282699,
      2,
      0,
      1.603318,
      0.732143,
      NULL,
      NULL,
      NULL,
      1.208686,
      0,
      NULL,
      NULL,
      2.934173,
      1,
      1.875966,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.807383,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      3.792253,
      0,
      NULL,
      NULL,
      1.071946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073368,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.873959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.980580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.963885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.993771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828433,
      NULL,
      NULL,
      1.925650,
      NULL,
      NULL,
      0.700824,
      NULL,
      0.957140,
      1.807527,
      0,
      1,
      0,
      NULL,
      1.790339,
      1,
      1.284535,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.566970,
      NULL,
      NULL,
      1.570460,
      NULL,
      NULL,
      1.784765,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.334936,
      NULL,
      NULL,
      3.133870,
      NULL,
      NULL,
      1.551292,
      0,
      1,
      1.958068,
      1,
      1,
      0.088013,
      NULL,
      NULL,
      0.107883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266613,
      NULL,
      NULL,
      NULL,
      0.392827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.212765,
      NULL,
      NULL,
      1.855975,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      943,
      3,
      2.625086,
      0.346833,
      1,
      1.475029,
      1,
      1.937899,
      1,
      0.878023,
      0.980643,
      1.508199,
      0.783101,
      0,
      0,
      0,
      1.790123,
      0.071842,
      NULL,
      0.424910,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      0,
      NULL,
      0.834954,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.015473,
      NULL,
      2,
      NULL,
      1.034305,
      NULL,
      1.937319,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.178490,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.265106,
      1.964323,
      0.768571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611498,
      0.336364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256056,
      2.388640,
      NULL,
      3.735363,
      NULL,
      0.815273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.248432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.517003,
      NULL,
      0.977717,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284946,
      3,
      NULL,
      NULL,
      NULL,
      1.492859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712310,
      NULL,
      NULL,
      0,
      3,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.924216,
      1,
      0,
      2,
      7,
      0.439162,
      3,
      1.025774,
      0,
      NULL,
      NULL,
      2.757264,
      3,
      NULL,
      1,
      0.328763,
      NULL,
      0,
      0,
      NULL,
      0.670123,
      1,
      NULL,
      1.578644,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.864247,
      0,
      NULL,
      1.480696,
      0,
      NULL,
      0,
      1.757848,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128040,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.072532,
      NULL,
      NULL,
      42.638344,
      86,
      2,
      1.531584,
      6,
      '24424',
      '02022',
      '31041',
      NULL,
      NULL,
      '',
      '',
      0.505716,
      '',
      '',
      '');
commit;
end;
/


