set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4704279';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      NULL,
      30.835095,
      36.110307,
      '4044441',
      3,
      1.659317,
      0,
      1,
      '2244',
      NULL,
      0.189522,
      NULL,
      NULL,
      ' 8- 4-1989',
      7,
      NULL,
      NULL,
      1,
      0,
      ' 8- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-1975',
      '10-13-1995',
      ' 3- 2-1989',
      2.631735,
      NULL,
      0,
      NULL,
      1.243833,
      NULL,
      8,
      1,
      1.851906,
      4,
      0,
      13.080313,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1.618729,
      NULL,
      1,
      NULL,
      NULL,
      0.174821,
      178.080490,
      1,
      4,
      4,
      2.667448,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      2,
      0,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      0.776821,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      0,
      0.889509,
      0.125570,
      1,
      0,
      0.990055,
      NULL,
      0.868536,
      1,
      NULL,
      NULL,
      0.629389,
      0.932613,
      1.580949,
      1,
      0.170170,
      0.091467,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0.282417,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.140723,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.067462,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      3,
      4,
      NULL,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 0-23-1976',
      414.892265,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1.682377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.853694,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136712,
      1.546880,
      0.793137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.283953,
      0,
      1,
      NULL,
      0.897454,
      NULL,
      0.682280,
      1.994447,
      5446.056531,
      1,
      0.979978,
      NULL,
      NULL,
      NULL,
      3,
      1.360525,
      NULL,
      3,
      NULL,
      0,
      3,
      0,
      3,
      3,
      1,
      0,
      0,
      2.365807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.669687,
      1,
      0.825469,
      0,
      1.108099,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      47,
      NULL,
      2,
      55,
      1,
      1.257342,
      0.446128,
      '1222',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '21231',
      NULL,
      '',
      NULL,
      6,
      550.234847,
      NULL,
      1,
      44.101643,
      17.194783,
      17.596092,
      1,
      3.021690,
      2.518755,
      NULL,
      3,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.514596,
      2.139176,
      NULL,
      0,
      2.230978,
      2.487192,
      3.491811,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.117580,
      NULL,
      0.031949,
      0.679909,
      1,
      0.806589,
      0.182536,
      0,
      NULL,
      NULL,
      10,
      9.835476,
      1,
      0,
      0.378336,
      NULL,
      NULL,
      NULL,
      0.376405,
      NULL,
      NULL,
      NULL,
      0.103470,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.244230,
      2,
      0.003715,
      1.625864,
      0,
      3,
      1,
      0,
      2.406733,
      0,
      1,
      2.636461,
      0,
      0,
      1.385607,
      1,
      1,
      2.742179,
      NULL,
      NULL,
      NULL,
      1.486715,
      NULL,
      NULL,
      0.323533,
      1.729299,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.566339,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.422306,
      0.001433,
      1.958740,
      2,
      0.982292,
      NULL,
      0,
      NULL,
      NULL,
      7.135281,
      3,
      3,
      0,
      3.308522,
      1.794629,
      NULL,
      3.772007,
      NULL,
      3.471580,
      NULL,
      NULL,
      0.341529,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.381855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.840914,
      NULL,
      0.285257,
      5,
      1,
      0.644938,
      0.364227,
      NULL,
      3,
      2.331113,
      0.812704,
      2.435283,
      0,
      NULL,
      NULL,
      NULL,
      5.985606,
      5,
      3.139786,
      0.957917,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      1.551000,
      NULL,
      2,
      0.804091,
      8,
      NULL,
      1,
      8,
      1,
      3,
      NULL,
      2,
      3,
      1.694407,
      0.216370,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154672,
      NULL,
      NULL,
      0.931122,
      NULL,
      NULL,
      1.482779,
      NULL,
      NULL,
      1.987204,
      NULL,
      NULL,
      1.790567,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.706326,
      NULL,
      NULL,
      1.673979,
      1.557776,
      0.152034,
      0,
      0,
      3.302256,
      0,
      NULL,
      NULL,
      0.790469,
      2.889491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.962476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.407328,
      3,
      NULL,
      NULL,
      1,
      0.021205,
      NULL,
      NULL,
      NULL,
      1.333030,
      NULL,
      NULL,
      NULL,
      1.229565,
      NULL,
      NULL,
      1.786547,
      0.223581,
      NULL,
      NULL,
      NULL,
      5.782097,
      NULL,
      NULL,
      1.820295,
      NULL,
      NULL,
      NULL,
      1.152163,
      3,
      395.371948,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.863429,
      NULL,
      NULL,
      2.347702,
      45,
      6.560997,
      1,
      18.705822,
      NULL,
      NULL,
      NULL,
      1.740453,
      63.226644,
      21.003329,
      1.356628,
      0,
      NULL,
      0.380871,
      1.885356,
      1.988270,
      1.699521,
      1,
      0,
      0,
      1.009413,
      1,
      1,
      0,
      NULL,
      0.563758,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      3,
      3.273598,
      NULL,
      NULL,
      4.291546,
      0,
      4,
      2,
      0.049526,
      1.686670,
      0.541663,
      1,
      1,
      0,
      1,
      1.195817,
      0,
      0,
      NULL,
      1,
      NULL,
      0.115605,
      1.954077,
      1.693170,
      0,
      NULL,
      0.388121,
      0,
      0.560723,
      0.893658,
      0.796675,
      0.205914,
      1.661325,
      NULL,
      1.313037,
      1.306700,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      2,
      0.494181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.896447,
      0.985982,
      1.024743,
      0,
      0,
      NULL,
      5,
      1,
      0.931651,
      0.877231,
      61.472363,
      34.176519,
      5,
      0,
      1,
      '2440',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.179579,
      '01200',
      NULL,
      NULL);
commit;
end;
/


