set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6611767';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      NULL,
      11,
      NULL,
      NULL,
      0.243783,
      0.308990,
      2,
      3,
      '0300',
      2.743594,
      1,
      NULL,
      NULL,
      NULL,
      32.922431,
      NULL,
      NULL,
      1.408233,
      1,
      ' 3- 4-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.207892,
      0.418942,
      1,
      0,
      1,
      1.555703,
      NULL,
      6,
      13,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1.960825,
      NULL,
      0,
      1,
      1.453035,
      NULL,
      0.175550,
      0,
      0.514685,
      0,
      107.817443,
      0,
      3,
      3,
      3.144511,
      2,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      7.596965,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      3.349581,
      3,
      1.339021,
      1.313125,
      NULL,
      0,
      NULL,
      0.207714,
      0,
      0.367323,
      0.076598,
      0.039073,
      0.706041,
      0,
      1,
      0.794711,
      1.277060,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.283461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      3.437588,
      5,
      1,
      3,
      5,
      NULL,
      4,
      5,
      3,
      1,
      5,
      5,
      NULL,
      0,
      2,
      2,
      4,
      5,
      3,
      4,
      1,
      4,
      4,
      1,
      1,
      1,
      1,
      2,
      NULL,
      3505.110855,
      ' 2-28-2001',
      1571.796832,
      2,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      1.491419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.157514,
      0,
      3,
      3,
      0.737617,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537456,
      NULL,
      2.259675,
      1,
      NULL,
      10.342857,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796210,
      6.719000,
      0.385400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.239299,
      2,
      0.642432,
      NULL,
      NULL,
      0.573188,
      26840,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493026,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      2,
      2,
      2,
      3,
      0.705358,
      5.460890,
      0.414664,
      1.528323,
      6,
      1.631836,
      0,
      0.847681,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.996306,
      1,
      1.544958,
      0,
      1.542680,
      2,
      0.812577,
      0,
      0.895127,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      4.585993,
      1,
      NULL,
      19,
      NULL,
      NULL,
      7.198787,
      2,
      4,
      1,
      '43201',
      '04044',
      '',
      1.471208,
      '',
      NULL,
      NULL,
      1.946799,
      NULL,
      NULL,
      NULL,
      2.055586,
      4.916029,
      530,
      4.990676,
      0.701725,
      10,
      0,
      1310.734761,
      NULL,
      2,
      2.811881,
      2.397932,
      0,
      NULL,
      NULL,
      1.419009,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.111100,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120021,
      NULL,
      NULL,
      1.986830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      8,
      7.888574,
      1,
      1.990485,
      NULL,
      NULL,
      NULL,
      1.124170,
      NULL,
      NULL,
      NULL,
      3.020519,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.646634,
      NULL,
      NULL,
      2,
      1.951424,
      2.263838,
      3,
      0.643866,
      3.856281,
      1,
      1.606143,
      NULL,
      1.982095,
      1.172171,
      0,
      NULL,
      0,
      1.108563,
      1.067973,
      0.138297,
      NULL,
      NULL,
      1.286698,
      NULL,
      NULL,
      1.129261,
      3,
      1.042530,
      NULL,
      3,
      0.570840,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.691399,
      NULL,
      NULL,
      NULL,
      3,
      0.744685,
      1.866312,
      1,
      3.972772,
      NULL,
      0,
      0.366901,
      2,
      1,
      NULL,
      NULL,
      7,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334686,
      NULL,
      NULL,
      2.460331,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.282886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.696280,
      1,
      0,
      1,
      0.852585,
      3.562317,
      NULL,
      NULL,
      NULL,
      4,
      3,
      2.932838,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.052157,
      3.326703,
      3.357836,
      NULL,
      2,
      1.498986,
      NULL,
      2,
      7,
      3,
      5.528350,
      2.080585,
      3,
      2,
      NULL,
      1,
      3,
      NULL,
      1.001940,
      3.159831,
      3.942952,
      1.167485,
      1,
      6,
      3,
      0.517925,
      2,
      NULL,
      7,
      0.070665,
      1,
      3,
      NULL,
      1,
      0.281372,
      0.059487,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.316844,
      NULL,
      NULL,
      0.663177,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.850609,
      NULL,
      NULL,
      3.450340,
      NULL,
      NULL,
      1.493133,
      NULL,
      NULL,
      1.006317,
      NULL,
      NULL,
      1.503104,
      NULL,
      NULL,
      1.341028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329989,
      0.278663,
      1,
      1.209362,
      1.106590,
      1.452218,
      NULL,
      NULL,
      1.797991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032971,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.582211,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.869406,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      640.724756,
      480016,
      0,
      NULL,
      NULL,
      0.696364,
      NULL,
      NULL,
      2,
      116.122302,
      23646.296487,
      1.559187,
      NULL,
      NULL,
      1.582730,
      NULL,
      NULL,
      1.576416,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.870908,
      NULL,
      1.771597,
      0,
      0.148960,
      1.812275,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1.244978,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      7,
      2.426655,
      0,
      NULL,
      2,
      15.277976,
      3.596260,
      2,
      0,
      1.027697,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.480357,
      NULL,
      NULL,
      0.685240,
      NULL,
      2,
      3.679527,
      NULL,
      0,
      1,
      NULL,
      1.354052,
      NULL,
      NULL,
      NULL,
      0.712553,
      NULL,
      NULL,
      1,
      NULL,
      1.208206,
      3,
      NULL,
      0.820319,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487385,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      3,
      1.836164,
      27,
      3,
      1,
      2,
      '32333',
      '33002',
      '',
      0.426089,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


