set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9831665';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      5.384637,
      1.729246,
      0.995960,
      1,
      2.823239,
      0.983918,
      3,
      '241',
      '44304240',
      66.832290,
      42,
      '4234002',
      0.362289,
      NULL,
      0,
      0,
      NULL,
      2.498172,
      NULL,
      NULL,
      NULL,
      ' 9-11-1974',
      132.067792,
      9.886361,
      NULL,
      2,
      NULL,
      ' 9-18-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 2-28-1995',
      '10- 7-1977',
      ' 7-10-1993',
      NULL,
      0.201047,
      2.217447,
      1.879019,
      1.142179,
      3,
      1,
      1.214521,
      NULL,
      NULL,
      NULL,
      5.984525,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      1,
      1,
      1,
      0.860120,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.190248,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.566190,
      NULL,
      0,
      NULL,
      3,
      1.173471,
      0,
      0,
      0,
      0.790862,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      5,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      5,
      0,
      1,
      NULL,
      3,
      5,
      1,
      NULL,
      1,
      0,
      3,
      3,
      3,
      1,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      3,
      3,
      5,
      0,
      2.586171,
      1.563046,
      ' 2- 8-1994',
      213.328131,
      NULL,
      15,
      1.229083,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0.738310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      213.157321,
      NULL,
      1.323743,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143850,
      0,
      NULL,
      2,
      4,
      0,
      0.754787,
      NULL,
      NULL,
      NULL,
      0.121188,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.504876,
      NULL,
      NULL,
      NULL,
      1,
      0.438118,
      1.196303,
      3.050365,
      1,
      0.559258,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      2,
      1.876375,
      0.087211,
      0.460740,
      1.559388,
      0.648226,
      1.493227,
      NULL,
      0.493780,
      NULL,
      0.443864,
      0.631214,
      1,
      NULL,
      2.844738,
      1,
      2,
      6.938482,
      5,
      NULL,
      NULL,
      1.637855,
      NULL,
      2.872450,
      2.808961,
      0.892323,
      0.242615,
      1,
      55,
      NULL,
      1.287661,
      51,
      NULL,
      NULL,
      48.016894,
      1,
      0,
      2.717830,
      '23414',
      '',
      '',
      1.616404,
      NULL,
      '',
      '',
      0.592139,
      '',
      '',
      '',
      0,
      8,
      172,
      11,
      1.662034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224183,
      NULL,
      0.145844,
      NULL,
      NULL,
      1.965603,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.198470,
      1.670242,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.888715,
      NULL,
      NULL,
      1.593945,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.474752,
      1.227083,
      0.357372,
      0.092011,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.983645,
      1,
      1,
      0.307177,
      1.945175,
      1.496368,
      NULL,
      0.576903,
      NULL,
      1.090707,
      0,
      0,
      0.426787,
      0,
      2.842411,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.193115,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.267944,
      NULL,
      NULL,
      NULL,
      1,
      1.839388,
      0.890568,
      0.688054,
      0.604894,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.510476,
      NULL,
      NULL,
      1.750241,
      NULL,
      NULL,
      1.022304,
      NULL,
      NULL,
      0.110450,
      NULL,
      NULL,
      1.355065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811635,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.839735,
      NULL,
      NULL,
      0.434624,
      NULL,
      NULL,
      1.603951,
      NULL,
      NULL,
      0.345085,
      NULL,
      NULL,
      3.453742,
      2.958265,
      3.680130,
      0.539285,
      0.129890,
      0.321877,
      1,
      4,
      2.284216,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.454808,
      NULL,
      3.006350,
      0,
      0,
      NULL,
      NULL,
      0,
      2.114159,
      0.820307,
      0,
      1.645275,
      0.839160,
      NULL,
      2,
      0,
      1,
      0.023595,
      NULL,
      3,
      5.434280,
      NULL,
      0.472120,
      1.300618,
      3.186831,
      NULL,
      0,
      NULL,
      NULL,
      1.863069,
      NULL,
      NULL,
      1,
      1.133753,
      1.868741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.275088,
      2.376988,
      0,
      0.162372,
      0.247551,
      7.205480,
      NULL,
      NULL,
      NULL,
      53.156492,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.857287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.471258,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.116166,
      NULL,
      NULL,
      NULL,
      1.649373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.688607,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933180,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952047,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564499,
      1,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.280109,
      NULL,
      0.854757,
      1.756016,
      1.956808,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      3.627697,
      1.952938,
      3.255247,
      1.594677,
      1,
      1,
      NULL,
      1,
      0.353851,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.735303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.740056,
      NULL,
      NULL,
      NULL,
      1,
      0.371119,
      0.356075,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.693962,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.104132,
      NULL,
      NULL,
      NULL,
      1.267280,
      NULL,
      0.662591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.271315,
      NULL,
      0.750710,
      NULL,
      0,
      1.121885,
      NULL,
      0.665218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.472583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888333,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000900,
      1.839009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.257215,
      NULL,
      276.923057,
      NULL,
      2.581309,
      NULL,
      3.288216,
      NULL,
      0.216652,
      NULL,
      NULL,
      NULL,
      3,
      1.840691,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      5,
      1.116608,
      1,
      1,
      3,
      NULL,
      1.263546,
      0,
      1.479391,
      1.615076,
      NULL,
      0.247810,
      1,
      NULL,
      0.997550,
      0.106257,
      1.194353,
      1,
      2.868517,
      0.810573,
      1,
      1.790183,
      3,
      3,
      NULL,
      0,
      1,
      3.963998,
      3.941832,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0.405849,
      2.488352,
      1.186058,
      NULL,
      1,
      2,
      0,
      1.281747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      6,
      NULL,
      NULL,
      NULL,
      97.295895,
      98,
      4,
      2,
      NULL,
      '44304',
      '20404',
      '2344',
      0.334276,
      NULL,
      '',
      '',
      2.806706,
      '101',
      '',
      NULL);
commit;
end;
/


