set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3611604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '1333042',
      3.663301,
      NULL,
      NULL,
      1,
      '0033',
      1.578575,
      1,
      NULL,
      NULL,
      '11- 1-1982',
      28,
      NULL,
      NULL,
      0.710365,
      0.828252,
      ' 4-27-2000',
      34,
      1,
      221.488807,
      49.766899,
      2,
      '10-13-1979',
      NULL,
      ' 2-12-1983',
      NULL,
      NULL,
      2,
      0,
      0.492686,
      1,
      3,
      1.503995,
      0,
      475.714717,
      2,
      14,
      NULL,
      3.371828,
      2.421773,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0.977551,
      NULL,
      1.774469,
      0,
      NULL,
      1,
      1.139012,
      48.565030,
      1,
      2,
      6,
      NULL,
      2,
      0,
      0,
      2,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1.718463,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.258441,
      0,
      0,
      1,
      1,
      0.193786,
      1.972694,
      1,
      NULL,
      NULL,
      1.176499,
      0,
      NULL,
      1,
      1,
      3,
      NULL,
      1,
      0,
      1.498492,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      4,
      0,
      0,
      0,
      3,
      1,
      NULL,
      0,
      1,
      0.524059,
      NULL,
      1.133904,
      NULL,
      2,
      NULL,
      1,
      1,
      5,
      5,
      2,
      NULL,
      2,
      NULL,
      0,
      2,
      0,
      2,
      2,
      2,
      NULL,
      2,
      5,
      3,
      3,
      NULL,
      0,
      0,
      NULL,
      2.749815,
      ' 2- 2-2003',
      1855,
      ' 0- 1-2002',
      80.490760,
      0.455033,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.828546,
      0.157592,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.959023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.031611,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.865993,
      NULL,
      0.394791,
      0.857641,
      NULL,
      NULL,
      NULL,
      3,
      1.815331,
      3.319634,
      1,
      0,
      2,
      1,
      3,
      NULL,
      2,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      11,
      1.712168,
      0.933125,
      3.615363,
      NULL,
      1,
      0.228665,
      NULL,
      NULL,
      0,
      1.974267,
      1,
      1,
      0.230814,
      0,
      1.078161,
      0.628961,
      6.618029,
      6,
      1,
      NULL,
      NULL,
      4.653070,
      0.283279,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      2.886543,
      NULL,
      42,
      27,
      51,
      5,
      0,
      NULL,
      '10023',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.516145,
      13,
      263.046311,
      1,
      1,
      NULL,
      5,
      NULL,
      5,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.618399,
      NULL,
      NULL,
      NULL,
      3,
      1.029504,
      0.125347,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.629902,
      NULL,
      NULL,
      1.518363,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.913593,
      NULL,
      NULL,
      1.169028,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.611680,
      4.835846,
      6.919979,
      1,
      1.874923,
      NULL,
      NULL,
      NULL,
      2.644336,
      1,
      1.136985,
      1.559573,
      0.906841,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.394503,
      NULL,
      NULL,
      2.371431,
      1,
      0.584599,
      2,
      0.397266,
      1,
      1.159283,
      1.217241,
      0.900796,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.419208,
      NULL,
      NULL,
      1,
      1,
      0,
      7,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.046954,
      2,
      0,
      NULL,
      NULL,
      3.101187,
      NULL,
      NULL,
      1,
      1.916580,
      2,
      1.938388,
      NULL,
      NULL,
      5.374897,
      NULL,
      5,
      3,
      0,
      0.504974,
      0,
      NULL,
      NULL,
      NULL,
      0.009874,
      0.204721,
      1.887870,
      NULL,
      NULL,
      1.368099,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.852409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.880624,
      1.468361,
      1,
      NULL,
      NULL,
      NULL,
      7.773132,
      NULL,
      5,
      3.052653,
      NULL,
      4,
      0.548791,
      NULL,
      NULL,
      2,
      1.148362,
      1,
      NULL,
      1,
      2.336561,
      3,
      1,
      3,
      6.779385,
      0,
      1,
      3.543203,
      0.900844,
      3.929745,
      2,
      1,
      0.883822,
      0.884789,
      1.562079,
      1.432461,
      NULL,
      NULL,
      3.049632,
      11,
      1.027121,
      1.176580,
      2,
      1,
      0,
      NULL,
      2,
      2,
      1,
      1.517976,
      0,
      1,
      0.944021,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.501286,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.642839,
      NULL,
      NULL,
      1.946024,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.953138,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475818,
      NULL,
      NULL,
      NULL,
      2.636230,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.490692,
      NULL,
      NULL,
      NULL,
      1.554054,
      NULL,
      NULL,
      NULL,
      0.657195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.503774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.752676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.882377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      166.959994,
      86,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.230881,
      NULL,
      NULL,
      0.489972,
      NULL,
      NULL,
      0.218940,
      NULL,
      NULL,
      1.796590,
      24.431483,
      1.777265,
      NULL,
      0,
      0.086729,
      0.597781,
      0,
      1.541257,
      0,
      1,
      1,
      NULL,
      0.639608,
      1,
      1.079948,
      0.227369,
      NULL,
      1.955171,
      0.845972,
      1,
      NULL,
      1.401409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.986420,
      1,
      0,
      0,
      3,
      5,
      0,
      0.125835,
      1,
      0.856778,
      1.390980,
      NULL,
      0,
      1.884114,
      NULL,
      0.190847,
      1,
      NULL,
      0,
      1.018768,
      NULL,
      1.912817,
      1,
      NULL,
      1.782299,
      NULL,
      NULL,
      1.211294,
      0,
      NULL,
      0,
      0.081959,
      NULL,
      NULL,
      0,
      NULL,
      1.838229,
      1,
      NULL,
      0.390198,
      1.961313,
      NULL,
      0,
      1.293194,
      0.367202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290617,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      2.035610,
      1.315942,
      1,
      30,
      NULL,
      1,
      0.497067,
      1.547274,
      NULL,
      '',
      '',
      1.014483,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


