set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7407185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0411340',
      3,
      1,
      3,
      1,
      '0224',
      2.958172,
      2,
      4.504994,
      36,
      NULL,
      8,
      NULL,
      NULL,
      3.580675,
      0,
      ' 8-19-1989',
      19,
      1,
      221.448100,
      NULL,
      2,
      NULL,
      NULL,
      ' 8-28-1992',
      3.708668,
      1.974614,
      0.147752,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.472487,
      7.387926,
      19.681256,
      1,
      2,
      1,
      3,
      2,
      1,
      0,
      0,
      NULL,
      0,
      1.401714,
      NULL,
      0,
      4,
      0,
      1,
      0,
      3,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      4,
      0,
      1,
      NULL,
      0,
      NULL,
      0.450178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.040788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1.961600,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1.435171,
      4,
      3,
      0,
      4,
      1,
      NULL,
      0,
      4,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      4,
      4,
      3,
      NULL,
      1,
      3,
      4,
      4,
      0,
      0,
      5.335148,
      0.065561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.337668,
      2,
      NULL,
      0.949466,
      3,
      1.571895,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.250847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.934916,
      1,
      0.443412,
      0,
      NULL,
      2.568183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348292,
      1,
      3,
      2,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      3,
      0,
      3,
      3.728066,
      0,
      7,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.354757,
      0.751801,
      0,
      1,
      2,
      1.642711,
      2.472489,
      11,
      2.432000,
      2,
      5.481423,
      4.781465,
      1,
      NULL,
      2,
      1,
      1.462457,
      3,
      39,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '34000',
      '',
      '',
      3,
      '40032',
      '',
      '',
      7.313227,
      '41211',
      NULL,
      '11344',
      NULL,
      10.081773,
      NULL,
      26.003878,
      0.959166,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.901149,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840602,
      NULL,
      NULL,
      3.181997,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6.899178,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.868552,
      NULL,
      0,
      0.672248,
      NULL,
      NULL,
      1.750729,
      NULL,
      NULL,
      0.599898,
      NULL,
      NULL,
      0.133787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.405421,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.889511,
      3,
      NULL,
      0,
      0.375127,
      NULL,
      NULL,
      NULL,
      3.234573,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.743804,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325827,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910701,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.996566,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      2,
      3,
      NULL,
      0.788376,
      1,
      NULL,
      NULL,
      0.908481,
      3,
      0,
      1.588494,
      2.969524,
      3,
      3.418470,
      3.430320,
      0,
      5,
      5,
      0.895356,
      0.790431,
      3.868040,
      0.398311,
      0.351847,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275145,
      2.718744,
      3.212755,
      0,
      2,
      3.975084,
      1.831367,
      NULL,
      7,
      3.390752,
      NULL,
      2,
      0,
      0.445556,
      1.032738,
      0.469292,
      1.829375,
      NULL,
      2,
      NULL,
      NULL,
      0.423818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.298280,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.510281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.605971,
      NULL,
      3,
      0.269622,
      2,
      0.786199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.209621,
      9,
      3,
      NULL,
      0,
      1,
      1.343940,
      NULL,
      0.100850,
      2.856156,
      2,
      NULL,
      0.986994,
      1.190907,
      0,
      NULL,
      1.415715,
      NULL,
      0,
      NULL,
      2.758954,
      NULL,
      3,
      NULL,
      NULL,
      1.226048,
      0,
      NULL,
      0.482001,
      NULL,
      3,
      NULL,
      1.546288,
      NULL,
      1.387690,
      NULL,
      NULL,
      NULL,
      1.616451,
      NULL,
      NULL,
      NULL,
      2.082879,
      NULL,
      3,
      0.082355,
      0.427953,
      NULL,
      1,
      0.784562,
      2.095300,
      NULL,
      1.813485,
      3.226068,
      0,
      NULL,
      NULL,
      0,
      0.597412,
      NULL,
      1,
      1.858774,
      3.910347,
      NULL,
      2,
      2.237076,
      NULL,
      NULL,
      NULL,
      0.528650,
      7,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      75.298082,
      7,
      3,
      3.389188,
      2,
      1.619430,
      NULL,
      NULL,
      3.404356,
      113.694028,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1172,
      5,
      1,
      2.971766,
      1,
      0,
      0.300849,
      3.957911,
      0.428030,
      3.176397,
      1.006884,
      1.639955,
      0.481911,
      0,
      0,
      1,
      0.297971,
      1,
      0,
      0.946185,
      NULL,
      1.674940,
      NULL,
      1.170581,
      NULL,
      1,
      NULL,
      0.870197,
      NULL,
      NULL,
      NULL,
      26.845247,
      NULL,
      3,
      27,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.740442,
      NULL,
      0,
      NULL,
      1.422346,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.345936,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.785490,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.824220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      5,
      1.092941,
      3.503956,
      0.049098,
      NULL,
      3,
      0,
      2,
      0,
      NULL,
      0,
      1.726442,
      1,
      0.984109,
      1.451917,
      0.644841,
      3,
      2.609125,
      1,
      0.964473,
      NULL,
      NULL,
      0.687423,
      2.432953,
      1.774807,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0.127484,
      NULL,
      0,
      1.981351,
      NULL,
      0,
      2,
      1,
      0.533470,
      0,
      1.326109,
      3,
      3.911124,
      1.353670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691535,
      1.424223,
      2,
      NULL,
      1,
      1.244492,
      2.135349,
      1,
      1.539462,
      0.601794,
      2,
      0,
      2,
      1.431577,
      NULL,
      NULL,
      2.725400,
      1,
      0.677122,
      NULL,
      0.308267,
      1,
      2,
      0,
      NULL,
      1.291748,
      NULL,
      61,
      3.337916,
      NULL,
      1,
      1,
      0.777371,
      1.783279,
      0.783896,
      NULL,
      4,
      5,
      6,
      1.285812,
      1,
      3.978093,
      NULL,
      49.510013,
      5,
      0,
      0.131562,
      '43333',
      '03224',
      '',
      0.363882,
      NULL,
      '',
      '',
      3,
      '41441',
      '434',
      '01334');
commit;
end;
/


