set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.663181,
      0,
      2,
      '2442',
      3,
      0.577061,
      NULL,
      NULL,
      ' 4-21-1981',
      50.241309,
      NULL,
      3,
      2.065405,
      0.552643,
      ' 8-25-1985',
      57,
      3.578990,
      49.904833,
      63,
      2,
      ' 0-13-1979',
      NULL,
      ' 1- 2-1990',
      1,
      0,
      2,
      NULL,
      0,
      1.344671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      26,
      22,
      0,
      22,
      5,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0.181253,
      0,
      NULL,
      2,
      1,
      0,
      0,
      2,
      0,
      4,
      0,
      NULL,
      1,
      0,
      1,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      1,
      3,
      3.917204,
      0.895658,
      2.949151,
      1.165746,
      2.664181,
      1.256708,
      0.058043,
      1.078302,
      1,
      NULL,
      1.233166,
      2.370665,
      0.848060,
      0.934753,
      0,
      NULL,
      NULL,
      2,
      6,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      0,
      3,
      0,
      1,
      1,
      2,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      5,
      1.382071,
      5.104583,
      0,
      0,
      NULL,
      1,
      1,
      3,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      1,
      2,
      2,
      0,
      3,
      3.473452,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      1.001709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.382609,
      0.233586,
      1,
      1.619361,
      0.388823,
      4,
      0,
      3.290248,
      3,
      2,
      1,
      0,
      NULL,
      0.842210,
      0,
      NULL,
      6,
      2.462081,
      NULL,
      NULL,
      NULL,
      0.177708,
      5.290220,
      1.824076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598939,
      NULL,
      0,
      NULL,
      1.670973,
      0,
      25,
      0.368810,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.417654,
      1.636234,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      1.070294,
      4.598097,
      0,
      NULL,
      2.519338,
      0,
      2,
      0.547811,
      1.392977,
      NULL,
      1,
      0.760033,
      NULL,
      0,
      1.896517,
      NULL,
      0,
      NULL,
      1,
      3.549447,
      2,
      7.934325,
      5,
      6,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      3.066323,
      64.901311,
      1,
      3,
      NULL,
      NULL,
      36,
      5.304270,
      2,
      NULL,
      NULL,
      '33343',
      '13131',
      '',
      0,
      '',
      '',
      NULL,
      2.727498,
      '31220',
      '',
      '',
      0.227110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708124,
      1.534268,
      NULL,
      0.044088,
      NULL,
      NULL,
      1.560517,
      NULL,
      NULL,
      2,
      0.525581,
      NULL,
      0,
      NULL,
      NULL,
      1.995484,
      NULL,
      NULL,
      0.148684,
      NULL,
      NULL,
      13,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.893759,
      0.457178,
      NULL,
      0,
      1.845062,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.172421,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.462372,
      NULL,
      NULL,
      NULL,
      1.657944,
      NULL,
      2.740172,
      NULL,
      150.674424,
      NULL,
      NULL,
      17,
      0.353972,
      1.564148,
      1.160157,
      NULL,
      NULL,
      2,
      NULL,
      3.450330,
      NULL,
      0.583852,
      NULL,
      2.971200,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.066692,
      NULL,
      1.634468,
      NULL,
      0,
      NULL,
      1.866746,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976183,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.717939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.199841,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.529929,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      1.145655,
      0.234637,
      1.231641,
      2,
      0,
      1.057656,
      0,
      1.816802,
      0,
      NULL,
      NULL,
      NULL,
      0.301256,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.493395,
      1.186485,
      NULL,
      1,
      1,
      NULL,
      1.425492,
      1,
      NULL,
      NULL,
      0.853592,
      NULL,
      0.695504,
      0,
      NULL,
      0,
      0.411374,
      NULL,
      NULL,
      0.551904,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531549,
      NULL,
      0.184737,
      NULL,
      0.225172,
      NULL,
      1,
      NULL,
      3,
      1.559892,
      NULL,
      NULL,
      26.354133,
      120.288871,
      NULL,
      1,
      4.388675,
      '11400',
      '42022',
      NULL,
      0.840768,
      '',
      '',
      '',
      3,
      '24010',
      '',
      '');
commit;
end;
/


