set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8901642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      NULL,
      NULL,
      19.308780,
      '0422012',
      0.178995,
      1.168303,
      2,
      3,
      '3010',
      NULL,
      1.970669,
      NULL,
      NULL,
      '11-12-1988',
      NULL,
      6,
      NULL,
      1,
      NULL,
      '11-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-2000',
      NULL,
      ' 1-10-1990',
      0,
      3.511036,
      3,
      3.752456,
      3,
      0.023863,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.868992,
      1,
      1,
      1,
      1.143940,
      0,
      1,
      0.629198,
      0,
      1.545882,
      1,
      0,
      3,
      4,
      NULL,
      1,
      0,
      0,
      1,
      2,
      0,
      5,
      4,
      2,
      1,
      0,
      2,
      NULL,
      0,
      2,
      0,
      1,
      0.085392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      5,
      6.887314,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      5,
      0,
      NULL,
      2,
      0,
      1,
      0,
      5,
      0,
      3,
      2,
      4,
      5,
      5,
      NULL,
      NULL,
      1,
      1,
      3,
      5,
      0,
      ' 0- 5-1994',
      187,
      ' 0-17-1988',
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.490379,
      0.145171,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.102861,
      7,
      1.470808,
      1.010912,
      5.871571,
      0.232640,
      NULL,
      NULL,
      NULL,
      0,
      1.628458,
      1.477402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.282954,
      1.036243,
      1,
      NULL,
      0.934386,
      1,
      0,
      58.479668,
      1.441922,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0,
      1,
      3,
      0,
      0,
      NULL,
      3,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.435720,
      0.005043,
      NULL,
      NULL,
      1,
      0,
      0.096576,
      1,
      0,
      NULL,
      0,
      0.533826,
      2,
      0,
      5.426622,
      6,
      6,
      NULL,
      5.727130,
      4.839367,
      2,
      NULL,
      6.597677,
      0,
      3,
      0.273008,
      16.201103,
      3,
      1.689938,
      13,
      NULL,
      44,
      24,
      4,
      2,
      NULL,
      '44402',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1.724073,
      '',
      '',
      '',
      0.802681,
      14,
      NULL,
      26.943336,
      1.943939,
      30,
      6.116830,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.448422,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.037607,
      1.860914,
      0.097364,
      NULL,
      NULL,
      0.823836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.450172,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445337,
      NULL,
      NULL,
      NULL,
      1.963509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.726027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983050,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504173,
      NULL,
      NULL,
      0,
      NULL,
      2.333307,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      9,
      4,
      8,
      NULL,
      NULL,
      NULL,
      0.779937,
      NULL,
      NULL,
      0.014722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.644528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.824672,
      NULL,
      NULL,
      1.742710,
      NULL,
      NULL,
      0.762133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532483,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.493856,
      NULL,
      1.943420,
      0,
      NULL,
      NULL,
      5.177226,
      NULL,
      NULL,
      1,
      1.283360,
      NULL,
      1.258826,
      NULL,
      NULL,
      0,
      1.493635,
      3.414984,
      3.643036,
      1.800235,
      3,
      NULL,
      0,
      NULL,
      4,
      3,
      2,
      2.050814,
      2,
      NULL,
      1.741460,
      0,
      1.827673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.027941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242303,
      NULL,
      NULL,
      0.457958,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.407216,
      3.949695,
      1.369860,
      0,
      0.276440,
      NULL,
      3,
      NULL,
      NULL,
      0.518682,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.243328,
      0,
      NULL,
      NULL,
      NULL,
      1.476137,
      NULL,
      NULL,
      0.072406,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.979116,
      NULL,
      NULL,
      1.652138,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445054,
      NULL,
      NULL,
      0.318622,
      2.136263,
      NULL,
      NULL,
      0.106450,
      NULL,
      NULL,
      NULL,
      1,
      6.872970,
      NULL,
      NULL,
      0,
      3.860772,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      2,
      0.117187,
      NULL,
      NULL,
      NULL,
      1.190836,
      NULL,
      NULL,
      3.723104,
      0,
      NULL,
      NULL,
      0,
      0.484331,
      0.181147,
      NULL,
      1.995426,
      154,
      NULL,
      0.248957,
      NULL,
      1,
      1.056845,
      1,
      0.850151,
      1,
      1.317577,
      NULL,
      1.865962,
      0,
      0.982550,
      NULL,
      0.043120,
      1,
      1,
      0,
      0.795414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.526211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740188,
      1.790946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.742010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.483457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      11.036483,
      2.015168,
      1,
      4.395262,
      2,
      2,
      0,
      1.815595,
      0.953266,
      0.914900,
      0.429906,
      1,
      0,
      NULL,
      1.355130,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.484656,
      NULL,
      NULL,
      0,
      1.956917,
      NULL,
      0,
      1,
      1,
      0,
      3.102015,
      0,
      1.935192,
      3,
      2,
      2,
      1.503290,
      1,
      2.470972,
      0.425624,
      1.370374,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.775394,
      0,
      0.728070,
      2.100066,
      1.564025,
      NULL,
      3.522720,
      NULL,
      2,
      2.972280,
      1.726868,
      1.478972,
      NULL,
      1,
      3,
      NULL,
      1.236046,
      0.481867,
      0,
      NULL,
      0.600884,
      1.585519,
      1.777631,
      1.242821,
      0.183704,
      NULL,
      1,
      NULL,
      1.804383,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      1,
      1,
      NULL,
      NULL,
      63,
      NULL,
      0.259398,
      NULL,
      '12043',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0.883951,
      '',
      '',
      '');
commit;
end;
/


