set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      6,
      NULL,
      3,
      2.242935,
      2,
      2.631416,
      0,
      NULL,
      '14440242',
      14.696976,
      55,
      '2222013',
      0,
      0.175209,
      6,
      NULL,
      '1230',
      5,
      1,
      NULL,
      NULL,
      ' 4-10-1990',
      NULL,
      64,
      NULL,
      NULL,
      1,
      ' 9-16-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 0-1991',
      2,
      1,
      3.010517,
      3,
      1.930653,
      0.328664,
      3,
      1,
      1,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.886751,
      2,
      NULL,
      NULL,
      0.850964,
      1,
      1,
      NULL,
      0,
      0.515428,
      0,
      0,
      4,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      5,
      0,
      3,
      0,
      1,
      0,
      4,
      0,
      6,
      1,
      2,
      1,
      0,
      0.460917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.461690,
      0.151845,
      0.465391,
      0.238174,
      NULL,
      NULL,
      0,
      NULL,
      0.256493,
      0,
      0.407467,
      0,
      3,
      0,
      NULL,
      1,
      2,
      3,
      NULL,
      1.221974,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563696,
      NULL,
      NULL,
      3,
      4,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      2,
      0,
      0,
      NULL,
      7,
      0,
      0,
      0,
      1,
      NULL,
      1.333090,
      4.663133,
      3,
      NULL,
      1,
      NULL,
      1,
      4,
      NULL,
      0,
      1,
      1,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      5,
      0,
      4,
      NULL,
      3,
      0,
      NULL,
      0,
      5,
      NULL,
      '11-13-1995',
      52.571835,
      ' 2-12-1999',
      NULL,
      0,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      0.160613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      0.409934,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.045709,
      1,
      NULL,
      NULL,
      NULL,
      0.220124,
      0.714431,
      9.558206,
      2.853456,
      7.764397,
      3.755208,
      3,
      0,
      NULL,
      NULL,
      0.042054,
      13,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.555934,
      1.213283,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      NULL,
      0.041138,
      2,
      1,
      0,
      1,
      1,
      0,
      0.685242,
      NULL,
      NULL,
      1.070273,
      NULL,
      1.135722,
      NULL,
      1.283297,
      0,
      3.444313,
      NULL,
      0,
      8,
      NULL,
      5,
      9.773719,
      9,
      5.991018,
      NULL,
      3,
      3,
      2.916459,
      0.588807,
      2.953363,
      55,
      2,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7.057712,
      NULL,
      '20420',
      '0010',
      1.554078,
      NULL,
      '',
      '',
      3.053483,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837564,
      1,
      0.058341,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.870208,
      0,
      NULL,
      NULL,
      NULL,
      2.487876,
      NULL,
      1,
      1.583295,
      NULL,
      NULL,
      0.507869,
      NULL,
      NULL,
      2.316726,
      NULL,
      0,
      2.488429,
      2,
      NULL,
      2.360696,
      3.378656,
      NULL,
      2,
      0.236162,
      1.186213,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.108541,
      1,
      0.709612,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1.171116,
      0.899592,
      2,
      1,
      NULL,
      NULL,
      0,
      3.232751,
      0.515194,
      0.425538,
      NULL,
      1.901278,
      0.787036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.108018,
      3.714576,
      1,
      1,
      0.439062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216125,
      NULL,
      NULL,
      2,
      NULL,
      3.680653,
      0.741916,
      2,
      3.841921,
      1.089544,
      NULL,
      NULL,
      4.678628,
      4,
      4.483957,
      NULL,
      0,
      0.383610,
      0.479744,
      NULL,
      NULL,
      0,
      3.102953,
      2,
      1.307290,
      NULL,
      NULL,
      1.596567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970680,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.977107,
      NULL,
      NULL,
      1,
      0.455374,
      0.858197,
      0.670805,
      NULL,
      NULL,
      2.730538,
      5.687237,
      3,
      2.287493,
      1.538715,
      NULL,
      1.624258,
      NULL,
      2.794460,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2.556938,
      2.773318,
      5,
      7.171370,
      9.112329,
      2.668465,
      3.998271,
      1.381251,
      3.445811,
      2,
      NULL,
      3.619044,
      0,
      1,
      2.813817,
      3.919303,
      0.557614,
      4,
      8.968149,
      8,
      NULL,
      5,
      2,
      NULL,
      1,
      0,
      1.031475,
      0,
      1.620277,
      0.805626,
      1.058326,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1.414573,
      0,
      0,
      1,
      NULL,
      0,
      0.908149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.207948,
      NULL,
      NULL,
      NULL,
      1.299202,
      NULL,
      NULL,
      NULL,
      2.321425,
      NULL,
      NULL,
      NULL,
      0.985934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.234844,
      NULL,
      NULL,
      NULL,
      3.977955,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2,
      NULL,
      3.767382,
      0.375871,
      3.133162,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.261458,
      1.566289,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.871725,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601846,
      1.313630,
      1.590209,
      3,
      0.736601,
      0,
      0.187887,
      1.812835,
      0.894520,
      0,
      1,
      0.247094,
      0.707991,
      NULL,
      0,
      1.989665,
      1,
      0,
      NULL,
      3.502837,
      NULL,
      0.775998,
      NULL,
      1.030369,
      NULL,
      1.659115,
      NULL,
      3,
      NULL,
      37.415314,
      NULL,
      0.316220,
      6.672392,
      28,
      0.528062,
      0.512115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.660989,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.249982,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.851031,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855693,
      NULL,
      0,
      NULL,
      132,
      2,
      3,
      NULL,
      0.513097,
      NULL,
      NULL,
      1.091171,
      3,
      29.136809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.014866,
      0,
      1.402001,
      NULL,
      0.609500,
      3.277806,
      2,
      NULL,
      0,
      1,
      0.597101,
      NULL,
      1,
      1,
      0,
      0.972233,
      1.801635,
      1.319485,
      3,
      NULL,
      2.903063,
      0.375690,
      3.357653,
      1,
      1.393333,
      NULL,
      0.054958,
      NULL,
      0.031592,
      2,
      2.475028,
      NULL,
      0,
      0,
      0.147896,
      2,
      0.835701,
      NULL,
      0.899360,
      1.570234,
      0.478568,
      2.134309,
      0,
      1.447027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      3.281088,
      0,
      2.279142,
      1,
      3.841396,
      2.241115,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      3,
      0,
      0.736407,
      NULL,
      1,
      NULL,
      0.019938,
      NULL,
      0,
      2,
      0.227336,
      1,
      2.977551,
      NULL,
      1,
      1,
      0.907527,
      3,
      1.813518,
      0.753480,
      4,
      4,
      3,
      1.733709,
      1,
      2,
      NULL,
      67,
      5,
      2.005634,
      2.169305,
      '41024',
      '33112',
      NULL,
      1.202123,
      '',
      '',
      '',
      0.050722,
      '4414',
      '',
      NULL);
commit;
end;
/


