set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332012';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      3.777603,
      0.721344,
      1,
      0,
      '1040',
      2,
      1,
      NULL,
      NULL,
      NULL,
      132,
      NULL,
      3,
      0,
      1.767530,
      ' 5-19-1999',
      NULL,
      NULL,
      114,
      94,
      0,
      NULL,
      '11-25-1989',
      ' 8- 0-1995',
      3.868364,
      2.536044,
      0,
      0,
      0,
      0,
      0,
      1.695117,
      0.086003,
      54,
      6,
      17,
      NULL,
      NULL,
      2.693613,
      3,
      3.189021,
      5,
      4,
      7.662521,
      0.828468,
      0,
      0,
      0,
      0.589555,
      0,
      NULL,
      0.327140,
      NULL,
      0.520401,
      1.973556,
      3,
      0,
      6,
      0,
      4,
      NULL,
      1,
      4,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1.436375,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.868804,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      1,
      0.405802,
      1,
      0,
      1,
      3.777105,
      1.198693,
      0.102168,
      3,
      0,
      2.660379,
      0.575210,
      1.328622,
      0.630552,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0.771702,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      4,
      1,
      1,
      1,
      0,
      1,
      0,
      3,
      2,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      0.897170,
      2.425950,
      ' 3- 2-1986',
      346,
      ' 1- 8-1995',
      968,
      2,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073056,
      3,
      6.325033,
      3.546381,
      1.164758,
      0.364589,
      5.075472,
      1,
      1.250930,
      2,
      0.419715,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.881694,
      0.928555,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      19,
      NULL,
      3.425809,
      52.006455,
      76,
      NULL,
      2,
      NULL,
      0.567453,
      2,
      0,
      1,
      3,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      3,
      2,
      3,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1.723227,
      1.192722,
      0,
      0.295312,
      1,
      0,
      1.584291,
      2,
      0.893767,
      NULL,
      7.079847,
      6.551978,
      5,
      8.743976,
      5,
      3.013425,
      0.792320,
      4.901338,
      3.058501,
      1.802572,
      NULL,
      11,
      1,
      2.866100,
      NULL,
      41,
      NULL,
      34,
      4,
      0.148685,
      3,
      '12211',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.671853,
      '',
      NULL,
      '',
      3.348780,
      16.798840,
      NULL,
      16.367913,
      3,
      9,
      183.686324,
      NULL,
      NULL,
      0.465391,
      3,
      3.545162,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.516497,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.360425,
      NULL,
      NULL,
      0.219531,
      NULL,
      NULL,
      0.267323,
      NULL,
      NULL,
      1.189211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.771242,
      5.876305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891150,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529340,
      1.210245,
      0.413104,
      NULL,
      1,
      1,
      0,
      0.806016,
      1.009933,
      3,
      NULL,
      1.708144,
      1.791221,
      1.114723,
      0,
      NULL,
      0.403249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.631945,
      6.793948,
      5,
      0.745009,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.174738,
      1.078037,
      3,
      NULL,
      1,
      0,
      0,
      2.600612,
      0.818459,
      NULL,
      NULL,
      10,
      7.303892,
      6,
      1.100564,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.991130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.650110,
      NULL,
      NULL,
      0.315019,
      NULL,
      NULL,
      1.317909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961528,
      NULL,
      NULL,
      1.760089,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.286854,
      NULL,
      NULL,
      1.551074,
      1,
      NULL,
      0.232019,
      NULL,
      NULL,
      NULL,
      5,
      5.385422,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      0,
      0,
      4,
      1,
      7,
      0,
      NULL,
      NULL,
      3,
      3,
      0,
      1.480732,
      0,
      1.512461,
      1,
      0,
      0.412712,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692785,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.449653,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.935840,
      0.153195,
      1,
      1,
      1.214206,
      0,
      1,
      NULL,
      NULL,
      0.391243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701726,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.071416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.641644,
      NULL,
      NULL,
      NULL,
      2.985674,
      18,
      2,
      NULL,
      2,
      NULL,
      377.476945,
      0,
      5.267337,
      2.776728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      7.499552,
      NULL,
      NULL,
      NULL,
      1.904097,
      NULL,
      0.465901,
      NULL,
      38,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.050804,
      0,
      1,
      0.699915,
      0.626127,
      1,
      1,
      0,
      0,
      0,
      0.561104,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.760619,
      0.623699,
      2,
      2,
      0,
      18,
      NULL,
      1.302202,
      1.004221,
      0,
      0,
      NULL,
      1.510944,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.785536,
      NULL,
      0.531575,
      3,
      NULL,
      0.358599,
      0.187819,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.074745,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.062871,
      1.228704,
      1.173256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361218,
      NULL,
      1.684784,
      NULL,
      0,
      NULL,
      4,
      3,
      NULL,
      0,
      NULL,
      2.893687,
      2,
      NULL,
      4,
      0,
      2.434307,
      '41233',
      '',
      '',
      1.573307,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


