set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834206';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '4010341',
      3.783184,
      1,
      1,
      0,
      '4211',
      1,
      0,
      NULL,
      NULL,
      ' 1- 3-1990',
      14,
      NULL,
      5,
      2,
      1,
      ' 7- 7-1976',
      NULL,
      0.431228,
      155.955840,
      150,
      2,
      ' 6- 3-2003',
      ' 5-16-1996',
      NULL,
      2,
      1,
      2.124504,
      0.312118,
      1.090353,
      NULL,
      2,
      0,
      0.233832,
      9,
      7,
      0.475448,
      5.042178,
      NULL,
      22,
      4,
      22.932190,
      0,
      5,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      2.750637,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.160814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.255878,
      NULL,
      1.704473,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      3,
      0,
      1,
      5,
      4,
      NULL,
      5,
      1,
      NULL,
      1,
      2,
      2,
      3,
      2,
      2,
      1,
      6,
      3,
      ' 0- 0-1999',
      117,
      '11- 2-1995',
      19,
      0,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.291184,
      NULL,
      0.655448,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.996740,
      3.428705,
      1.517854,
      1.276544,
      0.431022,
      0.443393,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150703,
      2,
      1.122691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.473465,
      1.464214,
      0.073477,
      1.393264,
      1.034955,
      1,
      NULL,
      14.448245,
      1,
      1.666566,
      NULL,
      NULL,
      NULL,
      0,
      1.881588,
      0,
      2,
      1,
      3,
      1,
      2,
      2,
      3,
      2,
      3,
      2,
      7,
      NULL,
      1.911311,
      2.644488,
      2.895253,
      NULL,
      5.364735,
      0.971263,
      0.570501,
      0,
      1,
      1,
      1.982767,
      1.239447,
      0,
      0,
      0,
      4,
      0.242215,
      3,
      5.015738,
      1,
      NULL,
      5.628725,
      4,
      0,
      3.199993,
      7.812230,
      NULL,
      NULL,
      2,
      50,
      0,
      NULL,
      NULL,
      6,
      NULL,
      19,
      1,
      0,
      1,
      NULL,
      '',
      '',
      1.195125,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      2,
      34.967266,
      4.244283,
      14,
      0.337415,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.902703,
      NULL,
      NULL,
      0.830416,
      NULL,
      NULL,
      0.727424,
      NULL,
      NULL,
      3.984704,
      19.447645,
      14,
      1,
      NULL,
      NULL,
      1.237134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      13.620634,
      12,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.929209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.610350,
      1,
      1.132439,
      NULL,
      NULL,
      0.342223,
      NULL,
      NULL,
      7.092115,
      1.027058,
      1.334088,
      0,
      NULL,
      NULL,
      1.159926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.598911,
      NULL,
      NULL,
      0.704485,
      NULL,
      NULL,
      1.300014,
      NULL,
      NULL,
      0.375854,
      NULL,
      NULL,
      0.177901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.143694,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.598201,
      NULL,
      NULL,
      0.954729,
      NULL,
      NULL,
      0.644211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.905424,
      0,
      NULL,
      0.949278,
      1,
      3,
      NULL,
      0,
      3,
      2,
      NULL,
      0,
      3.186775,
      8.453114,
      1.516353,
      1,
      NULL,
      NULL,
      0.335460,
      NULL,
      4,
      0.263677,
      0,
      0,
      NULL,
      NULL,
      2.466594,
      NULL,
      NULL,
      0.922410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186957,
      NULL,
      NULL,
      0.559289,
      NULL,
      NULL,
      1.098273,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.245450,
      NULL,
      NULL,
      1.789910,
      NULL,
      NULL,
      0.109739,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.664645,
      0.023038,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.106780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412315,
      0.863101,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463151,
      NULL,
      NULL,
      0.614837,
      0.072209,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564612,
      NULL,
      NULL,
      NULL,
      0.493652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.034910,
      NULL,
      0.156264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064587,
      NULL,
      NULL,
      0.220884,
      NULL,
      NULL,
      1.432260,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853555,
      10022,
      NULL,
      1.400258,
      0.777912,
      1.541316,
      0,
      NULL,
      0.188377,
      0.662278,
      1.951020,
      1,
      1.368847,
      0,
      0,
      0,
      NULL,
      1,
      0.844618,
      1,
      3,
      NULL,
      1.591114,
      NULL,
      0,
      NULL,
      0.277565,
      NULL,
      3.183997,
      NULL,
      0,
      NULL,
      11.547050,
      NULL,
      NULL,
      38,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.523289,
      NULL,
      NULL,
      NULL,
      1.883973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174983,
      NULL,
      1.970412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.598295,
      NULL,
      1.058620,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      2.895438,
      0.210078,
      3.943948,
      1.135107,
      NULL,
      2,
      NULL,
      0,
      1,
      1.229489,
      0,
      1.261247,
      0.180726,
      1,
      1.966018,
      0.513563,
      1.517904,
      1.625541,
      0,
      0.723463,
      0,
      1.181139,
      0,
      0,
      NULL,
      1.448302,
      0.451311,
      1.186731,
      1,
      0.174073,
      0.315074,
      0,
      1.460789,
      0.494447,
      NULL,
      1,
      1,
      1.795781,
      1.631672,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812468,
      2.707710,
      3.602221,
      0.740826,
      NULL,
      0.266298,
      1.511505,
      0,
      0.984700,
      NULL,
      1.026524,
      NULL,
      0,
      2.509184,
      3,
      NULL,
      1,
      1.580855,
      NULL,
      0.089217,
      0,
      1,
      NULL,
      0,
      1.720026,
      1.801407,
      1.903675,
      0.110144,
      1.783208,
      1406.253777,
      0.176559,
      0.237932,
      1.873398,
      1.594039,
      0.818876,
      NULL,
      2,
      0,
      5,
      0.698209,
      NULL,
      NULL,
      65.762802,
      71.561450,
      3,
      0.190448,
      2.466994,
      '00021',
      '11441',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


