set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834206';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0122232',
      1.515068,
      0.581883,
      1,
      2,
      '4132',
      3,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1991',
      20,
      NULL,
      NULL,
      1.460407,
      NULL,
      ' 2-12-1998',
      17.247690,
      NULL,
      168.533471,
      79,
      3,
      NULL,
      '11-17-1993',
      NULL,
      0.338298,
      NULL,
      0.336759,
      NULL,
      1,
      1.374547,
      NULL,
      0,
      1.539402,
      2,
      7,
      16,
      5.281223,
      20,
      5.698704,
      3,
      16,
      5,
      NULL,
      1.265229,
      0.445713,
      3,
      0,
      1,
      1.052986,
      1,
      1.631215,
      3.790463,
      0.152465,
      NULL,
      0,
      3,
      0,
      1,
      2,
      5,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.427466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0.892095,
      NULL,
      0.854176,
      2,
      4,
      5,
      0,
      1,
      5,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      2,
      4,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      1,
      1.305087,
      NULL,
      192.588408,
      ' 8- 6-1991',
      12,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0.226616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485097,
      1,
      2.067737,
      5,
      2.017540,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.950147,
      0,
      0.767356,
      0,
      0.408963,
      2,
      194.432600,
      1.422568,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.284296,
      NULL,
      3,
      2,
      0,
      3,
      NULL,
      2,
      2,
      3,
      1,
      NULL,
      0.928886,
      1,
      3,
      0.654053,
      NULL,
      0,
      1.173831,
      NULL,
      1,
      1.595369,
      0.936620,
      0,
      1,
      0,
      0,
      0,
      1.355430,
      0.148293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      41,
      2,
      0.736585,
      1,
      NULL,
      '',
      NULL,
      1.979063,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.807710,
      19,
      85.810509,
      10,
      2,
      NULL,
      1,
      8,
      NULL,
      1,
      3,
      1.654257,
      1,
      NULL,
      NULL,
      3.469622,
      NULL,
      7,
      NULL,
      2.423926,
      1.010683,
      1.342453,
      1.934304,
      0.812275,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.669282,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      0.299297,
      1,
      0.074449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692512,
      NULL,
      NULL,
      0.666660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.647229,
      0,
      2,
      0.889030,
      1,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.924501,
      1,
      2,
      1,
      1.164258,
      2.275772,
      6.943040,
      0.585331,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.748837,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.825166,
      NULL,
      NULL,
      0.537843,
      2.229567,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2.814001,
      7.349387,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.664291,
      3.588552,
      2.822514,
      0.914564,
      NULL,
      2.208619,
      4,
      1.803240,
      5,
      0.605118,
      0,
      0,
      6,
      NULL,
      NULL,
      2,
      3.505455,
      NULL,
      0,
      NULL,
      3.444797,
      4.733988,
      6,
      4.366302,
      2,
      NULL,
      1,
      3.266973,
      2,
      3,
      NULL,
      0,
      0,
      1.942948,
      0,
      0.864670,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.047465,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.047377,
      1,
      2.564616,
      1,
      NULL,
      NULL,
      NULL,
      1.082498,
      NULL,
      NULL,
      346,
      636,
      NULL,
      NULL,
      0,
      0.019396,
      NULL,
      NULL,
      0,
      0.112037,
      NULL,
      NULL,
      1.361630,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.871071,
      NULL,
      NULL,
      10,
      0.105407,
      NULL,
      NULL,
      14,
      0.059887,
      NULL,
      NULL,
      1,
      1.883072,
      NULL,
      NULL,
      NULL,
      0.432557,
      NULL,
      NULL,
      1.287194,
      NULL,
      NULL,
      NULL,
      2.372669,
      NULL,
      NULL,
      NULL,
      1.288779,
      3,
      NULL,
      NULL,
      18,
      2.300274,
      NULL,
      NULL,
      1.593513,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      6.009189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185265,
      16,
      NULL,
      1.846502,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.536318,
      NULL,
      NULL,
      0.095064,
      NULL,
      NULL,
      1.619260,
      NULL,
      NULL,
      1.127969,
      NULL,
      0.135139,
      15997,
      NULL,
      0.241905,
      0.202402,
      NULL,
      0.460627,
      0.732806,
      1.119998,
      1.661141,
      0,
      1.030775,
      NULL,
      1.954347,
      0.395841,
      1,
      1.453358,
      NULL,
      1,
      1.213242,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      1.120416,
      2,
      1,
      2,
      7.684760,
      0.205616,
      0.011577,
      3,
      1,
      1.258860,
      0.233794,
      0.497256,
      NULL,
      NULL,
      NULL,
      0.780971,
      2,
      0.760566,
      15,
      14,
      0,
      1,
      1,
      0.589792,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.970617,
      3.479200,
      0.477033,
      NULL,
      NULL,
      0.767432,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.692013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.742333,
      1,
      NULL,
      3.684419,
      NULL,
      0.115931,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.299647,
      NULL,
      1,
      NULL,
      1.874644,
      NULL,
      2.499479,
      NULL,
      3.474315,
      NULL,
      NULL,
      NULL,
      0.186262,
      158,
      1.062610,
      NULL,
      0.146396,
      NULL,
      1.144326,
      1,
      0,
      1.341301,
      1,
      4,
      NULL,
      0.872726,
      NULL,
      NULL,
      91.411190,
      NULL,
      NULL,
      1,
      NULL,
      '14311',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.581591,
      '',
      '',
      '');
commit;
end;
/


