set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834206';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      1.422010,
      1,
      4,
      0,
      '0122',
      0.177168,
      0,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      4,
      3,
      0.686491,
      ' 8-14-1985',
      4.300137,
      1.365339,
      140,
      82.107765,
      NULL,
      ' 9-25-1993',
      ' 8- 8-1988',
      ' 1-28-1980',
      2.847877,
      1.458431,
      3.834109,
      1.843045,
      0,
      3,
      0,
      0.756196,
      NULL,
      3.460113,
      1,
      NULL,
      3,
      14.740663,
      12,
      2,
      15.747928,
      NULL,
      2,
      7,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      3,
      5,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      2,
      NULL,
      0,
      1,
      1,
      0,
      0.889542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.635757,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      4,
      2,
      NULL,
      1,
      0,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3,
      5,
      5,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      2,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0.380778,
      NULL,
      40,
      ' 7-28-1993',
      23.794685,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.871209,
      1.774892,
      1.077358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      6,
      6,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956558,
      0.048958,
      NULL,
      0,
      0,
      0,
      0.695015,
      0.946442,
      5,
      0.608050,
      0.612617,
      NULL,
      NULL,
      NULL,
      0,
      0.457710,
      1.545518,
      0,
      0,
      3,
      1,
      3,
      NULL,
      0,
      NULL,
      3,
      3,
      4.600336,
      2,
      1,
      NULL,
      1,
      0.401703,
      4.733735,
      0,
      0.220647,
      0.107852,
      0,
      1.199478,
      1.523783,
      0,
      1,
      0,
      0,
      3,
      0.752427,
      2.579196,
      2,
      NULL,
      11,
      10.840413,
      3,
      2,
      0,
      3,
      NULL,
      NULL,
      2.853544,
      67.883889,
      0,
      0.812222,
      NULL,
      16,
      23,
      54.564167,
      NULL,
      NULL,
      2,
      '24213',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.102048,
      '',
      '',
      '',
      0.518974,
      41,
      36.016990,
      0,
      0.893352,
      23,
      2,
      3,
      2,
      2.441927,
      1.571506,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2.038617,
      3.570634,
      NULL,
      NULL,
      3,
      1.450593,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.324911,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323804,
      1.274575,
      7.536010,
      0,
      NULL,
      NULL,
      2,
      6.785125,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.163499,
      12,
      1,
      NULL,
      NULL,
      1.770478,
      1.915516,
      0.218947,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772469,
      NULL,
      NULL,
      0.025515,
      3,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.911233,
      0.603338,
      0.850905,
      1,
      4.953335,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793575,
      NULL,
      NULL,
      1.860875,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.394256,
      NULL,
      NULL,
      1.511937,
      1,
      2.505487,
      1.831063,
      1.303919,
      1.220200,
      NULL,
      3.740191,
      4.374638,
      NULL,
      NULL,
      NULL,
      2.553841,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.847244,
      2.346617,
      3.677154,
      1.132734,
      0.711306,
      1,
      5,
      3,
      5.265004,
      2.243928,
      1.729596,
      1,
      NULL,
      0,
      1,
      1.731999,
      1.475782,
      3.442614,
      NULL,
      0.150427,
      1,
      5,
      2,
      NULL,
      6,
      3,
      0.525622,
      0.002724,
      2,
      2,
      0,
      0.366862,
      NULL,
      0.558326,
      1,
      1.442477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.528466,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.143766,
      NULL,
      NULL,
      5.167314,
      NULL,
      NULL,
      0,
      1.137015,
      0,
      0,
      0.508437,
      2.888338,
      2,
      NULL,
      NULL,
      4,
      0.469040,
      NULL,
      NULL,
      13,
      0.638697,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.883061,
      NULL,
      NULL,
      NULL,
      2.481854,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.804539,
      0.671866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      1.675185,
      NULL,
      NULL,
      0,
      0.246494,
      NULL,
      NULL,
      1,
      3.202467,
      NULL,
      NULL,
      3,
      1.950796,
      NULL,
      NULL,
      7,
      1.078481,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      19,
      3,
      NULL,
      NULL,
      4.683166,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.205319,
      16.626685,
      11.471529,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.698553,
      NULL,
      NULL,
      1.937254,
      NULL,
      1,
      5400.873625,
      620.325970,
      0.389620,
      1.811030,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.581010,
      1.604246,
      0,
      1,
      0.830230,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475518,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      5.359495,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681752,
      NULL,
      NULL,
      NULL,
      0.049554,
      NULL,
      0.265549,
      NULL,
      1.634479,
      NULL,
      NULL,
      NULL,
      0.103412,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.993642,
      NULL,
      0.472405,
      NULL,
      0,
      NULL,
      0.031936,
      NULL,
      1,
      1.428805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1.890185,
      1.911666,
      2.005061,
      3.631853,
      0,
      4.178562,
      NULL,
      NULL,
      1,
      1,
      0,
      0.027220,
      1.595218,
      NULL,
      1,
      1.414539,
      0,
      0,
      1.514979,
      2,
      19,
      0.752681,
      1,
      1,
      0,
      0.948225,
      2,
      1,
      0,
      0.293111,
      1,
      1.583809,
      2,
      0,
      3,
      0.647360,
      1.343543,
      1.733393,
      2.015809,
      NULL,
      0,
      0,
      0.611872,
      3.618178,
      1.310468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      0.219775,
      2,
      NULL,
      NULL,
      NULL,
      3.224236,
      NULL,
      NULL,
      NULL,
      1,
      2.091181,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.796187,
      1,
      0,
      0,
      0.211859,
      0.654209,
      0.725176,
      0.430980,
      1,
      NULL,
      397,
      1.292599,
      1.234724,
      0.922637,
      NULL,
      0.991490,
      1.065479,
      4,
      NULL,
      2,
      1,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1,
      3.241332,
      '32130',
      '04002',
      '',
      1.975927,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


