
--Add cashup
create or replace procedure cashup(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('cashup', 'cashup', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'CU79', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:CIRCUMSTANTIAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU78', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:ILLOGICALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU75', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:DERAILMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU35', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:DURING DEPRESSION');

add_assessment_score(v_id1, owner_id, owner_id, 'CU77', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:INCOHERENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU76', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:TANGENTIALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU71', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP BIZARRE BEH:SOCIAL&''||''SEXUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU70', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP BIZARRE BEH:CLOTHING&''||''APPEARANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU73', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP BIZARRE BEH:RITUALISTIC');

add_assessment_score(v_id1, owner_id, owner_id, 'CU72', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP BIZARRE BEH:AGGRESSIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU225', 237, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES TOLERANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU236', 248, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE USE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU232', 244, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS CURRENTLY ABUSES?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU253', 265, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:PCP USE PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU254', 266, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:PCP IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU255', 267, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:PCP DURATION OF IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU256', 268, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:PCP CURRENTLY ABUSES?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU237', 249, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE USE PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU258', 270, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:HALLUCINOGENS USE PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU259', 271, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:HALLUCINOGENS IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU234', 246, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS WITHDRAWAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU83', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU168', 180, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DYSPHORIC MO0D>3');

add_assessment_score(v_id1, owner_id, owner_id, 'CU169', 181, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE TOTAL NO. OF SX');

add_assessment_score(v_id1, owner_id, owner_id, 'CU166', 178, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE NO. OF ATTEMPTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU167', 179, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE SUICIDAL INTENT');
add_assessment_code(v_id1, owner_id, owner_id, 'CU167', 0, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU167', 1, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU167', 2, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU164', 176, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DEATH/SUICIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU165', 177, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE SUICIDE ATTEMPT?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU162', 174, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE WORTHLESSNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU163', 175, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE CONCENTRATE');
add_assessment_code(v_id1, owner_id, owner_id, 'CU163', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU163', 1, 'Some', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU163', 2, 'Definate', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU160', 172, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE LOSS OF PLEASURE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU161', 173, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE LOSS OF ENERGY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU230', 242, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FOLLOW-UP PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CU231', 243, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS DUR. OF IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU278', 290, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP NUMBER OF AXIS III DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU272', 284, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS I DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CU273', 285, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS I DIAGNOSES-3');
add_assessment_code(v_id1, owner_id, owner_id, 'CU273', 0, 'ERROR', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'CU273', 1, 'Worse in the Morning', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'CU273', 2, 'Worse in the Evening', 'varchar');
add_assessment_code(v_id1, owner_id, owner_id, 'CU273', 3, 'No Difference', 'varchar');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4A', 295, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV PRIMARY SUPPORT PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU250', 262, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES WITHDRAWAL');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FIRST ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU224', 236, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES CURRENT ABUSE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU159', 171, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE PSYCHOMOTOR RET');

add_assessment_score(v_id1, owner_id, owner_id, 'CU158', 170, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE PSYCHOMOTOR AGIT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU221', 233, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES USE PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU220', 232, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES USE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU223', 235, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES DUR IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU222', 234, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU153', 165, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE INCREASED SLEEP');

add_assessment_score(v_id1, owner_id, owner_id, 'CU152', 164, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE IN/HYPERSOMNIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CU151', 163, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE WT +/- IN KG.');

add_assessment_score(v_id1, owner_id, owner_id, 'CU150', 162, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE SX:DECR WEIGHT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU157', 169, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE INSOMNIA:TERM');

add_assessment_score(v_id1, owner_id, owner_id, 'CU156', 168, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE INSOMNIA:MIDDLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU155', 167, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE INSOMNIA:INITIAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU154', 166, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DECREASED SLEEP');

add_assessment_score(v_id1, owner_id, owner_id, 'CU266', 278, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:MARIJUANA CURRENTLY ABUSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU27', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU203', 215, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:CURRENT ABUSE?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU19', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:RELIGIOUS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU18', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:GRANDIOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU74', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP BIZARRE BEH:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU13', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:RECORDS FROM OTHER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU12', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:RESEARCH NOTES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU11', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:HOSPITAL RECORDS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU10', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:PHONE RELATIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU17', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:SIN OR GUILT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU16', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:JEALOUSY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU15', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:PERSECUTORY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU14', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:OTHER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU144', 156, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE NATURE:DYSPHORIC');

add_assessment_score(v_id1, owner_id, owner_id, 'CU145', 157, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE NATURE:ANXIOUS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU146', 158, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE SX:APP/WT CHANGE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU147', 159, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE SX:INCR APPETITE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU140', 152, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYNDROME:ORGANIC FACTORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU141', 153, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DYSPHORIC MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CU142', 154, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DURATION:DAYS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU143', 155, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DURATION:WEEKS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU275', 287, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS II DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CU21', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:REFERENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU148', 160, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE SX:INCR WEIGHT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU149', 161, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE SX:DECR APPETITE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU282', 294, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP RELIABILITY &''||'' COMPLETENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU80', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:SPEECH PRESSURE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU81', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:SPEECH DISTRACT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CU82', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE THOUGHT:CLANGING');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SECOND ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU84', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CATATONIC MOTOR:STUPOR');

add_assessment_score(v_id1, owner_id, owner_id, 'CU85', 97, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CATATONIC MOTOR:RIGIDITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU86', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CATATONIC MOTOR:WAXY FLEXIBILITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU87', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CATATONIC MOTOR:EXCITEMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU88', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CATATONIC MOTOR:POSTURING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU89', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CATATONIC MOTOR:TD INVOLVED');

add_assessment_score(v_id1, owner_id, owner_id, 'CU238', 250, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU239', 251, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE DUR. OF IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU26', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:THOUGHT WITHDRAWAL');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 8, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU24', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:THOUGHT BROADCASTING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU25', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:THOUGHT INSERTION');

add_assessment_score(v_id1, owner_id, owner_id, 'CU22', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:BEING CONTROLLED');

add_assessment_score(v_id1, owner_id, owner_id, 'CU23', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:MIND READING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU20', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:SOMATIC');

add_assessment_score(v_id1, owner_id, owner_id, 'CU123', 135, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC DURATION:DAYS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU209', 221, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:HYPERACTIVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU201', 213, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:ARGUMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU269', 281, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CRITERIA USED FOR DIAGNOSES?');
add_assessment_code(v_id1, owner_id, owner_id, 'CU269', 0, 'DSM-III', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU269', 1, 'DSM-III-R', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU269', 2, 'DSM-IV', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU120', 132, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ROLE OF ORGANIC FACTORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU28', 40, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:SENSORIUM');
add_assessment_code(v_id1, owner_id, owner_id, 'CU28', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU28', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU28', 2, 'Definite Physical', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU28', 3, 'Definite Not Physical', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU29', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:PERSISTENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU229', 241, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS USE PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU121', 133, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CURRENT SYMPTOM FACTORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU126', 138, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC NATURE OF MOOD:IRRITABLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU131', 143, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:INFLATED ESTEEM');
add_assessment_code(v_id1, owner_id, owner_id, 'CU131', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU131', 1, 'Some', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU131', 2, 'Definate', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU130', 142, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:RACING THOUGHTS');
add_assessment_code(v_id1, owner_id, owner_id, 'CU130', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU130', 1, 'Some', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU130', 2, 'Definate', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU133', 145, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:DISTRACTABILITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU132', 144, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:DECREASED SLEEP');

add_assessment_score(v_id1, owner_id, owner_id, 'CU135', 147, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:GLOBAL RATING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU134', 146, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:POOR JUDGMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU137', 149, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP TOTAL NUMBER OF SYMPTOMS GE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CU136', 148, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYNDROME-EUPHORIC MOOD GE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CU139', 151, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYNDROME:PRECIPITANTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU138', 150, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CRITERIA MET:MANIC SYNDROME?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU281', 293, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS III DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CU257', 269, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:HALLUCINOGENS USE');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4E', 299, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV ECONOMIC PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4D', 298, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV HOUSING PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4G', 301, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV LEGAL SYSTEM PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU228', 240, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS USE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU93', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALOGIA:BLOCKING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU92', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALOGIA:POVERTY OF CONTENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU91', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALOGIA:POVERTY OF SPEECH');

add_assessment_score(v_id1, owner_id, owner_id, 'CU90', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP CATATONIC MOTOR:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU97', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALOGIA:PHONE INTERVIEW?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU96', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALOGIA:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU95', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALOGIA:PERSEVERATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CU94', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALOGIA:INCREASED LATENCY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU99', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FLATTENING/BLUNTING:DECR MOVEMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU98', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FLATTENING/BLUNTING:UNCHANGE FACE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU267', 279, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:MARIJUANA TOLERANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU31', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:BIZARRE/FANTASTIC');

add_assessment_score(v_id1, owner_id, owner_id, 'CU30', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:FRAGMENTARY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU33', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:MANIC-CONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU32', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:DURING MANIC');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SECOND RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU34', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:MANIC-INCONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU37', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:DEPRESSIVE-INCONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU36', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DELUSIONS:DEPRESSIVE-CONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU39', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES COMMENTING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU38', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:AUDITORY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU251', 263, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU265', 277, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:MARIJUANA DUR. IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU252', 264, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:PCP USE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU7', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:PHONE SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU6', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:FACE TO FACE SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU5', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP RELATIONSHIP INFORMANT TO PROBAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CU4', 16, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DATE OF DEATH');

add_assessment_score(v_id1, owner_id, owner_id, 'CU3', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP IS SUBJECT DECEASED?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU127', 139, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC NATURE OF MOOD:EXPANSIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU124', 136, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC DURATION:WEEKS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU125', 137, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC NATURE OF MOOD:EUPHORIC');

add_assessment_score(v_id1, owner_id, owner_id, 'CU128', 140, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:INCREASED ACTIVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU129', 141, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC SYMPTOMS:INCREASED TALK');

add_assessment_score(v_id1, owner_id, owner_id, 'CU9', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:FACE TO FACE RELATIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU8', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INFO SOURCE:LETTER FROM SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU218', 230, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:PHYSICAL COMPLICATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU219', 231, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:EVER USED?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU200', 212, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:LEGAL DIFFICULTIES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU214', 226, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:ORGANIC SYNDROMES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU215', 227, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:WITHDRAWAL SEIZURES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU216', 228, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:HALLUCINOSIS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU217', 229, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:AMNESTIC SYNDROME');

add_assessment_score(v_id1, owner_id, owner_id, 'CU210', 222, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:ANXIETY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU211', 223, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:DEPRESSED MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CU212', 224, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:HYPOTENSION');

add_assessment_score(v_id1, owner_id, owner_id, 'CU213', 225, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:ALCOHOL DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU233', 245, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS TOLERANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4H', 302, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV OTHER PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'CU244', 256, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES USE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU44', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-MALE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU45', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-FEMALE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU46', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-FAMILIAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CU47', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-UNFAMILIAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CU40', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES CONVERSING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU41', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES HEARD?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU42', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-GOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CU43', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-SATAN');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU48', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-CRITICAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU49', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-COMPLEMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU122', 134, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MANIC EUPHORIC MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CU119', 131, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ROLE OF PRECIPITANTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU118', 130, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP POSITIVE SX RATED 3 OR GREATER?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU117', 129, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ATTENTION:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU116', 128, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ATTENTION:INATTENTIVE TESTING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU115', 127, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ATTENTION:SOCIAL INATTENTIVENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU114', 126, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ANHEDONIA-ASOCIAL:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU113', 125, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ANHEDONIA-ASOCIAL:REL W/FRIENDS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU112', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ANHEDONIA-ASOCIAL:INTIMACY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU111', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ANHEDONIA-ASOCIAL:SEX. INTEREST');

add_assessment_score(v_id1, owner_id, owner_id, 'CU110', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ANHEDONIA-ASOCIAL:REC. INTEREST');

add_assessment_score(v_id1, owner_id, owner_id, 'CU197', 209, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:VIOLENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU196', 208, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:EVIDENCE OF PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU195', 207, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:NONBEVERAGE ALCOHOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU194', 206, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:EXACERBATED');

add_assessment_score(v_id1, owner_id, owner_id, 'CU193', 205, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:BLACKOUTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU192', 204, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:FIFTH');

add_assessment_score(v_id1, owner_id, owner_id, 'CU191', 203, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:BINGES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU190', 202, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:REPEATED EFFORTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU261', 273, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:HALLUCINOGENS CURRENT ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU260', 272, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:HALLUCINOGENS DUR. IMPAIR.');

add_assessment_score(v_id1, owner_id, owner_id, 'CU263', 275, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:MARIJUANA USE PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU262', 274, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:MARIJUANA USE');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 7, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP TYPE OF SUBJECT');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU264', 276, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:MARIJUANA IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU199', 211, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:LOSS OF JOB');

add_assessment_score(v_id1, owner_id, owner_id, 'CU198', 210, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:ABSENCE FROM WORK');

add_assessment_score(v_id1, owner_id, owner_id, 'CU280', 292, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS III DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CU235', 247, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:OPIOIDS DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU57', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:SOMATIC/TACTILE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU56', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-RIGHT SIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU55', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-LEFT SIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU54', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-OUTSIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU53', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-INSIDE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU52', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-SAME');

add_assessment_score(v_id1, owner_id, owner_id, 'CU51', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-MULTIPLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU50', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VOICES-COMMANDING');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DATE FORM WAS DONE');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4F', 300, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV HEALTH CARE PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU279', 291, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS III DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CU59', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:VISUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU58', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:OLFACTORY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU108', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AVOLITION-APATHY:PHYSICAL ANERGIA');

add_assessment_score(v_id1, owner_id, owner_id, 'CU109', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AVOLITION-APATHY:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU227', 239, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU202', 214, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:DURATION DISTURBANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU100', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FLATTENING/BLUNTING:EXPR PAUCITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU101', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FLATTENING/BLUNTING:POOR EYE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU102', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FLATTENING/BLUNT:NONRESPONSIVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU103', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FLATTENING/BLUNTING:LACK OF VOCAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU104', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP FLATTENING/BLUNTING:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU105', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP INAPPROPRIATE AFFECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU106', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AVOLITION-APATHY:HYGIENE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU107', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AVOLITION-APATHY:IMPERSISTENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU180', 192, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:UNUSUAL PERCEPTION');

add_assessment_score(v_id1, owner_id, owner_id, 'CU181', 193, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:UNDUE SOCIAL ANXIETY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU182', 194, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:ODD SPEECH');

add_assessment_score(v_id1, owner_id, owner_id, 'CU183', 195, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:SOCIAL ISOLATION');

add_assessment_score(v_id1, owner_id, owner_id, 'CU184', 196, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:INADEQUATE RAPPORT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU185', 197, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:PECULIAR BEHAVIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'CU186', 198, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:IMPAIRMENT-ROLE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU187', 199, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:IMPAIRMENT-HYGIENE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU188', 200, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:NEED DAILY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU189', 201, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:INABILITY TO STOP');

add_assessment_score(v_id1, owner_id, owner_id, 'CU270', 282, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP NUMBER OF AXIS I DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU271', 283, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS I DIAGNOSES-1');

add_assessment_score(v_id1, owner_id, owner_id, 'CU276', 288, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS II DIAGNOSES-2');

add_assessment_score(v_id1, owner_id, owner_id, 'CU277', 289, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS II DIAGNOSES-3');

add_assessment_score(v_id1, owner_id, owner_id, 'CU274', 286, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP NUMBER OF AXIS II DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CU206', 218, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:TREMORS');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU226', 238, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:BARBITURATES WITHDRAWAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU205', 217, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:WITHDRAWAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU204', 216, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:TOLERANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU207', 219, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:NAUSEA &''||'' VOMITING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU268', 280, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:MARIJUANA DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU62', 74, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:PERSISTENCE');
add_assessment_code(v_id1, owner_id, owner_id, 'CU62', 0, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU62', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU62', 2, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU63', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:FRAGMENTARY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU60', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:GLOBAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU61', 73, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:SENSORIUM');
add_assessment_code(v_id1, owner_id, owner_id, 'CU61', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU61', 1, 'Questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU61', 2, 'Definite Physical', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU61', 3, 'Definite Not Physical', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CU66', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:MANIC-INCONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU67', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:DURING DEPRESSION');

add_assessment_score(v_id1, owner_id, owner_id, 'CU64', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:DURING MANIC');

add_assessment_score(v_id1, owner_id, owner_id, 'CU65', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:MANIC-CONGRUENT');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4C', 297, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV OCCUPATIONAL PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU68', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:DEPRESSIVE-CONG');

add_assessment_score(v_id1, owner_id, owner_id, 'CU69', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP HALLUCINATIONS:DEPRESSIVE-INCONG');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CU247', 259, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES DUR IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU246', 258, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES IMPAIRMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CU245', 257, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES USE PATTERN');

add_assessment_score(v_id1, owner_id, owner_id, 'CU208', 220, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP ALCOHOLISM:MALAISE OR WEAKNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU243', 255, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU242', 254, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE WITHDRAWAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CU241', 253, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE TOLERANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU240', 252, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:COCAINE CURRENTLY ABUSES?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU249', 261, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES TOLERANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU248', 260, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP DRUGS:AMPHETAMINES CURRENT ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'CU179', 191, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:SUSPICIOUSNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU178', 190, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:IDEAS OF REFERENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'AXIS4B', 296, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP AXIS IV EDUCATIONAL PROBLEMS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU175', 187, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE PRECIPITANTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU174', 186, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE GLOBAL RATING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU177', 189, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP SCHIZOTYPAL:MAGICAL THINKING');

add_assessment_score(v_id1, owner_id, owner_id, 'CU176', 188, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE ORGANIC FACTORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CU171', 183, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DISTINCT QUALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'CU170', 182, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE CRITERIA MET?');

add_assessment_score(v_id1, owner_id, owner_id, 'CU173', 185, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE DIURNAL VAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CU172', 184, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASHUP MAJOR DEPRESSIVE NONREACTIVITY');
add_assessment_code(v_id1, owner_id, owner_id, 'CU172', 0, 'Very', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU172', 1, 'Usual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU172', 2, 'Often', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU172', 3, 'Slightly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU172', 4, 'Rarely', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CU172', 5, 'None', 'integer');

commit;
END;
/
