set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '2142241',
      21,
      1,
      NULL,
      0,
      '011324',
      0,
      NULL,
      13.146317,
      NULL,
      0.093412,
      NULL,
      0.680752,
      NULL,
      0,
      1.991790,
      NULL,
      2,
      0.671802,
      0.389945,
      0,
      NULL,
      3.566932,
      0.371247,
      1,
      1.445672,
      1,
      0.557943,
      0.244024,
      0.827478,
      1,
      0,
      1,
      1,
      0.596499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.447367,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.259098,
      0.072930,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973661,
      1,
      1.739258,
      1.255600,
      1,
      0.768670,
      1,
      0,
      1.742244,
      0,
      1,
      0,
      0,
      1,
      0.403167,
      0,
      1.548737,
      0.960003,
      1.162614,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.435234,
      1,
      2,
      1,
      0,
      NULL,
      1,
      2,
      3,
      NULL,
      1,
      5.953416,
      3.210336,
      4,
      4.091046,
      0.753110,
      NULL,
      1,
      3.114905,
      1.125914,
      1.107404,
      1,
      0,
      NULL,
      NULL,
      6.840591,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707893,
      0,
      0,
      NULL,
      0.603418,
      NULL,
      1.394799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111266,
      NULL,
      8,
      2,
      0,
      1.923349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.002333,
      1,
      0,
      2,
      1,
      1.071615,
      NULL,
      NULL,
      NULL,
      NULL,
      2.266042,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089727,
      1,
      2,
      NULL,
      0,
      1.497157,
      0.242050,
      1.874768,
      0.946371,
      2.929517,
      1.749196,
      0,
      0.521591,
      NULL,
      1,
      1.042184,
      1,
      0,
      1.875316,
      1.793345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735312,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536041,
      1.621222,
      NULL,
      NULL,
      0.068686,
      0,
      NULL,
      0.804519,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.767571,
      NULL,
      NULL,
      0.075307,
      1.951086,
      0.782422,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.470123,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


