set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '3301414',
      NULL,
      0,
      0.812594,
      3,
      '010401',
      1.728770,
      NULL,
      6,
      NULL,
      0.214234,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      3.790701,
      1,
      NULL,
      2.009415,
      1.765089,
      0,
      1.705496,
      NULL,
      1.020918,
      NULL,
      NULL,
      0,
      1,
      0.292556,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281314,
      NULL,
      NULL,
      1.049094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.702378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291060,
      1,
      NULL,
      0.858693,
      0,
      0,
      1,
      NULL,
      0.065739,
      1,
      1,
      0,
      0.179879,
      0,
      0,
      0,
      1.995324,
      1.941966,
      NULL,
      NULL,
      0.873227,
      3.547918,
      0.959766,
      0.226905,
      0.898890,
      0.703348,
      3.778134,
      0,
      NULL,
      1.341958,
      0.693716,
      NULL,
      4,
      0.710472,
      3.819372,
      NULL,
      0,
      6,
      5,
      3.533537,
      1.828962,
      1.930115,
      NULL,
      2,
      5,
      3,
      0.985034,
      1.444501,
      0,
      NULL,
      NULL,
      0.502050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.760605,
      1,
      1,
      0,
      0.600051,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.862390,
      2.473337,
      1.927983,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966628,
      0,
      8,
      0,
      3.006247,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003685,
      3.619751,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373185,
      1,
      1,
      0.024334,
      3.093662,
      NULL,
      0,
      3.831442,
      1.476994,
      1.118548,
      0,
      NULL,
      1,
      0.822109,
      0.379573,
      0,
      1.439734,
      0.445005,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      1.053533,
      NULL,
      0.668113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.348985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      4,
      1.389016,
      0,
      0.478064,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.651500,
      1,
      8,
      0,
      1,
      2.008249,
      2,
      2.244154,
      '42312',
      '04111',
      NULL,
      1.401756,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


