set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '1010230',
      NULL,
      0,
      1.095207,
      NULL,
      '121242',
      NULL,
      ' 0-18-1990',
      35.799375,
      NULL,
      1,
      NULL,
      1,
      2,
      0,
      0,
      1,
      0,
      1,
      0.942709,
      NULL,
      1,
      3.490510,
      1.236025,
      NULL,
      0,
      1.137444,
      0,
      3.229208,
      0.144753,
      0,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.247743,
      1.283895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997931,
      NULL,
      2.474228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.409225,
      1,
      1,
      1.849497,
      2.056187,
      0,
      1,
      NULL,
      1.626274,
      0,
      1.050022,
      NULL,
      1.314115,
      NULL,
      0.729265,
      1.512040,
      1,
      NULL,
      0,
      0,
      1,
      1.100378,
      0.550535,
      1,
      0.818422,
      NULL,
      0.682642,
      NULL,
      1.624839,
      2.183469,
      0.879802,
      0.428307,
      3.367213,
      1,
      5,
      3,
      1,
      9,
      7.747760,
      7.883512,
      5.726155,
      6.236787,
      NULL,
      2.198210,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.531413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123065,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.449416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.765724,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.166058,
      0.037526,
      NULL,
      NULL,
      NULL,
      1.648945,
      1,
      3.645945,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.163084,
      NULL,
      1.310408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.254368,
      1.030735,
      0,
      3,
      2,
      1.480440,
      0,
      2.549968,
      NULL,
      2,
      0.732384,
      3.202167,
      1,
      1.446782,
      1.755321,
      0.231648,
      NULL,
      1.906996,
      NULL,
      1,
      3,
      0.318674,
      0.736542,
      2,
      0.708738,
      NULL,
      NULL,
      1.874372,
      NULL,
      NULL,
      0.399124,
      1.719879,
      NULL,
      1.944596,
      NULL,
      0.946934,
      1.744613,
      0.064562,
      0.391536,
      0.543892,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950770,
      0.754463,
      3.976664,
      2,
      0,
      2,
      0,
      3.931466,
      '02121',
      '30344',
      '04403',
      0.902953,
      '',
      NULL,
      '',
      0.641640,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


